/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdelaunay.delaunay.Boundary;
import org.jdelaunay.delaunay.BoundaryPart;
import org.jdelaunay.delaunay.VerticalComparator;
import org.jdelaunay.delaunay.VerticalList;
import org.jdelaunay.delaunay.VoronoiGraph;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.evaluator.InsertionEvaluator;
import org.jdelaunay.delaunay.geometries.ConstraintPolygon;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.geometries.DTriangle;
import org.jdelaunay.delaunay.geometries.Element;
import org.jdelaunay.delaunay.tools.Tools;

public class ConstrainedMesh
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = Logger.getLogger(ConstrainedMesh.class);
    private List<DTriangle> triangleList = new ArrayList<DTriangle>();
    private List<DEdge> edges = new ArrayList<DEdge>();
    private List<DPoint> points;
    private List<DEdge> constraintEdges = new ArrayList<DEdge>();
    private List<ConstraintPolygon> polygons;
    private double precision = 0.0;
    private double tolerance = 1.0E-7;
    private transient List<DEdge> badEdgesQueueList;
    private boolean meshComputed = false;
    private boolean verbose;
    private int pointGID = 0;
    private int edgeGID = 0;
    private int triangleGID = 0;
    private Map<Integer, Integer> weights;
    private transient Map<Integer, DTriangle> processed = null;
    private transient Map<Integer, DTriangle> remaining = null;
    private transient Map<Integer, DTriangle> buffer = null;
    public static final int MIN_POINTS_NUMBER = 3;
    public static final int MAXITER = 5;
    public static final int REFINEMENT_MAX_AREA = 1;
    public static final int REFINEMENT_MIN_ANGLE = 2;
    public static final int REFINEMENT_SOFT_INTERPOLATE = 4;
    public static final int REFINEMENT_OBTUSE_ANGLE = 8;
    private Double extMinX = null;
    private Double extMaxY = null;
    private Double extMinY = null;

    public ConstrainedMesh() {
        this.points = new ArrayList<DPoint>();
        this.polygons = new ArrayList<ConstraintPolygon>();
        this.weights = new HashMap<Integer, Integer>();
        this.badEdgesQueueList = new LinkedList<DEdge>();
    }

    public final List<DEdge> getConstraintEdges() {
        return this.constraintEdges;
    }

    public final void setConstraintEdges(ArrayList<DEdge> constraint) throws DelaunayError {
        this.constraintEdges = new ArrayList<DEdge>();
        for (DEdge e : constraint) {
            e.setLocked(true);
            this.fixConstraintDirection(e);
            this.addConstraintEdge(e);
        }
    }

    public final void addConstraintEdge(DEdge e) throws DelaunayError {
        if (this.constraintEdges == null) {
            this.constraintEdges = new ArrayList<DEdge>();
        }
        this.fixConstraintDirection(e);
        int index = Collections.binarySearch(this.points, e.getStartPoint());
        if (index < 0) {
            this.updateExtensionPoints(e.getStartPoint());
            this.points.add(-index - 1, e.getStartPoint());
            ++this.pointGID;
            e.getStartPoint().setGID(this.pointGID);
        } else {
            e.setStartPoint(this.points.get(index));
        }
        if (e.getStartPoint().equals(e.getEndPoint())) {
            return;
        }
        e.setLocked(true);
        this.addEdgeToLeftSortedList(this.constraintEdges, e);
        index = Collections.binarySearch(this.points, e.getEndPoint());
        if (index < 0) {
            this.updateExtensionPoints(e.getEndPoint());
            this.points.add(-index - 1, e.getEndPoint());
            ++this.pointGID;
            e.getEndPoint().setGID(this.pointGID);
        } else {
            e.setEndPoint(this.points.get(index));
        }
    }

    public final List<DEdge> getEdges() {
        return this.edges;
    }

    public final void setEdges(List<DEdge> inEdges) throws DelaunayError {
        this.edges = new ArrayList<DEdge>();
        for (DEdge e : inEdges) {
            this.addPoint(e.getStartPoint());
            this.addPoint(e.getEndPoint());
            this.addEdge(e);
        }
    }

    public final void addEdge(DEdge e) {
        int constraintIndex;
        if (this.edges == null) {
            this.edges = new ArrayList<DEdge>();
        }
        if ((constraintIndex = this.sortedListContains(this.constraintEdges, e)) < 0) {
            this.addEdgeToLeftSortedList(this.edges, e);
            ++this.edgeGID;
            e.setGID(this.edgeGID);
        } else {
            this.addEdgeToLeftSortedList(this.edges, this.constraintEdges.get(constraintIndex));
        }
    }

    public final void removeEdge(DEdge e) {
        int index = Collections.binarySearch(this.edges, e);
        if (index >= 0) {
            this.edges.remove(index);
        }
    }

    public final List<DEdge> sortEdgesLeft(List<DEdge> inputList) {
        ArrayList<DEdge> outputList = new ArrayList<DEdge>();
        for (DEdge e : inputList) {
            this.addEdgeToLeftSortedList(outputList, e);
        }
        return outputList;
    }

    private boolean addEdgeToLeftSortedList(List<DEdge> sorted, DEdge edge) {
        return this.addToSortedList(edge, sorted);
    }

    public final int searchEdge(DEdge edge) {
        return Collections.binarySearch(this.edges, edge);
    }

    public final double getPrecision() {
        return this.precision;
    }

    public final void setPrecision(double precision) {
        this.precision = precision;
    }

    public final double getTolerance() {
        return this.tolerance;
    }

    public final void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public final List<DTriangle> getTriangleList() {
        return this.triangleList;
    }

    public final void addTriangle(DTriangle triangle) {
        this.triangleList.add(triangle);
        ++this.triangleGID;
        triangle.setGID(this.triangleGID);
    }

    public final boolean containsTriangle(DTriangle tri) {
        return this.triangleList.contains(tri);
    }

    public final void removeTriangle(DTriangle tri) {
        this.triangleList.remove(tri);
    }

    public final List<DPoint> getPoints() {
        return this.points;
    }

    public final DPoint getPoint(double x, double y, double z) throws DelaunayError {
        DPoint pt = new DPoint(x, y, z);
        int c = this.listContainsPoint(pt);
        if (c < 0) {
            return null;
        }
        return this.points.get(c);
    }

    public final boolean isMeshComputed() {
        return this.meshComputed;
    }

    private void setMeshComputed(boolean comp) {
        this.meshComputed = comp;
    }

    public final Envelope getBoundingBox() {
        Envelope env = new Envelope();
        for (DPoint p : this.points) {
            env.expandToInclude(p.getCoordinate());
        }
        return env;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean verb) {
        this.verbose = verb;
    }

    public final void setPoints(List<DPoint> pts) throws DelaunayError {
        if (pts == null) {
            this.points = new ArrayList<DPoint>();
        } else {
            Collections.sort(pts);
            this.extMaxY = null;
            this.extMinY = null;
            this.extMinX = null;
            for (DPoint pt : pts) {
                this.updateExtensionPoints(pt);
            }
            this.points = pts;
            ListIterator<DPoint> iter = this.points.listIterator();
            if (iter.hasNext()) {
                DPoint e1 = iter.next();
                while (iter.hasNext()) {
                    DPoint e2 = e1;
                    e1 = iter.next();
                    if (!e1.equals(e2)) continue;
                    iter.remove();
                }
            }
        }
    }

    public final void addPoint(DPoint point) throws DelaunayError {
        if (this.points == null) {
            this.points = new ArrayList<DPoint>();
        }
        this.updateExtensionPoints(point);
        boolean res = this.addToSortedList(point, this.points);
        if (res) {
            ++this.pointGID;
            point.setGID(this.pointGID);
        }
    }

    public final List<DPoint> getExtensionPoints() throws DelaunayError {
        ArrayList<DPoint> ret = new ArrayList<DPoint>();
        ret.add(new DPoint(this.extMinX, this.extMaxY, 0.0));
        ret.add(new DPoint(this.extMinX, this.extMinY, 0.0));
        return ret;
    }

    private void updateExtensionPoints(DPoint pt) throws DelaunayError {
        if (this.extMinX == null) {
            if (!this.points.isEmpty()) {
                throw new DelaunayError("we should have added this coordinate before !");
            }
            this.extMinX = pt.getX() - 1.0;
        } else if (pt.getX() < this.extMinX + 1.0) {
            this.extMinX = pt.getX() - 1.0;
        }
        if (this.extMinY == null) {
            if (!this.points.isEmpty()) {
                throw new DelaunayError("we should have added this coordinate before !");
            }
            this.extMinY = pt.getY() - 1.0;
            this.extMaxY = pt.getY() + 1.0;
        } else if (pt.getY() > this.extMaxY - 1.0) {
            this.extMaxY = pt.getY() + 1.0;
        } else if (pt.getY() < this.extMinY + 1.0) {
            this.extMinY = pt.getY() - 1.0;
        }
    }

    private <T extends Element> boolean addToSortedList(T elt, List<T> sortedList) {
        int index = Collections.binarySearch(sortedList, elt);
        if (index < 0) {
            int insertPos = -index - 1;
            sortedList.add(insertPos, elt);
            return true;
        }
        return false;
    }

    public final int listContainsPoint(DPoint p) {
        return this.sortedListContains(this.points, p);
    }

    public final Map<Integer, Integer> getWeights() {
        return this.weights;
    }

    public final void setWeights(Map<Integer, Integer> weights) {
        this.weights = weights == null ? new HashMap<Integer, Integer>() : weights;
    }

    private <T extends Element> int sortedListContains(List<T> sortedList, T elt) {
        int index = Collections.binarySearch(sortedList, elt);
        return index < 0 ? -1 : index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void forceConstraintIntegrity() throws DelaunayError {
        if (this.constraintEdges.size() < 1) {
            return;
        }
        this.edgeGID = 0;
        List<DPoint> eventPoints = this.points;
        DPoint currentEvent = null;
        VerticalList edgeBuffer = new VerticalList(0.0);
        List<DEdge> edgeMemory = this.constraintEdges;
        this.constraintEdges = new ArrayList<DEdge>();
        int j = 0;
        DEdge inter1 = null;
        DEdge inter2 = null;
        DEdge inter3 = null;
        DEdge inter4 = null;
        DPoint newEvent = null;
        DEdge edgeEvent = null;
        DPoint leftMost = null;
        DPoint rightMost = null;
        Element intersection = null;
        DEdge currentMemEdge = null;
        int memoryPos = 0;
        for (int i = 0; i < eventPoints.size(); ++i) {
            int maxWeight = Integer.MIN_VALUE;
            Double z = Double.NaN;
            currentEvent = eventPoints.get(i);
            double abs = currentEvent.getX();
            edgeBuffer.setAbs(abs);
            if (currentMemEdge == null) {
                currentMemEdge = edgeMemory.get(0);
            }
            while (memoryPos < edgeMemory.size() && currentEvent.equals2D((currentMemEdge = edgeMemory.get(memoryPos)).getPointLeft())) {
                edgeBuffer.addEdge(currentMemEdge);
                ++memoryPos;
            }
            if (edgeBuffer.size() > 1) {
                DEdge e2 = edgeBuffer.get(0);
                j = 1;
                while (j < edgeBuffer.size()) {
                    DEdge rm;
                    j = j < 1 ? 1 : j;
                    DEdge e1 = edgeBuffer.get(j - 1);
                    e2 = edgeBuffer.get(j);
                    intersection = e1.getIntersection(e2, this.weights);
                    int rmCount = 0;
                    if (intersection instanceof DPoint) {
                        newEvent = (DPoint)intersection;
                        if (!e1.isExtremity(newEvent) || !e2.isExtremity(newEvent)) {
                            if (newEvent.equals2D(currentEvent)) {
                                if (!this.weights.isEmpty()) {
                                    int w1 = e1.getMaxWeight(this.weights);
                                    int w2 = e2.getMaxWeight(this.weights);
                                    if (w1 < maxWeight && w2 < maxWeight) {
                                        if (Double.isNaN(z)) {
                                            throw new DelaunayError("you're not supposed to have a NaN here !");
                                        }
                                        newEvent.setZ(z);
                                    } else {
                                        maxWeight = Math.max(w1, w2);
                                        z = newEvent.getZ();
                                        currentEvent.setZ(z);
                                    }
                                }
                                newEvent.setX(abs);
                                ArrayList<DEdge> toBeInsert = new ArrayList<DEdge>();
                                if (!newEvent.equals2D(e2.getPointLeft()) && !newEvent.equals2D(e2.getPointRight())) {
                                    if (newEvent.equals2D(e1.getPointLeft())) {
                                        newEvent = e1.getPointLeft();
                                    }
                                    if (newEvent.equals2D(e1.getPointRight())) {
                                        newEvent = e1.getPointRight();
                                    }
                                    inter2 = new DEdge(newEvent, e2.getPointLeft());
                                    inter2.setProperty(e2.getProperty());
                                    this.addConstraintEdge(inter2);
                                    rm = edgeBuffer.remove(j);
                                    if (!rm.equals(e2)) {
                                        throw new DelaunayError(203);
                                    }
                                    inter4 = new DEdge(newEvent, e2.getPointRight());
                                    inter4.setProperty(e2.getProperty());
                                    toBeInsert.add(inter4);
                                    ++rmCount;
                                } else if (newEvent.equals2D(e2.getPointRight())) {
                                    this.addConstraintEdge(e2);
                                    rm = edgeBuffer.remove(j);
                                    if (!rm.equals(e2)) {
                                        throw new DelaunayError(203);
                                    }
                                    ++rmCount;
                                }
                                if (!newEvent.equals2D(e1.getPointLeft()) && !newEvent.equals2D(e1.getPointRight())) {
                                    if (newEvent.equals2D(e2.getPointLeft())) {
                                        newEvent = e2.getPointLeft();
                                    }
                                    if (newEvent.equals2D(e2.getPointRight())) {
                                        newEvent = e2.getPointRight();
                                    }
                                    inter1 = new DEdge(e1.getPointLeft(), newEvent);
                                    inter1.setProperty(e1.getProperty());
                                    this.addConstraintEdge(inter1);
                                    rm = edgeBuffer.remove(j - 1);
                                    if (!rm.equals(e1)) {
                                        throw new DelaunayError(203);
                                    }
                                    inter3 = new DEdge(e1.getPointRight(), newEvent);
                                    inter3.setProperty(e1.getProperty());
                                    toBeInsert.add(inter3);
                                    ++rmCount;
                                } else if (newEvent.equals2D(e1.getPointRight())) {
                                    this.addConstraintEdge(e1);
                                    rm = edgeBuffer.remove(j - 1);
                                    if (!rm.equals(e1)) {
                                        throw new DelaunayError(203);
                                    }
                                    ++rmCount;
                                }
                                for (DEdge yed : toBeInsert) {
                                    edgeBuffer.addEdge(yed);
                                }
                                j = j - rmCount < 0 ? 0 : j - rmCount;
                            } else {
                                this.ensurePointPosition(e2, newEvent);
                                this.ensurePointPosition(e1, newEvent);
                                this.addToSortedList(newEvent, eventPoints);
                            }
                        } else {
                            if (e2.getPointRight().equals2D(currentEvent)) {
                                this.addConstraintEdge(e2);
                                rm = edgeBuffer.remove(j);
                                if (!rm.equals(e2)) {
                                    throw new DelaunayError(203);
                                }
                                ++rmCount;
                            } else if (e1.getPointRight().equals2D(currentEvent)) {
                                this.addConstraintEdge(e1);
                                rm = edgeBuffer.remove(j - 1);
                                if (!rm.equals(e1)) {
                                    throw new DelaunayError(203);
                                }
                                ++rmCount;
                                --j;
                            }
                            j = j - rmCount < 0 ? 0 : j - rmCount;
                        }
                    } else if (intersection instanceof DEdge) {
                        int mem;
                        edgeEvent = (DEdge)intersection;
                        newEvent = edgeEvent.getPointLeft();
                        if (!newEvent.equals2D(currentEvent)) throw new DelaunayError("We should already be on this event point");
                        leftMost = e1.getPointLeft().compareTo2D(e2.getPointLeft()) < 1 ? e1.getPointLeft() : e2.getPointLeft();
                        rightMost = e1.getPointRight().compareTo2D(e2.getPointRight()) < 1 ? e2.getPointRight() : e1.getPointRight();
                        inter1 = null;
                        inter2 = null;
                        inter3 = null;
                        rm = edgeBuffer.remove(j);
                        if (!rm.equals(e2)) {
                            throw new DelaunayError(203);
                        }
                        rm = edgeBuffer.remove(j - 1);
                        if (!rm.equals(e1)) {
                            throw new DelaunayError(203);
                        }
                        --j;
                        inter2 = edgeEvent;
                        if (leftMost.compareTo2D(newEvent) == -1) {
                            inter1 = new DEdge(leftMost, newEvent);
                            if (e1.getPointLeft().equals(leftMost)) {
                                inter1.addProperty(e1.getProperty());
                            } else if (e2.getPointLeft().equals(leftMost)) {
                                inter2.addProperty(e2.getProperty());
                            }
                        }
                        inter2.addProperty(e1.getProperty());
                        inter2.addProperty(e2.getProperty());
                        if (rightMost.compareTo2D(edgeEvent.getPointRight()) == 1) {
                            inter3 = new DEdge(edgeEvent.getPointRight(), rightMost);
                            if (e1.getPointRight().equals(rightMost)) {
                                inter3.addProperty(e1.getProperty());
                            } else if (e2.getPointRight().equals(rightMost)) {
                                inter3.addProperty(e2.getProperty());
                            }
                        }
                        if (inter1 != null) {
                            if (inter1.getPointRight().compareTo2D(currentEvent) == 1) {
                                this.addConstraintEdge(inter1);
                            } else {
                                mem = edgeBuffer.addEdge(inter1);
                                int n = j = j <= mem ? j : mem;
                            }
                        }
                        if (inter2.getPointRight().compareTo2D(currentEvent) == 1) {
                            mem = edgeBuffer.addEdge(inter2);
                            j = j <= mem ? j : mem;
                        } else {
                            this.addConstraintEdge(inter2);
                        }
                        if (inter3 != null) {
                            this.addEdgeToLeftSortedList(edgeMemory, inter3);
                        }
                        j = j - 2 < 0 ? 0 : j - 2;
                    } else if (e1.contains(currentEvent) && !e1.isExtremity(currentEvent)) {
                        int w;
                        DEdge inter = new DEdge(e1.getPointLeft(), currentEvent);
                        inter.setProperty(e1.getProperty());
                        inter.setLocked(e1.isLocked());
                        this.addConstraintEdge(inter);
                        if (e1.getStartPoint().equals(e1.getPointLeft())) {
                            e1.setStartPoint(currentEvent);
                        } else {
                            e1.setEndPoint(currentEvent);
                        }
                        if (!this.weights.isEmpty() && (w = e1.getMaxWeight(this.weights)) > maxWeight) {
                            maxWeight = w;
                        }
                    } else if (e1.getPointRight().equals2D(currentEvent)) {
                        this.addConstraintEdge(e1);
                        rm = edgeBuffer.remove(j - 1);
                        if (!rm.equals(e1)) {
                            throw new DelaunayError(203);
                        }
                        j = --j - 1 < 0 ? 0 : j - 1;
                    }
                    if (edgeBuffer.size() <= 0 || ++j < edgeBuffer.size()) continue;
                    e2 = edgeBuffer.get(edgeBuffer.size() - 1);
                    if (e2.contains(currentEvent) && !e2.isExtremity(currentEvent)) {
                        DEdge temp = new DEdge(e2.getPointLeft(), currentEvent);
                        temp.setLocked(e2.isLocked());
                        temp.setProperty(e2.getProperty());
                        this.addConstraintEdge(temp);
                        if (e2.getStartPoint().equals(e2.getPointLeft())) {
                            e2.setStartPoint(currentEvent);
                        } else {
                            e2.setEndPoint(currentEvent);
                        }
                    }
                    if (!e2.getPointRight().equals(currentEvent)) continue;
                    edgeBuffer.remove(edgeBuffer.size() - 1);
                    this.addConstraintEdge(e2);
                }
                continue;
            }
            if (edgeBuffer.size() != 1) continue;
            DEdge e0 = edgeBuffer.get(0);
            if (e0.contains(currentEvent) && !e0.isExtremity(currentEvent)) {
                DEdge temp = new DEdge(e0.getPointLeft(), currentEvent);
                temp.setLocked(e0.isLocked());
                temp.setProperty(e0.getProperty());
                this.addConstraintEdge(temp);
                if (e0.getStartPoint().equals(e0.getPointLeft())) {
                    e0.setStartPoint(currentEvent);
                    continue;
                }
                e0.setEndPoint(currentEvent);
                continue;
            }
            if (!e0.getPointRight().equals2D(currentEvent)) continue;
            this.addConstraintEdge(edgeBuffer.get(0));
            edgeBuffer.remove(0);
        }
    }

    private void ensurePointPosition(DEdge e, DPoint p) {
        if (e.getStartPoint().equals2D(p)) {
            e.getStartPoint().setX(p.getX());
            e.getStartPoint().setY(p.getY());
        }
        if (e.getEndPoint().equals2D(p)) {
            e.getEndPoint().setX(p.getX());
            e.getEndPoint().setY(p.getY());
        }
    }

    public final void sortEdgesVertically(List<DEdge> edgeList, DPoint p) throws DelaunayError {
        this.sortEdgesVertically(edgeList, p.getX());
    }

    public final void sortEdgesVertically(List<DEdge> edgeList, double abs) throws DelaunayError {
        int s = edgeList.size();
        int i = 0;
        int c = 0;
        while (i < s - 1) {
            DEdge e2;
            DEdge e1 = edgeList.get(i);
            c = e1.verticalSort(e2 = edgeList.get(i + 1), abs);
            if (c == 1) {
                edgeList.set(i, e2);
                edgeList.set(i + 1, e1);
                i = i - 1 < 0 ? 0 : i - 1;
                continue;
            }
            ++i;
        }
    }

    public final int insertEdgeVerticalList(DEdge edge, List<DEdge> edgeList, double abs) throws DelaunayError {
        if (edgeList.isEmpty()) {
            edgeList.add(edge);
        }
        VerticalComparator comparator = new VerticalComparator(abs);
        return Tools.addToSortedList(edge, edgeList, comparator);
    }

    public final boolean intersectsExistingEdges(DEdge edge) throws DelaunayError {
        for (DEdge ed : this.edges) {
            int inter = ed.intersects(edge);
            if (inter != 1 && inter != 4) continue;
            return true;
        }
        return false;
    }

    public final List<DEdge> getConstraintsFromLeftPoint(DPoint left) {
        ArrayList<DEdge> retList = new ArrayList<DEdge>();
        if (this.constraintEdges == null || this.constraintEdges.isEmpty()) {
            return retList;
        }
        int size = this.constraintEdges.size();
        DEdge leftSearch = new DEdge(left, left);
        int index = Collections.binarySearch(this.constraintEdges, leftSearch);
        int n = index = index < 0 ? -index - 1 : index;
        while (index < size && this.constraintEdges.get(index).getPointLeft().equals(left)) {
            retList.add(this.constraintEdges.get(index));
            ++index;
        }
        return retList;
    }

    public final List<DEdge> getConstraintFromLPVertical(DPoint left) {
        List<DEdge> retList = this.getConstraintsFromLeftPoint(left);
        VerticalComparator vc = new VerticalComparator(left.getX());
        Collections.sort(retList, vc);
        if (!retList.isEmpty() && retList.get(0).isVertical()) {
            DEdge tmp = retList.get(0);
            retList.remove(0);
            retList.add(tmp);
        }
        return retList;
    }

    public final void processDelaunay() throws DelaunayError {
        if (this.isMeshComputed()) {
            throw new DelaunayError(102);
        }
        if (this.points.size() < 3) {
            throw new DelaunayError(103);
        }
        this.pointGID = 0;
        for (DPoint pt : this.points) {
            pt.setGID(++this.pointGID);
        }
        this.triangleGID = 0;
        this.badEdgesQueueList = new LinkedList<DEdge>();
        this.edges = new ArrayList<DEdge>();
        this.triangleList = new ArrayList<DTriangle>();
        if (this.verbose) {
            LOG.trace((Object)"Getting points");
        }
        ListIterator<DPoint> iterPoint = this.points.listIterator();
        DPoint p1 = iterPoint.next();
        DPoint p2 = iterPoint.next();
        DEdge e1 = new DEdge(p1, p2);
        e1 = this.replaceByConstraint(e1);
        List<DEdge> fromLeft = this.getConstraintFromLPVertical(p1);
        Boundary bound = this.buildStartBoundary(p1, e1, fromLeft, this.getConstraintFromLPVertical(p2));
        while (iterPoint.hasNext()) {
            p2 = iterPoint.next();
            fromLeft = this.getConstraintFromLPVertical(p2);
            List<DTriangle> tri = bound.insertPoint(p2, fromLeft);
            for (DTriangle t : tri) {
                ++this.triangleGID;
                t.setGID(this.triangleGID);
            }
            this.triangleList.addAll(tri);
            List<DEdge> added = bound.getAddedEdges();
            for (DEdge e : added) {
                ++this.edgeGID;
                e.setGID(this.edgeGID);
            }
            this.edges.addAll(added);
            this.badEdgesQueueList = bound.getBadEdges();
            this.processBadEdges();
        }
        this.meshComputed = true;
        if (this.verbose) {
            LOG.trace((Object)"End processing");
            LOG.trace((Object)"Triangularization end phase : ");
            LOG.trace((Object)("  Points : " + this.points.size()));
            LOG.trace((Object)("  Edges : " + this.edges.size()));
            LOG.trace((Object)("  Triangles : " + this.triangleList.size()));
        }
    }

    public final void removeFlatTriangles() throws DelaunayError {
        if (!this.meshComputed) {
            throw new DelaunayError(102);
        }
        if (!this.triangleList.isEmpty() && this.triangleList.get(0).isSeenForFlatRemoval()) {
            for (DTriangle tri : this.triangleList) {
                tri.setSeenForFlatRemoval(false);
            }
        }
        ArrayList<DPoint> newPoints = new ArrayList<DPoint>();
        for (DTriangle tri : this.triangleList) {
            if (tri.isSeenForFlatRemoval()) continue;
            if (tri.isFlatSlope()) {
                VoronoiGraph vg = new VoronoiGraph(tri);
                vg.fillUntilNotFlatFound();
                vg.assignZValues();
                if (!vg.isUseful()) continue;
                newPoints.addAll(vg.getSkeletonPoints());
                continue;
            }
            tri.setSeenForFlatRemoval(true);
        }
        for (DPoint pt : newPoints) {
            pt.setGID(++this.pointGID);
        }
        this.points.addAll(newPoints);
        Collections.sort(this.points);
        this.setMeshComputed(false);
        this.triangleList = new ArrayList<DTriangle>();
        for (DEdge e : this.constraintEdges) {
            e.setLeft(null);
            e.setRight(null);
            this.fixConstraintDirection(e);
        }
        this.processDelaunay();
    }

    public final void refineMesh(double minLength, InsertionEvaluator ev) throws DelaunayError {
        if (minLength <= 0.0) {
            throw new IllegalArgumentException("The minimum length must be strictly positive !");
        }
        this.edgeSplitting(minLength);
        this.triangleRefinement(minLength, ev);
    }

    public final void refineTriangles(double minLength, InsertionEvaluator ev) throws DelaunayError {
        if (minLength <= 0.0) {
            throw new IllegalArgumentException("The minimum length must be strictly positive !");
        }
        this.processed = new HashMap<Integer, DTriangle>(this.triangleList.size());
        this.remaining = new HashMap<Integer, DTriangle>(this.triangleList.size());
        this.fillRemainingFromTriangles();
        Set<Map.Entry<Integer, DTriangle>> treatSet = this.remaining.entrySet();
        while (!treatSet.isEmpty()) {
            Map.Entry<Integer, DTriangle> entry = treatSet.iterator().next();
            DTriangle dt = entry.getValue();
            if (ev.evaluate(dt)) {
                this.buffer = new HashMap<Integer, DTriangle>();
                DEdge ret = this.insertTriangleCircumCenter(dt, true, minLength);
                this.putInProcessed(dt);
                if (ret != null) continue;
                this.fillRemainingFromTriangles();
                continue;
            }
            this.putInProcessed(dt);
        }
        this.triangleList = new LinkedList<DTriangle>(this.processed.values());
        this.processed = null;
        this.remaining = null;
        this.buffer = null;
    }

    final void edgeSplitting(double minLength) throws DelaunayError {
        int sizeEdges = this.edges.size();
        for (int i = 0; i < sizeEdges; ++i) {
            DEdge ed = this.edges.get(i);
            if (!ed.isEncroached()) continue;
            this.splitEncroachedEdge(ed, minLength);
        }
    }

    final void triangleRefinement(double minLength, InsertionEvaluator ev) throws DelaunayError {
        this.processed = new HashMap<Integer, DTriangle>(this.triangleList.size());
        this.remaining = new HashMap<Integer, DTriangle>(this.triangleList.size());
        this.fillRemainingFromTriangles();
        Set<Map.Entry<Integer, DTriangle>> treatSet = this.remaining.entrySet();
        while (!treatSet.isEmpty()) {
            Map.Entry<Integer, DTriangle> entry = treatSet.iterator().next();
            DTriangle dt = entry.getValue();
            if (ev.evaluate(dt)) {
                this.buffer = new HashMap<Integer, DTriangle>();
                DEdge ret = this.insertTriangleCircumCenter(dt, true, minLength);
                if (ret != null && ret.get2DLength() > 2.0 * minLength) {
                    this.splitEncroachedEdge(ret, minLength);
                    this.fillRemainingFromTriangles();
                    continue;
                }
                this.putInProcessed(dt);
                this.fillRemainingFromTriangles();
                continue;
            }
            this.putInProcessed(dt);
        }
        this.triangleList = new LinkedList<DTriangle>(this.processed.values());
        this.processed = null;
        this.remaining = null;
        this.buffer = null;
    }

    final void splitEncroachedEdge(DEdge ed, double minLength) throws DelaunayError {
        int indexExc;
        LinkedList<DEdge> li = new LinkedList<DEdge>();
        DTriangle left = ed.getLeft();
        DTriangle right = ed.getRight();
        DPoint middle = ed.getMiddle();
        DEdge secondHalf = new DEdge(middle, ed.getEndPoint());
        if (secondHalf.getSquared2DLength() < minLength * minLength) {
            return;
        }
        middle.setGID(++this.pointGID);
        this.points.add(middle);
        secondHalf.setGID(++this.edgeGID);
        DEdge ed1 = null;
        DEdge last1 = null;
        DEdge startOp1 = null;
        DTriangle other1 = null;
        if (left != null) {
            ed1 = new DEdge(middle, left.getOppositePoint(ed));
            last1 = left.getOppositeEdge(ed.getEndPoint());
            startOp1 = left.getOppositeEdge(ed.getStartPoint());
            other1 = new DTriangle(ed1, secondHalf, startOp1);
        }
        DEdge ed2 = null;
        DEdge last2 = null;
        DEdge startOp2 = null;
        DTriangle other2 = null;
        if (right != null) {
            ed2 = new DEdge(middle, right.getOppositePoint(ed));
            last2 = right.getOppositeEdge(ed.getEndPoint());
            startOp2 = right.getOppositeEdge(ed.getStartPoint());
            other2 = new DTriangle(ed2, secondHalf, startOp2);
        }
        secondHalf.setLocked(ed.isLocked());
        ed.setEndPoint(middle);
        if (left != null) {
            indexExc = left.getEdgeIndex(startOp1);
            left.setEdge(indexExc, ed1);
            left.recomputeCenter();
            ed1.setLeft(left);
            ed1.setRight(other1);
            if (startOp1.isRight(middle)) {
                startOp1.setRight(other1);
            } else {
                startOp1.setLeft(other1);
            }
            secondHalf.setLeft(other1);
            other1.setGID(++this.triangleGID);
            this.triangleList.add(other1);
            li.add(last1);
            li.add(ed1);
            li.add(startOp1);
            ed1.setGID(++this.edgeGID);
            this.edges.add(ed1);
        }
        if (right != null) {
            indexExc = right.getEdgeIndex(startOp2);
            right.setEdge(indexExc, ed2);
            right.recomputeCenter();
            ed2.setRight(right);
            ed2.setLeft(other2);
            if (startOp2.isRight(middle)) {
                startOp2.setRight(other2);
            } else {
                startOp2.setLeft(other2);
            }
            secondHalf.setRight(other2);
            other2.setGID(++this.triangleGID);
            this.triangleList.add(other2);
            li.add(last2);
            li.add(ed2);
            li.add(startOp2);
            ed2.setGID(++this.edgeGID);
            this.edges.add(ed2);
        }
        this.revertibleSwapping(li, new LinkedList<DEdge>(), middle, false);
        if (ed.isLocked()) {
            this.constraintEdges.add(secondHalf);
        }
        this.edges.add(secondHalf);
        if (ed.isEncroached()) {
            this.splitEncroachedEdge(ed, minLength);
        }
        if (secondHalf.isEncroached()) {
            this.splitEncroachedEdge(secondHalf, minLength);
        }
        if (right != null) {
            if (last2.isEncroached()) {
                this.splitEncroachedEdge(last2, minLength);
            }
            if (startOp2.isEncroached()) {
                this.splitEncroachedEdge(startOp2, minLength);
            }
        }
        if (left != null) {
            if (last1.isEncroached()) {
                this.splitEncroachedEdge(last1, minLength);
            }
            if (startOp1.isEncroached()) {
                this.splitEncroachedEdge(startOp1, minLength);
            }
        }
    }

    public final DEdge insertTriangleCircumCenter(DTriangle tri, boolean revertible, double minLength) throws DelaunayError {
        Element container = tri.getCircumCenterContainerSafe();
        DPoint cc = new DPoint(tri.getCircumCenter());
        if (container instanceof DEdge) {
            return (DEdge)container;
        }
        if (container == null) {
            return null;
        }
        double z = ((DTriangle)container).interpolateZ(cc);
        cc.setZ(z);
        DPoint pt = new DPoint(cc);
        if (revertible) {
            return this.insertIfNotEncroached(pt, (DTriangle)container, minLength);
        }
        this.insertPointInTriangle(pt, (DTriangle)container, minLength);
        return null;
    }

    final Boundary buildStartBoundary(DPoint p1, DEdge e1, List<DEdge> constraintsP1, List<DEdge> constraintsP2) {
        Boundary bound = new Boundary();
        LinkedList<DEdge> boundEdges = new LinkedList<DEdge>();
        boundEdges.add(e1);
        LinkedList<DEdge> boundEdgesBis = new LinkedList<DEdge>();
        boundEdgesBis.add(e1);
        if (constraintsP2.isEmpty()) {
            e1.setDegenerated(true);
        } else {
            e1.setShared(true);
        }
        ArrayList<BoundaryPart> bps = new ArrayList<BoundaryPart>();
        if (constraintsP1 == null || constraintsP1.isEmpty()) {
            BoundaryPart bp = new BoundaryPart(boundEdges);
            bps.add(bp);
            boundEdges = new LinkedList();
            boundEdges.add(e1);
            this.fillWithP2Constraints(boundEdgesBis, constraintsP2, bps, e1);
            if (!bps.isEmpty()) {
                boundEdges = new LinkedList();
                boundEdges.add(e1);
                ((BoundaryPart)bps.get(bps.size() - 1)).setBoundaryEdges(boundEdges);
            }
            bound.setBoundary(bps);
        } else {
            DEdge current = constraintsP1.get(0);
            ListIterator<DEdge> iter = constraintsP1.listIterator();
            boolean direct = current.getEndPoint().equals(current.getPointRight());
            if (direct && current.isRight(e1.getPointRight()) || !direct && current.isLeft(e1.getPointRight())) {
                BoundaryPart bp = new BoundaryPart(boundEdges);
                bps.add(bp);
                this.fillWithP2Constraints(boundEdgesBis, constraintsP2, bps, e1);
                while (iter.hasNext()) {
                    current = iter.next();
                    if (current.equals(e1)) continue;
                    bps.add(new BoundaryPart(current));
                }
            } else {
                boolean set = false;
                DEdge mem = iter.next();
                current = null;
                while (iter.hasNext()) {
                    current = iter.next();
                    if (!set && (current.isRight(e1.getPointRight()) || current.getPointRight().equals(e1.getEndPoint()))) {
                        if (mem.equals(e1)) {
                            bps.add(new BoundaryPart(boundEdges));
                        } else {
                            bps.add(new BoundaryPart(boundEdges, mem));
                        }
                        this.fillWithP2Constraints(boundEdgesBis, constraintsP2, bps, e1);
                        mem = current;
                        set = true;
                        continue;
                    }
                    if (!set && e1.equals(current)) {
                        bps.add(new BoundaryPart(boundEdges, mem));
                    } else {
                        bps.add(new BoundaryPart(mem));
                    }
                    mem = current;
                }
                if (current != null) {
                    if (current.isRight(e1.getPointRight())) {
                        bps.add(new BoundaryPart(current));
                    } else if (!current.equals(e1)) {
                        bps.add(new BoundaryPart(boundEdges, current));
                        this.fillWithP2Constraints(boundEdgesBis, constraintsP2, bps, e1);
                        set = true;
                    }
                }
                if (!set) {
                    mem = mem.equals(e1) ? null : mem;
                    bps.add(new BoundaryPart(boundEdges, mem));
                    this.fillWithP2Constraints(boundEdgesBis, constraintsP2, bps, e1);
                }
            }
        }
        this.edges.add(e1);
        ++this.edgeGID;
        e1.setGID(this.edgeGID);
        bound.setBoundary(bps);
        return bound;
    }

    private void fillWithP2Constraints(List<DEdge> boundaryEdges, List<DEdge> constraintsP2, List<BoundaryPart> bps, DEdge e1) {
        DEdge ed;
        for (int i = 0; i < constraintsP2.size() - 1; ++i) {
            ed = constraintsP2.get(i);
            if (ed.equals(e1)) continue;
            bps.add(new BoundaryPart(ed));
        }
        if (!constraintsP2.isEmpty() && !(ed = constraintsP2.get(constraintsP2.size() - 1)).equals(e1)) {
            bps.add(new BoundaryPart(boundaryEdges, ed));
        }
    }

    private DEdge replaceByConstraint(DEdge edge) {
        int index = this.sortedListContains(this.constraintEdges, edge);
        DEdge tempEdge = edge;
        if (index >= 0) {
            tempEdge = this.constraintEdges.get(index);
            if (!edge.getStartPoint().equals(tempEdge.getStartPoint())) {
                tempEdge.swap();
            }
        }
        return tempEdge;
    }

    private void processBadEdges() throws DelaunayError {
        LinkedList<DEdge> alreadySeen = new LinkedList<DEdge>();
        while (!this.badEdgesQueueList.isEmpty()) {
            DEdge anEdge = this.badEdgesQueueList.remove(0);
            boolean doIt = !anEdge.isLocked() && !alreadySeen.contains(anEdge);
            if (!doIt) continue;
            alreadySeen.add(anEdge);
            if (!this.swapTriangle(anEdge)) continue;
            LinkedList<DEdge> others = new LinkedList<DEdge>();
            DTriangle aTriangle1 = anEdge.getLeft();
            DTriangle aTriangle2 = anEdge.getRight();
            others.add(aTriangle1.getOppositeEdge(anEdge.getStartPoint()));
            others.add(aTriangle1.getOppositeEdge(anEdge.getEndPoint()));
            others.add(aTriangle2.getOppositeEdge(anEdge.getStartPoint()));
            others.add(aTriangle2.getOppositeEdge(anEdge.getEndPoint()));
            for (DEdge ed : others) {
                if (ed.getLeft() == null || ed.getRight() == null || this.badEdgesQueueList.contains(ed)) continue;
                this.badEdgesQueueList.add(ed);
            }
        }
    }

    private DEdge revertibleSwapping(LinkedList<DEdge> badEdges, Deque<DEdge> swapMemory, DPoint pt, boolean revert) throws DelaunayError {
        LinkedList<DEdge> alreadySeen = new LinkedList<DEdge>();
        while (!badEdges.isEmpty()) {
            DEdge ed = badEdges.removeFirst();
            boolean cont = !ed.isLocked() && !alreadySeen.contains(ed);
            if (!cont) continue;
            alreadySeen.add(ed);
            if (!this.swapTriangle(ed)) continue;
            DTriangle left = ed.getLeft();
            DTriangle right = ed.getRight();
            swapMemory.addLast(ed);
            this.putInBuffer(left);
            this.putInBuffer(right);
            LinkedList<DEdge> others = new LinkedList<DEdge>();
            others.add(left.getOppositeEdge(ed.getStartPoint()));
            others.add(left.getOppositeEdge(ed.getEndPoint()));
            others.add(right.getOppositeEdge(ed.getStartPoint()));
            others.add(right.getOppositeEdge(ed.getEndPoint()));
            for (DEdge edge : others) {
                if (revert && edge.isEncroachedBy(pt)) {
                    return edge;
                }
                if (edge.getLeft() == null || edge.getRight() == null || badEdges.contains(edge)) continue;
                badEdges.add(edge);
            }
        }
        return null;
    }

    final boolean swapTriangle(DEdge ed) throws DelaunayError {
        DTriangle left = ed.getLeft();
        DTriangle right = ed.getRight();
        boolean exchange = false;
        if (left != null && right != null) {
            DPoint p4;
            DPoint p2;
            DPoint p1 = ed.getStartPoint();
            DPoint p3 = left.getAlterPoint(p1, p2 = ed.getEndPoint());
            if (p3 != null && right.inCircle(p3) == 1) {
                exchange = true;
            }
            if ((p4 = right.getAlterPoint(p1, p2)) != null && left.inCircle(p4) == 1) {
                exchange = true;
            }
            if (p3 != p4 && exchange) {
                if (this.canSwap(ed)) {
                    this.flipFlap(ed);
                } else {
                    exchange = false;
                }
            }
        }
        return exchange;
    }

    private void putInBuffer(DTriangle tri) {
        if (this.buffer != null && tri.isProcessed()) {
            this.buffer.put(tri.getGID(), tri);
        }
    }

    private void fromBufferToRemaining() {
        Set<Map.Entry<Integer, DTriangle>> entries = this.buffer.entrySet();
        for (Map.Entry<Integer, DTriangle> ent : entries) {
            ent.getValue().setProcessed(false);
            this.remaining.put(ent.getKey(), ent.getValue());
            this.processed.remove(ent.getKey());
        }
    }

    private void putInProcessed(DTriangle tri) {
        int gid = tri.getGID();
        if (this.remaining.remove(gid) != null) {
            this.processed.put(gid, tri);
            tri.setProcessed(true);
        }
    }

    private void fillRemainingFromTriangles() {
        while (!this.triangleList.isEmpty()) {
            DTriangle tem = this.triangleList.remove(0);
            this.remaining.put(tem.getGID(), tem);
        }
    }

    private boolean canSwap(DEdge ed) {
        DTriangle left = ed.getLeft();
        DTriangle right = ed.getRight();
        DPoint p1 = ed.getStartPoint();
        DPoint p2 = ed.getEndPoint();
        DPoint p4 = right.getAlterPoint(p1, p2);
        DEdge anEdge11 = left.getOppositeEdge(p2);
        DEdge anEdge22 = left.getOppositeEdge(p1);
        boolean err1 = anEdge11.isLeft(p4) && anEdge11.isLeft(p2) || anEdge11.isRight(p4) && anEdge11.isRight(p2);
        boolean err2 = anEdge22.isLeft(p4) && anEdge22.isLeft(p1) || anEdge22.isRight(p4) && anEdge22.isRight(p1);
        return err1 && err2;
    }

    final void flipFlap(DEdge ed) throws DelaunayError {
        DTriangle left = ed.getLeft();
        DTriangle right = ed.getRight();
        DPoint p1 = ed.getStartPoint();
        DPoint p2 = ed.getEndPoint();
        DPoint p3 = left.getAlterPoint(p1, p2);
        DPoint p4 = right.getAlterPoint(p1, p2);
        DEdge anEdge11 = left.getOppositeEdge(p2);
        DEdge anEdge12 = right.getOppositeEdge(p2);
        DEdge anEdge21 = right.getOppositeEdge(p1);
        DEdge anEdge22 = left.getOppositeEdge(p1);
        if (anEdge11 == null || anEdge12 == null || anEdge21 == null || anEdge22 == null) {
            throw new DelaunayError(1000, "Couldn't swap the triangles.");
        }
        ed.setStartPoint(p3);
        ed.setEndPoint(p4);
        left.setEdge(0, ed);
        left.setEdge(1, anEdge11);
        left.setEdge(2, anEdge12);
        right.setEdge(0, ed);
        right.setEdge(1, anEdge21);
        right.setEdge(2, anEdge22);
        if (anEdge12.getLeft() == right) {
            anEdge12.setLeft(left);
        } else {
            anEdge12.setRight(left);
        }
        if (anEdge22.getLeft() == left) {
            anEdge22.setLeft(right);
        } else {
            anEdge22.setRight(right);
        }
        ed.setLeft(right);
        ed.setRight(left);
        left.recomputeCenter();
        right.recomputeCenter();
    }

    final void revertFlipFlap(DEdge ed) throws DelaunayError {
        DTriangle left = ed.getLeft();
        DTriangle right = ed.getRight();
        DPoint p1 = ed.getStartPoint();
        DPoint p2 = ed.getEndPoint();
        DPoint p3 = left.getAlterPoint(p1, p2);
        DPoint p4 = right.getAlterPoint(p1, p2);
        DEdge anEdge11 = left.getOppositeEdge(p2);
        DEdge anEdge12 = right.getOppositeEdge(p2);
        DEdge anEdge21 = right.getOppositeEdge(p1);
        DEdge anEdge22 = left.getOppositeEdge(p1);
        if (anEdge11 == null || anEdge12 == null || anEdge21 == null || anEdge22 == null) {
            throw new DelaunayError(1000, "Couldn't swap the triangles.");
        }
        ed.setStartPoint(p3);
        ed.setEndPoint(p4);
        right.setEdge(0, ed);
        right.setEdge(1, anEdge11);
        right.setEdge(2, anEdge12);
        left.setEdge(0, ed);
        left.setEdge(1, anEdge21);
        left.setEdge(2, anEdge22);
        if (anEdge21.getLeft() == right) {
            anEdge21.setLeft(left);
        } else {
            anEdge21.setRight(left);
        }
        if (anEdge11.getLeft() == left) {
            anEdge11.setLeft(right);
        } else {
            anEdge11.setRight(right);
        }
        left.recomputeCenter();
        right.recomputeCenter();
    }

    private void fixConstraintDirection(DEdge ed) {
        if (ed.getPointRight().equals(ed.getStartPoint())) {
            ed.swap();
        }
    }

    private void changeUnqualifiedEdges(Map<DPoint, DPoint> replacePoints, List<DEdge> theList) {
        ArrayList<DEdge> edgeToRemove = new ArrayList<DEdge>();
        for (DEdge anEdge : theList) {
            DPoint aPoint2;
            DPoint aPoint1;
            DPoint replaced1 = aPoint1 = anEdge.getStartPoint();
            if (replacePoints.containsKey(aPoint1)) {
                replaced1 = replacePoints.get(aPoint1);
                anEdge.setStartPoint(replaced1);
            }
            DPoint replaced2 = aPoint2 = anEdge.getEndPoint();
            if (replacePoints.containsKey(aPoint2)) {
                replaced2 = replacePoints.get(aPoint2);
                anEdge.setEndPoint(replaced2);
            }
            if (!replaced1.equals(replaced2)) continue;
            edgeToRemove.add(anEdge);
        }
        for (DEdge anEdge : edgeToRemove) {
            theList.remove(anEdge);
        }
    }

    final void proceedSwaps(Iterator<DEdge> it) throws DelaunayError {
        while (it.hasNext()) {
            DEdge ed = it.next();
            ed.swap();
            this.revertFlipFlap(ed);
        }
    }

    public final DEdge insertIfNotEncroached(DPoint pt, DTriangle container, double minLength) throws DelaunayError {
        if (!container.isInside(pt)) {
            throw new DelaunayError(0, "you must search for the containing triangle before to proceed to the insertion.");
        }
        if (container.isCloser(pt, minLength)) {
            return null;
        }
        boolean onEdge = container.isOnAnEdge(pt);
        DEdge ret = onEdge ? this.insertOnEdgeRevertible(container, pt) : this.insertInTriangleRevertible(container, pt);
        return ret;
    }

    private DEdge insertOnEdgeRevertible(DTriangle container, DPoint pt) throws DelaunayError {
        DEdge ret;
        LinkedList<DEdge> badEdges = new LinkedList<DEdge>();
        LinkedList<DEdge> swapMem = new LinkedList<DEdge>();
        DEdge contEdge = container.getContainingEdge(pt);
        if (contEdge.isLocked() || contEdge.getLeft() == null || contEdge.getRight() == null) {
            return contEdge;
        }
        DTriangle left = contEdge.getLeft();
        DEdge memleft = null;
        DPoint memExt = contEdge.getEndPoint();
        if (left != null) {
            memleft = left.getOppositeEdge(contEdge.getStartPoint());
        }
        DTriangle right = contEdge.getRight();
        DEdge memright = null;
        if (right != null) {
            memright = right.getOppositeEdge(contEdge.getStartPoint());
        }
        if ((ret = this.initPointOnEdge(pt, contEdge, badEdges)) != null) {
            this.revertPointOnEdgeInsertion(contEdge, pt, memExt, memleft, memright);
            return ret;
        }
        ret = this.revertibleSwapping(badEdges, swapMem, pt, true);
        if (ret != null) {
            Iterator<DEdge> it = swapMem.descendingIterator();
            this.proceedSwaps(it);
            if (contEdge.getStartPoint().equals(pt)) {
                contEdge.swap();
            }
            this.revertPointOnEdgeInsertion(contEdge, pt, memExt, memleft, memright);
        }
        return ret;
    }

    private DEdge insertInTriangleRevertible(DTriangle container, DPoint pt) throws DelaunayError {
        LinkedList<DEdge> badEdges = new LinkedList<DEdge>();
        LinkedList<DEdge> swapMem = new LinkedList<DEdge>();
        DEdge eMem0 = container.getEdge(0);
        DEdge eMem1 = container.getEdge(1);
        DEdge eMem2 = container.getEdge(2);
        DPoint mem = container.getOppositePoint(eMem0);
        DEdge ret = this.initPointInTriangle(pt, container, badEdges);
        if (ret != null) {
            this.revertPointInTriangleInsertion(container, pt, mem, eMem1, eMem2);
            return ret;
        }
        ret = this.revertibleSwapping(badEdges, swapMem, pt, true);
        if (ret != null) {
            Iterator<DEdge> it = swapMem.descendingIterator();
            this.proceedSwaps(it);
            DTriangle actualContainer = container;
            if (eMem0.getLeft() != null && eMem0.getLeft().belongsTo(pt)) {
                actualContainer = eMem0.getLeft();
            } else if (eMem0.getRight() != null && eMem0.getRight().belongsTo(pt)) {
                actualContainer = eMem0.getRight();
            }
            this.revertPointInTriangleInsertion(actualContainer, pt, mem, eMem1, eMem2);
        }
        return ret;
    }

    final void revertPointInTriangleInsertion(DTriangle dt, DPoint forget, DPoint apex, DEdge o1, DEdge o2) throws DelaunayError {
        DEdge perm = dt.getOppositeEdge(forget);
        DEdge mod = dt.getOppositeEdge(perm.getStartPoint());
        int index = dt.getEdgeIndex(mod);
        int index2 = dt.getEdgeIndex(dt.getOppositeEdge(perm.getEndPoint()));
        if (o1.contains(perm.getStartPoint())) {
            dt.setEdge(index, o2);
            dt.setEdge(index2, o1);
        } else {
            dt.setEdge(index, o1);
            dt.setEdge(index2, o2);
        }
        dt.recomputeCenter();
        this.points.remove(this.points.size() - 1);
        this.edges.remove(this.edges.size() - 1);
        this.edges.remove(this.edges.size() - 1);
        this.edges.remove(this.edges.size() - 1);
        this.triangleList.remove(this.triangleList.size() - 1);
        this.triangleList.remove(this.triangleList.size() - 1);
        this.forceCoherence(dt);
    }

    final void revertPointOnEdgeInsertion(DEdge ed, DPoint forget, DPoint extremity, DEdge leftLast, DEdge rightLast) throws DelaunayError {
        DTriangle left = ed.getLeft();
        DTriangle right = ed.getRight();
        if (this.triangleList.size() > 1) {
            this.checkMemEdges(leftLast, forget, this.triangleList.get(this.triangleList.size() - 1), this.triangleList.get(this.triangleList.size() - 2));
            this.checkMemEdges(rightLast, forget, this.triangleList.get(this.triangleList.size() - 1), this.triangleList.get(this.triangleList.size() - 2));
        }
        ed.setEndPoint(extremity);
        DPoint st = ed.getStartPoint();
        if (left != null) {
            this.rebuildTriangleOEI(left, st, leftLast);
            this.edges.remove(this.edges.size() - 1);
            this.triangleList.remove(this.triangleList.size() - 1);
            this.forceCoherence(left);
        }
        this.edges.remove(this.edges.size() - 1);
        if (right != null) {
            this.rebuildTriangleOEI(right, st, rightLast);
            this.edges.remove(this.edges.size() - 1);
            this.triangleList.remove(this.triangleList.size() - 1);
            this.forceCoherence(right);
        }
        this.points.remove(this.points.size() - 1);
    }

    private void forceCoherence(DTriangle dt) {
        dt.forceCoherenceWithEdges();
        for (DEdge ed : dt.getEdges()) {
            ed.forceTriangleSide();
        }
    }

    private void checkMemEdges(DEdge mem, DPoint forget, DTriangle l1, DTriangle l2) {
        if (l1 != null && l1.isEdgeOf(mem) && !l1.belongsTo(forget)) {
            mem.deepSwap();
        } else if (l2 != null && l2.isEdgeOf(mem) && !l2.belongsTo(forget)) {
            mem.deepSwap();
        }
    }

    private void rebuildTriangleOEI(DTriangle tri, DPoint op, DEdge ed) throws DelaunayError {
        DEdge rep = tri.getOppositeEdge(op);
        int i = tri.getEdgeIndex(rep);
        tri.setEdge(i, ed);
        tri.recomputeCenter();
    }

    public final void insertPointInTriangle(DPoint pt, DTriangle container, double minLength) throws DelaunayError {
        if (!container.isInside(pt)) {
            throw new DelaunayError(0, "you must search for the containing trianglebefore to proceed to the insertion.");
        }
        if (container.isCloser(pt, minLength)) {
            return;
        }
        LinkedList<DEdge> badEdges = new LinkedList<DEdge>();
        boolean onEdge = container.isOnAnEdge(pt);
        if (onEdge) {
            DEdge contEdge = container.getContainingEdge(pt);
            this.initPointOnEdge(pt, contEdge, badEdges);
            this.badEdgesQueueList = badEdges;
            this.processBadEdges();
        } else {
            this.initPointInTriangle(pt, container, badEdges);
            this.badEdgesQueueList = badEdges;
            this.processBadEdges();
        }
    }

    final DEdge initPointInTriangle(DPoint pt, DTriangle container, Deque<DEdge> badEdges) throws DelaunayError {
        DTriangle tri2;
        DEdge eMem0 = container.getEdge(0);
        DEdge eMem1 = container.getEdge(1);
        DEdge eMem2 = container.getEdge(2);
        badEdges.add(eMem0);
        badEdges.add(eMem1);
        badEdges.add(eMem2);
        DEdge e1 = new DEdge(pt, eMem1.getStartPoint());
        DEdge e2 = new DEdge(pt, eMem1.getEndPoint());
        ++this.edgeGID;
        e1.setGID(this.edgeGID);
        ++this.edgeGID;
        e2.setGID(this.edgeGID);
        DTriangle tri1 = new DTriangle(eMem1, e1, e2);
        this.addTriangle(tri1);
        DEdge e3 = new DEdge(pt, container.getOppositePoint(eMem1));
        ++this.edgeGID;
        e3.setGID(this.edgeGID);
        if (eMem2.isExtremity(eMem1.getStartPoint())) {
            tri2 = new DTriangle(e1, e3, eMem2);
            container.setEdge(1, e2);
            container.setEdge(2, e3);
        } else {
            tri2 = new DTriangle(e2, e3, eMem2);
            container.setEdge(1, e1);
            container.setEdge(2, e3);
        }
        container.forceCoherenceWithEdges();
        this.addTriangle(tri2);
        this.edges.add(e1);
        this.edges.add(e2);
        this.edges.add(e3);
        ++this.pointGID;
        pt.setGID(this.pointGID);
        this.points.add(pt);
        if (eMem0.isEncroached()) {
            return eMem0;
        }
        if (eMem1.isEncroached()) {
            return eMem1;
        }
        if (eMem2.isEncroached()) {
            return eMem2;
        }
        return null;
    }

    final DEdge initPointOnEdge(DPoint pt, DEdge contEdge, Deque<DEdge> badEdges) throws DelaunayError {
        DTriangle left = contEdge.getLeft();
        DTriangle right = contEdge.getRight();
        DEdge r1 = null;
        DEdge r2 = null;
        DEdge l1 = null;
        DEdge l2 = null;
        DEdge otherPart = new DEdge(pt, contEdge.getEndPoint());
        if (left != null) {
            l1 = left.getOppositeEdge(contEdge.getEndPoint());
            l2 = left.getOppositeEdge(contEdge.getStartPoint());
            badEdges.add(l1);
            badEdges.add(l2);
            DPoint opLeft = left.getOppositePoint(contEdge);
            DEdge lastLeft = new DEdge(pt, opLeft);
            DTriangle otl = new DTriangle(l2, otherPart, lastLeft);
            left.setEdge(left.getEdgeIndex(l2), lastLeft);
            lastLeft.setLeft(left);
            ++this.edgeGID;
            lastLeft.setGID(this.edgeGID);
            this.edges.add(lastLeft);
            this.addTriangle(otl);
        }
        if (right != null) {
            r1 = right.getOppositeEdge(contEdge.getEndPoint());
            r2 = right.getOppositeEdge(contEdge.getStartPoint());
            badEdges.add(r1);
            badEdges.add(r2);
            DPoint opRight = right.getOppositePoint(contEdge);
            DEdge lastRight = new DEdge(pt, opRight);
            DTriangle otr = new DTriangle(r2, otherPart, lastRight);
            right.setEdge(right.getEdgeIndex(r2), lastRight);
            lastRight.setRight(right);
            ++this.edgeGID;
            lastRight.setGID(this.edgeGID);
            this.edges.add(lastRight);
            this.addTriangle(otr);
        }
        contEdge.setEndPoint(pt);
        ++this.pointGID;
        pt.setGID(this.pointGID);
        this.points.add(pt);
        ++this.edgeGID;
        otherPart.setGID(this.edgeGID);
        this.edges.add(otherPart);
        contEdge.setEndPoint(pt);
        if (left != null) {
            left.recomputeCenter();
            if (l1.isEncroached()) {
                return l1;
            }
            if (l2.isEncroached()) {
                return l2;
            }
        }
        if (right != null) {
            right.recomputeCenter();
            if (r1.isEncroached()) {
                return r1;
            }
            if (r2.isEncroached()) {
                return r2;
            }
        }
        return null;
    }

    public final void dataQualification(double epsilon) throws DelaunayError {
        if (this.isMeshComputed()) {
            throw new DelaunayError(102);
        }
        if (this.points == null || this.edges == null || this.constraintEdges == null || this.polygons == null) {
            throw new DelaunayError("Structures not defined");
        }
        if (epsilon <= 0.0) {
            throw new DelaunayError("Epsilon must be positive");
        }
        HashMap<DPoint, DPoint> replacePoints = new HashMap<DPoint, DPoint>();
        double epsilon2 = epsilon * epsilon;
        int index = -1;
        for (DPoint aPoint : this.points) {
            ++index;
            if (replacePoints.containsKey(aPoint)) continue;
            double x1 = aPoint.getX();
            double y1 = aPoint.getY();
            ListIterator<DPoint> iter = this.points.listIterator(index);
            boolean ended = false;
            while (iter.hasNext() && !ended) {
                double y2;
                DPoint nextPoint = iter.next();
                if (nextPoint == aPoint) continue;
                double x2 = nextPoint.getX();
                if ((x2 - x1) * (x2 - x1) + ((y2 = nextPoint.getY()) - y1) * (y2 - y1) <= epsilon2) {
                    replacePoints.put(nextPoint, aPoint);
                }
                if (!(x2 > x1 + epsilon)) continue;
                ended = true;
            }
        }
        ListIterator<DPoint> iterPts = this.points.listIterator();
        while (iterPts.hasNext()) {
            DPoint aPoint;
            aPoint = iterPts.next();
            if (!replacePoints.containsKey(aPoint)) continue;
            iterPts.remove();
        }
        this.changeUnqualifiedEdges(replacePoints, this.edges);
        this.changeUnqualifiedEdges(replacePoints, this.constraintEdges);
        ArrayList<ConstraintPolygon> polygonToRemove = new ArrayList<ConstraintPolygon>();
        for (ConstraintPolygon aPolygon : this.polygons) {
            this.changeUnqualifiedEdges(replacePoints, aPolygon.getEdges());
            if (!aPolygon.getEdges().isEmpty()) continue;
            polygonToRemove.add(aPolygon);
        }
        for (ConstraintPolygon aPolygon : polygonToRemove) {
            this.polygons.remove(aPolygon);
        }
    }

    public final void displayObject(Graphics g) {
        try {
            Envelope theBox = this.getBoundingBox();
            int xSize = 1200;
            int ySize = 600;
            int decalageX = 10;
            int decalageY = 630;
            int legende = 660;
            int bordure = 10;
            int maxDisplayedPoints = 100;
            double scaleX = 1200.0 / (theBox.getMaxX() - theBox.getMinX());
            double scaleY = 600.0 / (theBox.getMaxY() - theBox.getMinY());
            if (scaleX > scaleY) {
                scaleX = scaleY;
            } else {
                scaleY = scaleX;
            }
            double minX = theBox.getMinX();
            double minY = theBox.getMinY();
            scaleY = -scaleY;
            g.setColor(Color.white);
            g.fillRect(0, 20, 1220, 620);
            g.fillRect(0, 650, 1220, 70);
            g.setColor(Color.black);
            if (!this.triangleList.isEmpty()) {
                for (DTriangle aTriangle : this.triangleList) {
                    aTriangle.displayObject(g, 10, 630, minX, minY, scaleX, scaleY);
                }
            }
            if (!this.constraintEdges.isEmpty()) {
                for (DEdge aVertex : this.constraintEdges) {
                    aVertex.displayObject(g, 10, 630, minX, minY, scaleX, scaleY);
                }
            }
            if (!this.edges.isEmpty()) {
                for (DEdge aVertex : this.edges) {
                    aVertex.displayObject(g, 10, 630, minX, minY, scaleX, scaleY);
                }
            }
            if (this.points.size() > 0 && this.points.size() < 100) {
                for (DPoint aPoint : this.points) {
                    aPoint.displayObject(g, 10, 630, minX, minY, scaleX, scaleY);
                }
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Object)"Problem during rendering\n", (Throwable)e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.badEdgesQueueList = new LinkedList<DEdge>();
    }
}

