/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;

public class VerticalComparator
implements Comparator<DEdge>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(VerticalComparator.class);
    private double abs;

    public VerticalComparator(double x) {
        this.abs = x;
    }

    public final void setAbs(double x) {
        this.abs = x;
    }

    public final double getAbs() {
        return this.abs;
    }

    @Override
    public final int compare(DEdge edge1, DEdge edge2) {
        int c;
        DPoint pEdge1 = null;
        DPoint pEdge2 = null;
        if (edge1.equals(edge2)) {
            return 0;
        }
        try {
            pEdge1 = edge1.getPointFromItsX(this.abs);
            pEdge2 = edge2.getPointFromItsX(this.abs);
        }
        catch (DelaunayError e) {
            LOG.error((Object)"Problem while processing the points from their absciss !");
        }
        if (pEdge1 == null || pEdge2 == null) {
            c = -2;
        } else {
            c = pEdge1.getY() < pEdge2.getY() ? -1 : 1;
            int n = c = pEdge1.getY() == pEdge2.getY() ? 0 : c;
            if (c == 0) {
                if (edge1.isVertical()) {
                    if (edge2.isVertical()) {
                        double yr2;
                        double yr1 = edge1.getPointRight().getY();
                        return yr1 > (yr2 = edge2.getPointRight().getY()) ? 1 : -1;
                    }
                    c = this.comparePoints(edge1.getPointRight(), edge2.getPointRight());
                    if (edge1.getPointLeft().equals(pEdge1)) {
                        c = 1;
                    } else if (edge1.getPointRight().equals(pEdge1)) {
                        c = -1;
                    }
                } else if (edge2.isVertical()) {
                    c = this.comparePoints(edge2.getPointRight(), edge1.getPointRight());
                    if (edge2.getPointLeft().equals(pEdge2)) {
                        c = -1;
                    } else if (edge2.getPointRight().equals(pEdge2)) {
                        c = 1;
                    }
                } else {
                    double deltaXT = edge1.getPointRight().getX() - edge1.getPointLeft().getX();
                    double deltaYT = edge1.getPointRight().getY() - edge1.getPointLeft().getY();
                    double deltaXO = edge2.getPointRight().getX() - edge2.getPointLeft().getX();
                    double cT = deltaYT / deltaXT;
                    double deltaYO = edge2.getPointRight().getY() - edge2.getPointLeft().getY();
                    double cO = deltaYO / deltaXO;
                    if (-1.0E-7 < cT - cO && cT - cO < 1.0E-7) {
                        c = this.comparePoints(edge1.getPointRight(), edge2.getPointRight());
                        if (c == 0) {
                            c = this.comparePoints(edge1.getPointLeft(), edge2.getPointLeft());
                        }
                    } else {
                        c = cT < cO ? -1 : 1;
                    }
                }
            }
        }
        return c;
    }

    private int comparePoints(DPoint p1, DPoint p2) {
        double y2;
        double x2;
        double x1 = p1.getX();
        if (x1 < (x2 = p2.getX())) {
            return -1;
        }
        if (x1 > x2) {
            return 1;
        }
        double y1 = p1.getY();
        if (y1 < (y2 = p2.getY())) {
            return -1;
        }
        if (y1 > y2) {
            return 1;
        }
        return 0;
    }
}

