/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdelaunay.delaunay.VoronoiNode;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.geometries.DTriangle;

class VoronoiGraph {
    private List<VoronoiNode> sortedNodes;
    private VoronoiNode startNode;
    private VoronoiNode notFlat;
    private VoronoiNode lastFlat;
    private boolean useful = false;

    public VoronoiGraph(DTriangle base) throws DelaunayError {
        this.startNode = new VoronoiNode(base);
        this.sortedNodes = new ArrayList<VoronoiNode>();
        this.addNode(this.startNode);
        this.notFlat = null;
    }

    public List<VoronoiNode> getSortedNodes() {
        return this.sortedNodes;
    }

    public VoronoiNode getStartNode() {
        return this.startNode;
    }

    public VoronoiNode getNotFlat() {
        return this.notFlat;
    }

    public boolean isUseful() {
        return this.useful;
    }

    public void setStartNode(VoronoiNode startNode) {
        this.startNode = startNode;
    }

    public void setStartNode(DTriangle root) throws DelaunayError {
        this.setStartNode(new VoronoiNode(root));
    }

    private void addNode(VoronoiNode vn) {
        this.sortedNodes.add(vn);
    }

    public List<DPoint> getSkeletonPoints() {
        ArrayList<DPoint> ret = new ArrayList<DPoint>();
        for (VoronoiNode vn : this.sortedNodes) {
            ret.add(vn.getLocation());
        }
        return ret;
    }

    public void fillUntilNotFlatFound() throws DelaunayError {
        if (this.startNode.getParent().isFlatSlope()) {
            this.processNeighbours(this.startNode);
        }
    }

    private void processNeighbours(VoronoiNode vn) throws DelaunayError {
        vn.getParent().setSeenForFlatRemoval(true);
        List<VoronoiNode> neighbours = vn.getNeighbourNodes();
        ArrayList<VoronoiNode> toBeTreated = new ArrayList<VoronoiNode>();
        for (VoronoiNode neigh : neighbours) {
            int index = Collections.binarySearch(this.sortedNodes, neigh);
            if (index >= 0) {
                vn.replaceNode(this.sortedNodes.get(index));
                continue;
            }
            this.sortedNodes.add(-index - 1, neigh);
            if (neigh.getParent().isFlatSlope()) {
                toBeTreated.add(neigh);
                continue;
            }
            if (this.notFlat != null) continue;
            this.notFlat = neigh;
            this.lastFlat = vn;
        }
        for (VoronoiNode treat : toBeTreated) {
            if (treat.getParent().isSeenForFlatRemoval()) continue;
            this.processNeighbours(treat);
        }
    }

    public void assignZValues() throws DelaunayError {
        this.useful = false;
        this.useful = this.notFlat == null ? this.assignZValuesWithoutNotFlat() : this.assignZValuesWithNotFlat();
    }

    private boolean assignZValuesWithoutNotFlat() throws DelaunayError {
        double currentRad;
        boolean upper = false;
        boolean set = false;
        double maxRadius = 0.0;
        double height = this.sortedNodes.get(0).getParent().getPoint(0).getZ();
        for (VoronoiNode vn : this.sortedNodes) {
            currentRad = vn.getRadius();
            maxRadius = maxRadius < currentRad ? currentRad : maxRadius;
            DEdge[] edges = vn.getParent().getEdges();
            for (int i = 0; i < 3; ++i) {
                DTriangle otherT;
                if (!edges[i].isLocked() || (otherT = edges[i].getOtherTriangle(vn.getParent())) == null) continue;
                double extZ = otherT.getOppositePoint(edges[i]).getZ();
                if (!set && Math.abs(extZ - height) > 1.0E-7) {
                    set = true;
                    upper = height > extZ;
                    continue;
                }
                if ((!upper || height - extZ > -1.0E-7) && (upper || extZ - height > -1.0E-7)) continue;
                return false;
            }
        }
        if (!set) {
            return false;
        }
        for (VoronoiNode vn : this.sortedNodes) {
            currentRad = vn.getRadius();
            double delta = currentRad / maxRadius;
            if (upper) {
                vn.getLocation().setZ(height + delta);
                continue;
            }
            vn.getLocation().setZ(height - delta);
        }
        return true;
    }

    public final int getMaxDepth() throws DelaunayError {
        for (VoronoiNode vn : this.sortedNodes) {
            vn.setSeen(false);
        }
        return this.lastFlat != null ? this.getMaxLength(this.lastFlat) : -1;
    }

    private int getMaxLength(VoronoiNode vn) throws DelaunayError {
        int length = 0;
        vn.setSeen(true);
        for (VoronoiNode voro : vn.getLinkedNodes()) {
            if (voro.isSeen()) continue;
            length = Math.max(length, this.getMaxLength(voro));
        }
        return length + 1;
    }

    private boolean assignZValuesWithNotFlat() throws DelaunayError {
        double flatZ = this.lastFlat.getParent().getPoint(0).getZ();
        DTriangle dt = this.notFlat.getParent();
        double zNf = Double.NaN;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(dt.getPoint(i).getZ() - flatZ) > 1.0E-7)) continue;
            zNf = dt.getPoint(i).getZ();
            break;
        }
        if (Double.isNaN(zNf)) {
            throw new DelaunayError("Well... this triangle was supposed not to be flat. U mad ?");
        }
        double flatHeight = this.lastFlat.getParent().getPoint(0).getZ();
        int length = this.getMaxLength(this.lastFlat) + 1;
        double delta = (zNf - flatHeight) / (double)(length + 1);
        this.notFlat.getLocation().setZ(zNf - delta);
        for (VoronoiNode vn : this.sortedNodes) {
            vn.setSeen(false);
        }
        this.assignValues(this.lastFlat, delta, zNf - delta, flatHeight);
        return true;
    }

    private void assignValues(VoronoiNode vn, double delta, double prevAlt, double flatHeight) throws DelaunayError {
        if (!vn.getParent().isFlatSlope()) {
            return;
        }
        double alt = prevAlt - delta;
        if (prevAlt > flatHeight && alt < flatHeight || prevAlt < flatHeight && alt > flatHeight) {
            double deltaBis = delta / 4.0;
            this.assignValues(vn, deltaBis, prevAlt, flatHeight);
        } else {
            vn.setSeen(true);
            vn.getLocation().setZ(alt);
            for (VoronoiNode vor : vn.getLinkedNodes()) {
                if (vor.isSeen()) continue;
                this.assignValues(vor, delta, alt, flatHeight);
            }
        }
    }
}

