/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.geometries.DTriangle;

class VoronoiNode
implements Comparable<VoronoiNode> {
    private static final int HASHBASE = 7;
    private static final int HASHMULT = 71;
    private List<VoronoiNode> linkedNodes = new ArrayList<VoronoiNode>();
    private DTriangle parent;
    private DPoint location;
    private boolean seen = false;

    public VoronoiNode(DTriangle par) throws DelaunayError {
        this.parent = par;
        this.computeLocation();
    }

    public List<VoronoiNode> getLinkedNodes() {
        return this.linkedNodes;
    }

    public DPoint getLocation() {
        return this.location;
    }

    public DTriangle getParent() {
        return this.parent;
    }

    public void setParent(DTriangle par) throws DelaunayError {
        if (par == null) {
            throw new DelaunayError("A VoronoiNode must have a parent !");
        }
        this.parent = par;
        this.linkedNodes = new ArrayList<VoronoiNode>();
        this.computeLocation();
    }

    public List<VoronoiNode> getNeighbourNodes() throws DelaunayError {
        this.linkedNodes = new ArrayList<VoronoiNode>();
        DEdge[] parEdges = this.parent.getEdges();
        for (int i = 0; i < 3; ++i) {
            DTriangle curT;
            DEdge cur = parEdges[i];
            if (cur.isLocked() || (curT = cur.getOtherTriangle(this.parent)) == null) continue;
            VoronoiNode vn = new VoronoiNode(curT);
            this.linkedNodes.add(vn);
        }
        return this.linkedNodes;
    }

    final boolean isSeen() {
        return this.seen;
    }

    final void setSeen(boolean seen) {
        this.seen = seen;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VoronoiNode) {
            return this.parent.equals(((VoronoiNode)obj).getParent());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.parent != null ? this.parent.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(VoronoiNode o) {
        int c = this.location.compareTo(o.getLocation());
        if (c == 0) {
            return this.parent.compareTo(o.getParent());
        }
        return c;
    }

    private void computeLocation() throws DelaunayError {
        DPoint defloc = new DPoint(this.parent.getCircumCenter());
        DEdge[] edges = this.parent.getEdges();
        for (int i = 0; i < 3; ++i) {
            DPoint last = this.parent.getOppositePoint(edges[i]);
            if (!edges[i].isRight(last) != edges[i].isRight(defloc)) continue;
            this.location = this.parent.getBarycenter();
            return;
        }
        this.location = defloc;
        double z = this.parent.interpolateZ(this.location);
        this.location.setZ(z);
    }

    void replaceNode(VoronoiNode alreadySeen) throws DelaunayError {
        int index = this.linkedNodes.indexOf(alreadySeen);
        if (index < 0) {
            throw new DelaunayError("Wait... the node given in argument is supposed to be a neighbour of this one!");
        }
        this.linkedNodes.set(index, alreadySeen);
    }

    double getRadius() throws DelaunayError {
        if (this.location.equals(new DPoint(this.parent.getCircumCenter()))) {
            return this.parent.getRadius();
        }
        ArrayList<Double> dists = new ArrayList<Double>();
        for (int i = 0; i < 3; ++i) {
            dists.add(this.location.squareDistance(this.getParent().getPoint(i)));
        }
        return (Double)Collections.min(dists);
    }
}

