/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jdelaunay.delaunay.BoundaryPart;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.geometries.DTriangle;

final class Boundary {
    private List<BoundaryPart> boundary = new ArrayList<BoundaryPart>();
    private List<DEdge> badEdges;
    private List<DEdge> addedEdges;

    Boundary() {
    }

    List<BoundaryPart> getBoundary() {
        return this.boundary;
    }

    void setBoundary(List<BoundaryPart> bound) {
        this.boundary = bound == null ? new ArrayList<BoundaryPart>() : bound;
    }

    private void setAddedEdges(List<DEdge> edges) {
        this.addedEdges = edges;
    }

    List<DEdge> getAddedEdges() {
        return this.addedEdges;
    }

    private void setBadEdges(List<DEdge> edges) {
        this.badEdges = edges;
    }

    List<DEdge> getBadEdges() {
        return this.badEdges;
    }

    List<DTriangle> insertPoint(DPoint pt, List<DEdge> constraints) throws DelaunayError {
        List<DTriangle> addedTri;
        if (constraints != null && !constraints.isEmpty() && !pt.equals(constraints.get(0).getPointLeft())) {
            throw new DelaunayError(106, "the point and the constraint do not match.");
        }
        List<Integer> indices = this.getEligibleParts(pt);
        if (indices.isEmpty()) {
            throw new DelaunayError(106);
        }
        ArrayList<BoundaryPart> splitList = new ArrayList<BoundaryPart>();
        if (indices.size() == 1) {
            BoundaryPart bp;
            int index = indices.get(0);
            if (index == -1) {
                index = 0;
                DEdge ed = new DEdge(this.boundary.get(0).getConstraint().getPointLeft(), pt);
                if (constraints != null && !constraints.isEmpty()) {
                    for (DEdge con : constraints) {
                        ed = ed.equals(con) ? con : ed;
                    }
                }
                ed.setDegenerated(true);
                LinkedList<DEdge> led = new LinkedList<DEdge>();
                led.add(ed);
                bp = new BoundaryPart(led);
                this.boundary.add(0, bp);
                addedTri = bp.connectPoint(pt);
                bp.getAddedEdges().add(ed);
            } else {
                bp = this.boundary.get(index);
                addedTri = bp.connectPoint(pt);
                if (index == 0 && bp.getConstraint() != null && bp.getConstraint().getPointRight().equals(pt)) {
                    bp.setConstraint(null);
                }
            }
            this.setBadEdges(bp.getBadEdges());
            this.setAddedEdges(bp.getAddedEdges());
            if (constraints != null && !constraints.isEmpty()) {
                BoundaryPart splitBp = bp.split(constraints.get(constraints.size() - 1));
                for (int i = 0; i < constraints.size() - 1; ++i) {
                    splitList.add(new BoundaryPart(constraints.get(i)));
                }
                splitList.add(splitBp);
                this.boundary.addAll(index + 1, splitList);
            }
        } else {
            BoundaryPart bp = this.boundary.get(indices.get(0));
            BoundaryPart newBP = indices.get(0) == 0 && bp.getConstraint() != null && pt.equals(bp.getConstraint().getPointRight()) ? new BoundaryPart(new ArrayList<DEdge>()) : new BoundaryPart(new ArrayList<DEdge>(), bp.getConstraint());
            DEdge nextCstr = this.boundary.get(indices.get(1)).getConstraint();
            addedTri = bp.connectPoint(pt, nextCstr);
            List<DEdge> bad = bp.getBadEdges();
            List<DEdge> added = bp.getAddedEdges();
            int bpSize = bp.getBoundaryEdges().size();
            DEdge ed = bp.getBoundaryEdges().get(bpSize - 1);
            if (bpSize == 1 || ed.isLocked() && ed.isDegenerated()) {
                newBP.setBoundaryEdges(bp.getBoundaryEdges());
            } else {
                newBP.setBoundaryEdges(bp.getBoundaryEdges().subList(0, bpSize - 1));
            }
            for (int i = 1; i < indices.size(); ++i) {
                nextCstr = i + 1 < indices.size() ? this.boundary.get(indices.get(i + 1)).getConstraint() : null;
                bp = this.boundary.get(indices.get(i));
                addedTri.addAll(bp.connectPoint(pt, nextCstr));
                bad.addAll(bp.getBadEdges());
                List<DEdge> tmpAdded = bp.getAddedEdges();
                if (tmpAdded.size() <= 1) continue;
                added.get(added.size() - 1).setDegenerated(false);
                added.addAll(tmpAdded.subList(1, tmpAdded.size()));
            }
            List<DEdge> tmpLast = newBP.getBoundaryEdges();
            DEdge ed0 = bp.getBoundaryEdges().get(0);
            if (bp.getBoundaryEdges().size() == 1 && bp.getBoundaryEdges().get(0).equals(bp.getConstraint())) {
                if (!tmpLast.isEmpty() && !tmpLast.get(tmpLast.size() - 1).equals(bp.getConstraint())) {
                    tmpLast.add(bp.getConstraint());
                    if (bp.getConstraint().getPointLeft().equals(bp.getConstraint().getStartPoint())) {
                        bp.getConstraint().swap();
                    }
                }
            } else if (!(ed0.getRight() != null && ed0.getLeft() != null || ed0.equals(tmpLast.get(0)) || ed0.equals(tmpLast.get(tmpLast.size() - 1)))) {
                tmpLast.addAll(bp.getBoundaryEdges());
            } else {
                tmpLast.addAll(bp.getBoundaryEdges().subList(1, bp.getBoundaryEdges().size()));
            }
            newBP.setBoundaryEdges(tmpLast);
            this.setAddedEdges(added);
            this.setBadEdges(bad);
            if (constraints != null && !constraints.isEmpty()) {
                BoundaryPart splitBp = newBP.split(constraints.get(constraints.size() - 1));
                for (int i = 0; i < constraints.size() - 1; ++i) {
                    splitList.add(new BoundaryPart(constraints.get(i)));
                }
                splitList.add(splitBp);
                ArrayList<BoundaryPart> tmpBd = new ArrayList<BoundaryPart>();
                tmpBd.addAll(this.boundary);
                this.boundary = new ArrayList<BoundaryPart>();
                this.boundary.addAll(tmpBd.subList(0, indices.get(0)));
                this.boundary.add(newBP);
                this.boundary.addAll(splitList);
                this.boundary.addAll(tmpBd.subList(indices.get(indices.size() - 1) + 1, tmpBd.size()));
            } else {
                this.boundary.set(indices.get(0), newBP);
                ArrayList<BoundaryPart> tmpBd = new ArrayList<BoundaryPart>();
                tmpBd.addAll(this.boundary);
                this.boundary = new ArrayList<BoundaryPart>();
                this.boundary.addAll(tmpBd.subList(0, indices.get(0) + 1));
                this.boundary.addAll(tmpBd.subList(indices.get(indices.size() - 1) + 1, tmpBd.size()));
            }
        }
        return addedTri;
    }

    List<DTriangle> insertPoint(DPoint point) throws DelaunayError {
        return this.insertPoint(point, null);
    }

    List<Integer> getEligibleParts(DPoint point) {
        int index;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (this.boundary.size() <= 1) {
            if (this.boundary.get(0).getConstraint() != null && this.boundary.get(0).getConstraint().isRight(point)) {
                ret.add(-1);
            } else {
                ret.add(0);
            }
            return ret;
        }
        int size = this.boundary.size();
        if (this.boundary.get(0).getConstraint() != null && this.boundary.get(0).getConstraint().isRight(point)) {
            ret.add(-1);
            return ret;
        }
        if (this.boundary.get(0).getConstraint() != null && this.boundary.get(0).isConstraintRightPoint(point)) {
            ret.add(0);
            ret.addAll(this.getUpperSameRightPoint(0, this.boundary.get(0)));
            return ret;
        }
        if (this.boundary.get(1).isConstraintRightPoint(point)) {
            ret.add(0);
            ret.add(1);
            ret.addAll(this.getUpperSameRightPoint(1, this.boundary.get(1)));
            return ret;
        }
        if (this.boundary.get(1).pointIsLower(point)) {
            ret.add(0);
            return ret;
        }
        if (this.boundary.get(size - 1).isConstraintRightPoint(point)) {
            ret.addAll(this.getLowerSameRightPoint(size - 1, this.boundary.get(size - 1)));
            ret.add(size - 1);
            return ret;
        }
        if (this.boundary.get(size - 1).pointIsUpper(point)) {
            ret.add(size - 1);
            return ret;
        }
        int delta = index = this.boundary.size() / 2;
        boolean next = true;
        while (next) {
            BoundaryPart bpo;
            BoundaryPart bp = this.boundary.get(index);
            if (bp.pointIsUpper(point)) {
                bpo = this.boundary.get(index + 1);
                if (bpo.pointIsLower(point)) {
                    ret.add(index);
                    return ret;
                }
                if (bpo.isConstraintRightPoint(point)) {
                    ret.add(index);
                    ret.addAll(this.getUpperSameRightPoint(index, bpo));
                    return ret;
                }
                delta = delta / 2 > 0 ? delta / 2 : 1;
                index += delta;
                continue;
            }
            if (bp.isConstraintRightPoint(point)) {
                ret.addAll(this.getLowerSameRightPoint(index, bp));
                ret.add(index);
                ret.addAll(this.getUpperSameRightPoint(index, bp));
                return ret;
            }
            bpo = this.boundary.get(index - 1);
            if (bpo.pointIsUpper(point)) {
                ret.add(index - 1);
                return ret;
            }
            if (bpo.isConstraintRightPoint(point)) {
                ret.addAll(this.getLowerSameRightPoint(index - 1, bpo));
                ret.add(index - 1);
                return ret;
            }
            delta = delta / 2 > 0 ? delta / 2 : 1;
            index -= delta;
        }
        return ret;
    }

    private List<Integer> getUpperSameRightPoint(int index, BoundaryPart orig) {
        BoundaryPart bp;
        DPoint point = orig.getConstraint().getPointRight();
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = index + 1; i < this.boundary.size() && (bp = this.boundary.get(i)).getConstraint().getPointRight().equals(point); ++i) {
            ret.add(i);
        }
        return ret;
    }

    private List<Integer> getLowerSameRightPoint(int index, BoundaryPart orig) {
        DPoint point = orig.getConstraint().getPointRight();
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = index - 1; i >= 0; --i) {
            BoundaryPart bp = this.boundary.get(i);
            if (!bp.getConstraint().getPointRight().equals(point)) {
                ret.add(i);
                break;
            }
            ret.add(i);
        }
        Collections.reverse(ret);
        return ret;
    }
}

