/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdelaunay.delaunay.VerticalComparator;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.tools.Tools;

public class VerticalList {
    private List<DEdge> constraintsList = new ArrayList<DEdge>();
    private VerticalComparator comp;
    private DPoint lastUpperPt;
    private DEdge lastUpperEd;
    private DPoint lastLowerPt;
    private DEdge lastLowerEd;

    public VerticalList() {
        this.comp = new VerticalComparator(0.0);
        this.resetVolatileAttributes();
    }

    public VerticalList(double abs) {
        this.comp = new VerticalComparator(abs);
        this.resetVolatileAttributes();
    }

    public VerticalList(DPoint pt) {
        this(pt.getX());
    }

    public final double getAbs() {
        return this.comp.getAbs();
    }

    public final void setAbs(double abs) throws DelaunayError {
        this.resetVolatileAttributes();
        if (abs != this.comp.getAbs()) {
            this.comp.setAbs(abs);
            this.sort();
        }
    }

    public final void setAbs(DPoint pt) throws DelaunayError {
        this.setAbs(pt.getX());
    }

    public final DEdge get(int i) {
        return this.constraintsList.get(i);
    }

    public final void addEdges(List<DEdge> constraints) {
        this.resetVolatileAttributes();
        for (DEdge edge : constraints) {
            Tools.addToSortedList(edge, this.constraintsList, this.comp);
        }
    }

    public final int addEdge(DEdge constraint) {
        this.resetVolatileAttributes();
        if (this.constraintsList == null) {
            this.constraintsList = new ArrayList<DEdge>();
        }
        return Tools.addToSortedList(constraint, this.constraintsList, this.comp);
    }

    public final void removeEdge(DEdge constr) {
        this.resetVolatileAttributes();
        int index = Collections.binarySearch(this.constraintsList, constr, this.comp);
        if (index >= 0) {
            this.constraintsList.remove(constr);
        }
    }

    public final DEdge remove(int index) {
        this.resetVolatileAttributes();
        return this.constraintsList.remove(index);
    }

    protected final int searchEdge(DEdge edge) {
        return Tools.sortedListContains(this.constraintsList, edge, this.comp);
    }

    public final List<DEdge> getVerticallySortedEdges() {
        return this.constraintsList;
    }

    public final DEdge getLastLowerEd() {
        return this.lastLowerEd;
    }

    public final DPoint getLastLowerPt() {
        return this.lastLowerPt;
    }

    public final DEdge getLastUpperEd() {
        return this.lastUpperEd;
    }

    public final DPoint getLastUpperPt() {
        return this.lastUpperPt;
    }

    public final void removeEdgeFromRightPoint(DPoint rightPt) throws DelaunayError {
        this.setAbs(rightPt);
        DEdge ed = new DEdge(rightPt, rightPt);
        int index = this.searchEdge(ed);
        int i = index = index < 0 ? -index - 1 : index;
        while (i < this.constraintsList.size() && this.constraintsList.get(i).getPointRight().equals(rightPt)) {
            this.constraintsList.remove(i);
        }
        for (i = index - 1; i >= 0 && this.constraintsList.get(i).getPointRight().equals(rightPt); --i) {
            this.constraintsList.remove(i);
        }
    }

    protected final void sort() throws DelaunayError {
        this.resetVolatileAttributes();
        int s = this.constraintsList.size();
        int i = 0;
        int c = 0;
        while (i < s - 1) {
            DEdge e2;
            DEdge e1 = this.constraintsList.get(i);
            c = this.comp.compare(e1, e2 = this.constraintsList.get(i + 1));
            if (c == 1) {
                this.constraintsList.set(i, e2);
                this.constraintsList.set(i + 1, e1);
                i = i - 1 < 0 ? 0 : i - 1;
                continue;
            }
            ++i;
        }
    }

    public final int size() {
        return this.constraintsList.size();
    }

    private void resetVolatileAttributes() {
        this.lastUpperEd = null;
        this.lastUpperPt = null;
        this.lastLowerEd = null;
        this.lastLowerPt = null;
    }

    public final DEdge getUpperEdge(DPoint point) throws DelaunayError {
        double edgeOrd;
        if (this.constraintsList == null || this.constraintsList.isEmpty()) {
            this.lastUpperEd = null;
            return null;
        }
        if (this.lastUpperPt != null && this.lastUpperPt.equals(point)) {
            return this.lastUpperEd;
        }
        int size = this.constraintsList.size();
        double abs = point.getX();
        if (1.0E-7 < Math.abs(abs - this.getAbs())) {
            this.setAbs(abs);
        }
        this.lastUpperPt = point;
        DEdge search = new DEdge(point, new DPoint(point.getX() + 1.0, point.getY(), point.getZ()));
        int index = Collections.binarySearch(this.constraintsList, search, this.comp);
        int n = index = index < 0 ? -index - 1 : index;
        if (index == size) {
            this.lastUpperEd = null;
            return null;
        }
        while (Math.abs((edgeOrd = this.constraintsList.get(index).getPointFromItsX(abs).getY()) - point.getY()) < 1.0E-7 && ++index < size) {
        }
        edgeOrd = this.constraintsList.get(--index).getPointFromItsX(abs).getY();
        if (index < size && Math.abs(edgeOrd - point.getY()) >= 1.0E-7) {
            search = this.constraintsList.get(index);
            if (index < size - 1) {
                do {
                    DPoint rightNext;
                    DEdge next = this.constraintsList.get(index + 1);
                    DPoint rightSearch = search.getPointFromItsX(abs);
                    if (!rightSearch.equals(rightNext = next.getPointFromItsX(abs))) break;
                    search = next;
                } while (++index < size - 1);
            }
            this.lastUpperEd = search;
            return this.lastUpperEd;
        }
        this.lastUpperEd = null;
        return null;
    }

    public final DEdge getLowerEdge(DPoint point) throws DelaunayError {
        double edgeOrd;
        DEdge edgeTmp;
        DPoint pointTmp;
        if (this.constraintsList == null || this.constraintsList.isEmpty()) {
            this.lastLowerEd = null;
            return null;
        }
        if (this.lastLowerPt != null && this.lastLowerPt.equals(point)) {
            return this.lastLowerEd;
        }
        double abs = point.getX();
        if (1.0E-7 < Math.abs(abs - this.getAbs())) {
            this.setAbs(abs);
        }
        this.lastLowerPt = point;
        DEdge search = new DEdge(point, new DPoint(point.getX() + 1.0, point.getY(), point.getZ()));
        int index = Collections.binarySearch(this.constraintsList, search, this.comp);
        int n = index = index < 0 ? -index - 1 : index;
        if (--index < 0) {
            this.lastLowerEd = null;
            return null;
        }
        boolean cont = true;
        while ((cont = (pointTmp = (edgeTmp = this.constraintsList.get(index)).getPointFromItsX(abs)) == null ? true : Math.abs((edgeOrd = pointTmp.getY()) - point.getY()) < 1.0E-7) && --index >= 0) {
        }
        if ((pointTmp = this.constraintsList.get(++index).getPointFromItsX(abs)) == null) {
            this.lastLowerEd = null;
            return null;
        }
        edgeOrd = pointTmp.getY();
        if (index >= 0 && Math.abs(edgeOrd - point.getY()) >= 1.0E-7) {
            if (index > 0) {
                do {
                    DPoint rightPrev;
                    DEdge prev = this.constraintsList.get(index - 1);
                    DPoint rightSearch = search.getPointFromItsX(abs);
                    if (!rightSearch.equals(rightPrev = prev.getPointFromItsX(abs))) break;
                    search = prev;
                } while (--index > 0);
            }
            this.lastLowerEd = this.constraintsList.get(index);
            return this.lastLowerEd;
        }
        this.lastLowerEd = null;
        return null;
    }

    public final boolean intersectsUpperOrLower(DPoint pRef, DEdge ed) throws DelaunayError {
        int inter;
        this.setAbs(pRef);
        DEdge upper = this.getUpperEdge(pRef);
        if (upper != null && (inter = upper.intersects(ed)) == 1) {
            return true;
        }
        DEdge lower = this.getLowerEdge(pRef);
        return lower != null && (inter = lower.intersects(ed)) == 1;
    }
}

