/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.error;

public class DelaunayError
extends Exception {
    private static final long serialVersionUID = 1L;
    private int code;
    public static final int DELAUNAY_ERROR_NO_ERROR = 0;
    public static final int DELAUNAY_ERROR_NO_MESH = 100;
    public static final int DELAUNAY_ERROR_NOT_GENERATED = 101;
    public static final int DELAUNAY_ERROR_GENERATED = 102;
    public static final int DELAUNAY_ERROR_NOT_ENOUGH_POINTS_FOUND = 103;
    public static final int DELAUNAY_ERROR_PROXIMITY = 104;
    public static final int DELAUNAY_ERROR_POINT_NOT_FOUND = 105;
    public static final int DELAUNAY_ERROR_CAN_NOT_CONNECT_POINT = 106;
    public static final int DELAUNAY_ERROR_CAN_NOT_SPLIT_BP = 107;
    public static final int DELAUNAY_ERROR_MESH_ALREADY_EXISTS = 108;
    public static final int DELAUNAY_ERROR_NON_INSERTED_POINT = 200;
    public static final int DELAUNAY_ERROR_INCORRECT_TOPOLOGY = 201;
    public static final int DELAUNAY_ERROR_OUTSIDE_TRIANGLE = 202;
    public static final int DELAUNAY_ERROR_REMOVING_EDGE = 203;
    public static final int DELAUNAY_ERROR_ERROR_POINT_XYZ = 300;
    public static final int DELAUNAY_ERROR_INVALID_CALL = 998;
    public static final int DELAUNAY_ERROR_INTERNAL_ERROR = 999;
    public static final int DELAUNAY_ERROR_MISC = 1000;
    private String message = "";

    public DelaunayError() {
        this.code = 999;
    }

    public DelaunayError(String s) {
        super(s);
        this.message = s;
        this.code = 1000;
    }

    public DelaunayError(int errorCode) {
        this.code = errorCode;
    }

    public DelaunayError(int errorCode, String s) {
        this.message = s;
        this.code = errorCode;
    }

    @Override
    public final String getMessage() {
        String ret;
        switch (this.code) {
            case 0: {
                ret = "no error";
                break;
            }
            case 100: {
                ret = "no mesh found to start process";
                break;
            }
            case 102: {
                ret = "triangulation has already been processed";
                break;
            }
            case 101: {
                ret = "triangulation has not yet been processed";
                break;
            }
            case 103: {
                ret = "not enough points found to triangularize";
                break;
            }
            case 104: {
                ret = "distance between the two points is too small";
                break;
            }
            case 105: {
                ret = "point not found";
                break;
            }
            case 106: {
                ret = "Can't connect the point to the boundary";
                break;
            }
            case 107: {
                ret = "Can't split this boundary part";
                break;
            }
            case 108: {
                ret = "mesh already defined";
                break;
            }
            case 200: {
                ret = "one point is not inserted in the triangularization";
                break;
            }
            case 201: {
                ret = "Incorrect topology";
                break;
            }
            case 202: {
                ret = "point is outside the triangle";
                break;
            }
            case 203: {
                ret = "Problem while removing an edge";
                break;
            }
            case 300: {
                ret = "point should have X, Y and Z coordinates";
                break;
            }
            case 998: {
                ret = "Invalid function call";
                break;
            }
            case 999: {
                ret = "internal error, please call support";
                break;
            }
            default: {
                return this.message;
            }
        }
        if (this.message.isEmpty()) {
            return ret;
        }
        return ret + ", " + this.message;
    }
}

