/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.evaluator;

import org.jdelaunay.delaunay.evaluator.InsertionEvaluator;
import org.jdelaunay.delaunay.geometries.DTriangle;

public class SkinnyEvaluator
implements InsertionEvaluator {
    public static final double MAX_VALUE = 32.0;
    private double minAngle;

    public SkinnyEvaluator(double minAngle) {
        if (minAngle > 32.0) {
            throw new IllegalArgumentException("you can't use threshold values greater than 32\u00b0");
        }
        if (minAngle < 0.0) {
            throw new IllegalArgumentException("Threshold value can't be negative");
        }
        this.minAngle = minAngle;
    }

    public final double getMinAngle() {
        return this.minAngle;
    }

    public final void setMinAngle(double minAngle) {
        if (minAngle > 32.0) {
            throw new IllegalArgumentException("you can't use threshold values greater than 32\u00b0");
        }
        if (minAngle < 0.0) {
            throw new IllegalArgumentException("Threshold value can't be negative");
        }
        this.minAngle = minAngle;
    }

    @Override
    public final boolean evaluate(DTriangle dt) {
        return this.minAngle > dt.getMinAngle();
    }
}

