/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.evaluator;

import org.jdelaunay.delaunay.evaluator.InsertionEvaluator;
import org.jdelaunay.delaunay.geometries.DTriangle;

public class TriangleQuality
implements InsertionEvaluator {
    private final double targetQuality;
    public static final double DEFAULT_QUALITY = 0.6;
    private static final double SQRT3 = Math.sqrt(3.0);

    public TriangleQuality() {
        this.targetQuality = 0.6;
    }

    public TriangleQuality(double targetQuality) {
        this.targetQuality = targetQuality;
    }

    @Override
    public boolean evaluate(DTriangle dTriangle) {
        return 4.0 * dTriangle.getArea() * SQRT3 / (Math.pow(dTriangle.getEdge(0).get2DLength(), 2.0) + Math.pow(dTriangle.getEdge(1).get2DLength(), 2.0) + Math.pow(dTriangle.getEdge(2).get2DLength(), 2.0)) < this.targetQuality;
    }
}

