/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.geometries;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.DPoint;

public class BoundaryBox
implements Serializable {
    private static final long serialVersionUID = 5019273961990097490L;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private double minz;
    private double maxz;
    private Coordinate middle;
    private boolean empty;

    private void init() {
        this.minx = 0.0;
        this.maxx = 0.0;
        this.miny = 0.0;
        this.maxy = 0.0;
        this.minz = 0.0;
        this.maxz = 0.0;
        this.empty = true;
        this.middle = new Coordinate(0.0, 0.0, 0.0);
    }

    public BoundaryBox() {
        this.init();
    }

    public BoundaryBox(double pminx, double pmaxx, double pminy, double pmaxy, double pminz, double pmaxz) {
        this.init();
        this.setBox(pminx, pmaxx, pminy, pmaxy, pminz, pmaxz);
    }

    public BoundaryBox(BoundaryBox aBox) {
        this.init();
        this.empty = aBox.empty;
        this.setBox(aBox.minx, aBox.maxx, aBox.miny, aBox.maxy, aBox.minz, aBox.maxz);
    }

    public final void setBox(double x1, double x2, double y1, double y2, double z1, double z2) {
        this.minx = x1 < x2 ? x1 : x2;
        this.maxx = x1 < x2 ? x2 : x1;
        this.miny = y1 < y2 ? y1 : y2;
        this.maxy = y1 < y2 ? y2 : y1;
        this.minz = z1 < z2 ? z1 : z2;
        this.maxz = z1 < z2 ? z2 : z1;
        this.empty = false;
        this.updateMiddle();
    }

    private void updateMiddle() {
        double mx = (this.maxx - this.minx) / 2.0;
        double my = (this.maxy - this.miny) / 2.0;
        double mz = (this.maxz - this.minz) / 2.0;
        this.middle = new Coordinate(this.minx + mx, this.miny + my, this.minz + mz);
    }

    public final void alterBox(double x, double y, double z) {
        if (this.empty) {
            this.minx = x;
            this.maxx = x;
            this.miny = y;
            this.maxy = y;
            this.minz = z;
            this.maxz = z;
            this.empty = false;
        } else {
            if (this.minx > x) {
                this.minx = x;
            } else if (this.maxx < x) {
                this.maxx = x;
            }
            if (this.miny > y) {
                this.miny = y;
            } else if (this.maxy < y) {
                this.maxy = y;
            }
            if (this.minz > z) {
                this.minz = z;
            } else if (this.maxz < z) {
                this.maxz = z;
            }
        }
        this.updateMiddle();
    }

    public final void alterBox(Coordinate aPoint) {
        this.alterBox(aPoint.x, aPoint.y, aPoint.z);
    }

    public final void alterBox(DPoint point) {
        Coordinate aPoint = point.getCoordinate();
        this.alterBox(aPoint);
    }

    public final Coordinate getMiddle() {
        return this.middle;
    }

    public final String toString() {
        return "min x[" + this.minx + "] y[" + this.miny + "] z[" + this.minz + "] | max x[" + this.maxx + "] y[" + this.maxy + "] z[" + this.maxz + "]";
    }

    public final List<DPoint> getPoints() throws DelaunayError {
        if (this.empty) {
            return new ArrayList<DPoint>();
        }
        ArrayList<DPoint> points = new ArrayList<DPoint>();
        points.add(new DPoint(this.minx, this.miny, this.minz));
        points.add(new DPoint(this.maxx, this.maxy, this.maxz));
        return points;
    }
}

