/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.geometries;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.BoundaryBox;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.geometries.DTriangle;
import org.jdelaunay.delaunay.geometries.Element;

public final class ConstraintPolygon
extends Element {
    private static final long serialVersionUID = 1L;
    private Polygon polygon;
    private List<DEdge> edges;
    private DTriangle refTriangle;
    private boolean usePolygonZ;
    private boolean isEmpty;

    public ConstraintPolygon(Polygon polygon) throws DelaunayError {
        this.usePolygonZ = false;
        this.isEmpty = false;
        this.init(polygon);
    }

    public ConstraintPolygon(Polygon polygon, boolean isEmpty) throws DelaunayError {
        this.init(polygon);
        this.usePolygonZ = false;
        this.isEmpty = isEmpty;
    }

    public ConstraintPolygon(Polygon polygon, int property) throws DelaunayError {
        super(property);
        this.usePolygonZ = false;
        this.isEmpty = false;
        this.init(polygon);
    }

    public ConstraintPolygon(Polygon polygon, int property, boolean usePolygonZ) throws DelaunayError {
        super(property);
        this.usePolygonZ = usePolygonZ;
        this.isEmpty = false;
        this.init(polygon);
    }

    public ConstraintPolygon(Polygon polygon, int property, boolean usePolygonZ, boolean isEmpty) throws DelaunayError {
        super(property);
        this.usePolygonZ = usePolygonZ;
        this.isEmpty = isEmpty;
        this.init(polygon);
    }

    private void init(Polygon polygon) throws DelaunayError {
        if (polygon.isEmpty()) {
            throw new IllegalArgumentException("Polygon is empty");
        }
        this.polygon = polygon;
        this.refTriangle = null;
        this.edges = new ArrayList<DEdge>();
        int nbPoints = polygon.getNumPoints();
        if (Double.isNaN(polygon.getCoordinates()[0].z)) {
            polygon.getCoordinates()[0].z = 0.0;
        }
        DPoint lastPoint = new DPoint(polygon.getCoordinates()[0]);
        for (int i = 1; i < nbPoints; ++i) {
            if (Double.isNaN(polygon.getCoordinates()[i].z)) {
                polygon.getCoordinates()[i].z = 0.0;
            }
            DPoint aPoint = new DPoint(polygon.getCoordinates()[i]);
            DEdge aEdge = new DEdge(lastPoint, aPoint);
            this.edges.add(aEdge);
            lastPoint = aPoint;
        }
    }

    public boolean isUsePolygonZ() {
        return this.usePolygonZ;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public DTriangle getRefTriangle() {
        return this.refTriangle;
    }

    public void setRefTriangle(DTriangle refTriangle) {
        this.refTriangle = refTriangle;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public List<DEdge> getEdges() {
        return this.edges;
    }

    public List<DPoint> getPoints() throws DelaunayError {
        ArrayList<DPoint> points = new ArrayList<DPoint>(this.polygon.getNumPoints());
        for (int i = 0; i < this.polygon.getNumPoints() - 1; ++i) {
            DPoint aPoint = new DPoint(this.polygon.getCoordinates()[i]);
            points.add(aPoint);
        }
        return points;
    }

    @Override
    public BoundaryBox getBoundingBox() {
        BoundaryBox aBox = new BoundaryBox();
        int nbPoints = this.polygon.getNumPoints();
        for (int i = 0; i < nbPoints; ++i) {
            Coordinate pt = this.polygon.getCoordinates()[i];
            aBox.alterBox(pt.x, pt.y, pt.z);
        }
        return aBox;
    }

    @Override
    public boolean contains(DPoint aPoint) {
        return this.polygon.contains((Geometry)new GeometryFactory().createPoint(aPoint.getCoordinate()));
    }

    public boolean contains(DEdge anEdge) throws DelaunayError {
        DPoint aPoint = anEdge.getBarycenter();
        boolean intersectPolygon = this.polygon.contains((Geometry)new GeometryFactory().createPoint(aPoint.getCoordinate()));
        boolean edgeColinear = false;
        boolean intersectEdge = false;
        for (int i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i).haveSamePoint(anEdge)) {
                edgeColinear = true;
                continue;
            }
            if (this.edges.get(i).intersects(anEdge.getStartPoint(), anEdge.getEndPoint()) != 1) continue;
            intersectEdge = true;
        }
        boolean c1 = intersectPolygon && !intersectEdge;
        boolean c2 = !intersectPolygon && edgeColinear && !intersectEdge;
        return c1 || c2;
    }

    @Override
    public boolean contains(Coordinate coordinate) throws DelaunayError {
        return this.polygon.contains((Geometry)new GeometryFactory().createPoint(coordinate));
    }

    public boolean isIntersect(DEdge anEdge) throws DelaunayError {
        boolean intersect = false;
        for (int i = 0; i < this.edges.size() && !intersect; ++i) {
            intersect = this.edges.get(i).intersects(anEdge.getStartPoint(), anEdge.getEndPoint()) == 1;
        }
        return intersect;
    }
}

