/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.geometries;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.Map;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.BoundaryBox;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.geometries.DTriangle;
import org.jdelaunay.delaunay.geometries.Element;

public class DEdge
extends Element
implements Comparable<DEdge> {
    private static final long serialVersionUID = 1L;
    private DPoint startPoint;
    private DPoint endPoint;
    private DTriangle left;
    private DTriangle right;
    private transient boolean degenerated = false;
    private transient boolean shared = false;
    private boolean indicator;
    public static final int UPSLOPE = -1;
    public static final int DOWNSLOPE = 1;
    public static final int FLATSLOPE = 0;
    public static final int NO_INTERSECTION = 0;
    public static final int INTERSECT = 1;
    public static final int COLINEAR = 2;
    public static final int SHARE_EXTREMITY = 3;
    public static final int SHARE_EDGE_PART = 4;

    private void init() {
        this.startPoint = null;
        this.endPoint = null;
        this.left = null;
        this.right = null;
        this.indicator = false;
    }

    public DEdge() {
        this.init();
    }

    public DEdge(DPoint start, DPoint end) {
        this.init();
        this.startPoint = start;
        this.endPoint = end;
    }

    public DEdge(DEdge ed) {
        super(ed);
        this.init();
        this.startPoint = ed.startPoint;
        this.endPoint = ed.endPoint;
        this.left = ed.left;
        this.right = ed.right;
        this.indicator = ed.indicator;
        this.setProperty(ed.getProperty());
    }

    public DEdge(double x, double y, double z, double u, double v, double w) throws DelaunayError {
        this.init();
        DPoint p1 = new DPoint(x, y, z);
        DPoint p2 = new DPoint(u, v, w);
        this.startPoint = p1;
        this.endPoint = p2;
    }

    @Override
    public final void addProperty(int prop) {
        super.addProperty(prop);
        this.startPoint.addProperty(prop);
        this.endPoint.addProperty(prop);
    }

    public final DTriangle getLeft() {
        return this.left;
    }

    public final DTriangle getRight() {
        return this.right;
    }

    public final DTriangle getOtherTriangle(DTriangle tri) {
        if (tri == null) {
            return null;
        }
        if (tri.equals(this.right)) {
            return this.left;
        }
        if (tri.equals(this.left)) {
            return this.right;
        }
        return null;
    }

    public final void setLeft(DTriangle aTriangle) {
        this.left = aTriangle;
    }

    public final void setRight(DTriangle aTriangle) {
        this.right = aTriangle;
    }

    public final DPoint getStartPoint() {
        return this.startPoint;
    }

    public final DPoint getEndPoint() {
        return this.endPoint;
    }

    public final boolean isDegenerated() {
        return this.degenerated;
    }

    public final void setDegenerated(boolean degen) {
        this.degenerated = degen;
    }

    public final boolean isShared() {
        return this.shared;
    }

    public final void setShared(boolean share) {
        this.shared = share;
    }

    public final void setStartPoint(DPoint p) {
        this.startPoint = p;
    }

    public final void setEndPoint(DPoint p) {
        this.endPoint = p;
    }

    public final DPoint getPointLeft() {
        int c = this.endPoint.compareTo2D(this.startPoint);
        switch (c) {
            case -1: {
                return this.endPoint;
            }
        }
        return this.startPoint;
    }

    public final DPoint getPointRight() {
        int c = this.endPoint.compareTo2D(this.startPoint);
        switch (c) {
            case 1: {
                return this.endPoint;
            }
        }
        return this.startPoint;
    }

    public final double getSquared2DLength() {
        return this.startPoint.squareDistance2D(this.endPoint);
    }

    public final double get2DLength() {
        return Math.sqrt(this.getSquared2DLength());
    }

    protected final double getSquared3DLength() {
        return this.startPoint.squareDistance(this.endPoint);
    }

    public final double get3DLength() {
        return Math.sqrt(this.getSquared3DLength());
    }

    public final boolean isLocked() {
        return this.indicator;
    }

    public final void setLocked(boolean locked) {
        this.indicator = locked;
    }

    @Override
    public final BoundaryBox getBoundingBox() {
        BoundaryBox box = new BoundaryBox();
        box.alterBox(this.startPoint);
        box.alterBox(this.endPoint);
        return box;
    }

    @Override
    public final boolean contains(DPoint aPoint) {
        return this.contains(aPoint.getCoordinate());
    }

    @Override
    public final boolean contains(Coordinate c) {
        boolean px;
        DPoint p1 = this.startPoint;
        DPoint p2 = this.endPoint;
        double ux = p2.getX() - p1.getX();
        double uy = p2.getY() - p1.getY();
        double vx = c.x - p1.getX();
        double vy = c.y - p1.getY();
        double res = ux * vy - uy * vx;
        boolean bl = ux >= 0.0 ? p1.getX() - 1.0E-7 <= c.x && c.x <= p2.getX() + 1.0E-7 : (px = p2.getX() - 1.0E-7 <= c.x && c.x <= p1.getX() + 1.0E-7);
        boolean py = uy >= 0.0 ? p1.getY() - 1.0E-7 <= c.y && c.y <= p2.getY() + 1.0E-7 : p2.getY() - 1.0E-7 <= c.y && c.y <= p1.getY() + 1.0E-7;
        return res <= 1.0E-7 && res >= -1.0E-7 && px && py;
    }

    public final double getDistance2D(DPoint p) {
        if (this.isVertical()) {
            return Math.abs(p.getX() - this.startPoint.getX());
        }
        double a = (this.endPoint.getY() - this.startPoint.getY()) / (this.endPoint.getX() - this.startPoint.getX());
        double b = this.endPoint.getY() - a * this.endPoint.getX();
        return Math.abs(a * p.getX() - p.getY() + b) / Math.sqrt(1.0 + a * a);
    }

    public final int intersects(DEdge other) throws DelaunayError {
        return this.intersects(other.getStartPoint(), other.getEndPoint());
    }

    public final int intersects(DPoint p1, DPoint p2) throws DelaunayError {
        DPoint p3 = this.startPoint;
        DPoint p4 = this.endPoint;
        Element inter = this.getIntersection(p1, p2, false);
        if (inter == null) {
            double b2;
            double a2;
            double a1 = p2.getX() - p1.getX();
            double b1 = p4.getX() - p3.getX();
            double d = b1 * (a2 = p2.getY() - p1.getY()) - (b2 = p4.getY() - p3.getY()) * a1;
            if (-9.999999999999998E-15 < d && d < 9.999999999999998E-15) {
                return 2;
            }
            return 0;
        }
        if (inter instanceof DPoint) {
            DPoint interPoint = (DPoint)inter;
            if ((interPoint.squareDistance2D(p1) < 9.999999999999998E-15 || interPoint.squareDistance2D(p2) < 9.999999999999998E-15) && (interPoint.squareDistance2D(p3) < 9.999999999999998E-15 || interPoint.squareDistance2D(p4) < 9.999999999999998E-15)) {
                return 3;
            }
            return 1;
        }
        if (inter instanceof DEdge) {
            return 4;
        }
        return 0;
    }

    public final Element getIntersection(DPoint p1, DPoint p2) throws DelaunayError {
        return this.getIntersection(p1, p2, false);
    }

    public final Element getIntersection(DPoint point1, DPoint point2, boolean useCoordZOfp1p2) throws DelaunayError {
        DPoint p2;
        DPoint p1;
        Element intersection = null;
        DPoint p3 = this.getPointLeft();
        DPoint p4 = this.getPointRight();
        switch (point1.compareTo2D(point2)) {
            case 1: {
                p1 = point2;
                p2 = point1;
                break;
            }
            default: {
                p1 = point1;
                p2 = point2;
            }
        }
        double deltaXO = p2.getX() - p1.getX();
        double deltaXT = p4.getX() - p3.getX();
        double c1 = p3.getX() - p1.getX();
        double deltaYO = p2.getY() - p1.getY();
        double deltaYT = p4.getY() - p3.getY();
        double c2 = p3.getY() - p1.getY();
        double d = deltaXT * deltaYO - deltaYT * deltaXO;
        if (Math.abs(d) > 1.0E-7) {
            if (p1.compareTo2D(p4) == 1 || p3.compareTo2D(p2) == 1) {
                return null;
            }
            double t1 = (c2 * deltaXT - c1 * deltaYT) / d;
            double t2 = (deltaXO * c2 - deltaYO * c1) / d;
            if (-9.999999999999998E-15 <= t1 && t1 <= 1.00000000000001 && -9.999999999999998E-15 <= t2 && t2 <= 1.00000000000001) {
                if (t2 <= 9.999999999999998E-15) {
                    intersection = p3;
                    if (useCoordZOfp1p2) {
                        double z = p2.getZ() * t1 + (1.0 - t1) * p1.getZ();
                        p3.setZ(z);
                    }
                } else if (t2 >= 0.99999999999999) {
                    intersection = p4;
                    if (useCoordZOfp1p2) {
                        double z = p2.getZ() * t1 + (1.0 - t1) * p1.getZ();
                        p4.setZ(z);
                    }
                } else if (t1 <= 9.999999999999998E-15) {
                    intersection = p1;
                    if (!useCoordZOfp1p2) {
                        double z = p4.getZ() * t2 + (1.0 - t2) * p3.getZ();
                        p1.setZ(z);
                    }
                } else if (t1 >= 0.99999999999999) {
                    intersection = p2;
                    if (!useCoordZOfp1p2) {
                        double z = p4.getZ() * t2 + (1.0 - t2) * p3.getZ();
                        p2.setZ(z);
                    }
                } else {
                    double x = p2.getX() * t1 + (1.0 - t1) * p1.getX();
                    double y = p2.getY() * t1 + (1.0 - t1) * p1.getY();
                    double z = 0.0;
                    z = useCoordZOfp1p2 ? p2.getZ() * t1 + (1.0 - t1) * p1.getZ() : p4.getZ() * t2 + (1.0 - t2) * p3.getZ();
                    intersection = new DPoint(x, y, z);
                    intersection.setProperty(this.getProperty());
                }
            } else if (-1.0E-7 <= t1 && t1 <= 1.0000001 && -1.0E-7 <= t2 && t2 <= 1.0000001) {
                if (this.getDistance2D(p1) < 1.0E-7) {
                    return p1;
                }
                if (this.getDistance2D(p2) < 1.0E-7) {
                    return p2;
                }
                DEdge other = new DEdge(p1, p2);
                if (other.getDistance2D(p3) < 1.0E-7) {
                    return p3;
                }
                if (other.getDistance2D(p4) < 1.0E-7) {
                    return p4;
                }
            }
        } else {
            double test = Math.abs(deltaXO) < 9.999999999999998E-15 ? c1 / deltaXT - c2 / deltaYT : c1 / deltaXO - c2 / deltaYO;
            if (Math.abs(test) > 1.0E-7) {
                intersection = null;
            } else {
                double t22;
                double t21;
                double t14;
                double t13;
                if (Math.abs(deltaXO) < 1.0E-7) {
                    t13 = c2 / deltaYO;
                    t14 = (p4.getY() - p1.getY()) / deltaYO;
                } else {
                    t13 = c1 / deltaXO;
                    t14 = (p4.getX() - p1.getX()) / deltaXO;
                }
                if (Math.abs(deltaXT) > 1.0E-7) {
                    t21 = -c1 / deltaXT;
                    t22 = (p2.getX() - p3.getX()) / deltaXT;
                } else {
                    t21 = -c2 / deltaYT;
                    t22 = (p2.getY() - p3.getY()) / deltaYT;
                }
                if (-9.999999999999998E-15 < t13 && t13 < 1.00000000000001) {
                    if (-9.999999999999998E-15 < t14 && t14 < 1.00000000000001) {
                        if (!useCoordZOfp1p2) {
                            double z = p2.getZ() * t14 + (1.0 - t14) * p1.getZ();
                            p4.setZ(z);
                            z = p2.getZ() * t13 + (1.0 - t13) * p1.getZ();
                            p3.setZ(z);
                        }
                        intersection = new DEdge(p3, p4);
                    } else {
                        intersection = p3.squareDistance2D(p1) < 9.999999999999998E-15 ? (-9.999999999999998E-15 < t22 && t22 < 1.00000000000001 ? new DEdge(p1, p2) : p3) : (p3.squareDistance2D(p2) < 9.999999999999998E-15 ? (-9.999999999999998E-15 < t21 && t21 < 1.00000000000001 ? new DEdge(p1, p2) : p3) : (-9.999999999999998E-15 < t21 && t21 < 1.00000000000001 ? new DEdge(p1, p3) : new DEdge(p2, p3)));
                    }
                } else if (-9.999999999999998E-15 < t14 && t14 < 1.00000000000001) {
                    intersection = p4.squareDistance2D(p1) < 9.999999999999998E-15 ? (-9.999999999999998E-15 < t22 && t22 < 1.00000000000001 ? new DEdge(p1, p2) : p4) : (p4.squareDistance2D(p2) < 9.999999999999998E-15 ? (-9.999999999999998E-15 < t21 && t21 < 1.00000000000001 ? new DEdge(p1, p2) : p4) : (-9.999999999999998E-15 < t21 && t21 < 1.00000000000001 ? new DEdge(p1, p4) : new DEdge(p2, p4)));
                } else if (9.999999999999998E-15 < t21 && t21 < 0.99999999999999) {
                    intersection = new DEdge(p1, p2);
                }
            }
        }
        return intersection;
    }

    public final Element getIntersection(DEdge ed) throws DelaunayError {
        return this.getIntersection(ed.startPoint, ed.endPoint);
    }

    public final Element getIntersection(DEdge ed, Map<Integer, Integer> weights) throws DelaunayError {
        if (weights.isEmpty()) {
            return this.getIntersection(ed.startPoint, ed.endPoint, false);
        }
        int wt = this.getMaxWeight(weights);
        int wo = ed.getMaxWeight(weights);
        if (wo > wt) {
            return this.getIntersection(ed.startPoint, ed.endPoint, true);
        }
        return this.getIntersection(ed.startPoint, ed.endPoint, false);
    }

    public final double getZOnEdge(DPoint p) {
        if (!this.isOnEdge(p)) {
            return Double.NaN;
        }
        DPoint p1 = this.startPoint;
        DPoint p2 = this.endPoint;
        if (Math.abs(p2.getX() - p1.getX()) < 1.0E-7) {
            return (p2.getY() - p.getY()) * (p2.getZ() - p1.getZ()) / (p2.getY() - p1.getY());
        }
        return (p2.getX() - p.getX()) * (p2.getZ() - p1.getZ()) / (p2.getX() - p1.getX());
    }

    public final double getSlope() {
        double dz = this.endPoint.getZ() - this.startPoint.getZ();
        if (dz == 0.0) {
            return 0.0;
        }
        double projSize = this.get2DLength();
        if (Math.abs(projSize) < 1.0E-7) {
            return Double.NaN;
        }
        return dz / projSize;
    }

    public final double getSlopeInDegree() {
        return Math.toDegrees(Math.atan(this.getSlope()));
    }

    public final DPoint getDirectionVector() throws DelaunayError {
        double x = this.endPoint.getX() - this.startPoint.getX();
        double y = this.endPoint.getY() - this.startPoint.getY();
        double z = this.endPoint.getZ() - this.startPoint.getZ();
        double size = this.get3DLength();
        return new DPoint(x / size, y / size, z / size);
    }

    public final boolean isInside(DPoint p) {
        boolean isInside = false;
        DPoint p1 = this.startPoint;
        DPoint p2 = this.endPoint;
        double a1 = p2.getX() - p1.getX();
        double c1 = p.getX() - p1.getX();
        double a2 = p2.getY() - p1.getY();
        double c2 = p.getY() - p1.getY();
        if (Math.abs(a1) > 1.0E-7) {
            double t1 = c1 / a1;
            if (-1.0E-7 < t1 && t1 < 1.0000001) {
                if (Math.abs(a2) > 1.0E-7) {
                    double t2 = c2 / a2;
                    if (-1.0E-7 < t2 && t2 < 1.0000001 && Math.abs(t1 - t2) < 1.0E-7) {
                        isInside = true;
                    }
                } else if (Math.abs(c2) < 1.0E-7) {
                    isInside = true;
                }
            }
        } else if (Math.abs(c1) < 1.0E-7) {
            if (Math.abs(a2) > 1.0E-7) {
                double t2 = c2 / a2;
                if (-1.0E-7 < t2 && t2 < 1.0000001) {
                    isInside = true;
                }
            } else if (Math.abs(c2) < 1.0E-7) {
                isInside = true;
            }
        }
        return isInside;
    }

    public final boolean isColinear2D(DPoint p) {
        boolean isColinear2D = false;
        DPoint p1 = this.startPoint;
        DPoint p2 = this.endPoint;
        double a1 = p2.getX() - p1.getX();
        double c1 = p.getX() - p1.getX();
        double a2 = p2.getY() - p1.getY();
        double c2 = p.getY() - p1.getY();
        double t = a1 * c2 - a2 * c1;
        if (Math.abs(t) < 1.0E-7) {
            isColinear2D = true;
        }
        return isColinear2D;
    }

    public final boolean isColinear(DPoint p) {
        boolean isColinear = false;
        DPoint p1 = this.startPoint;
        DPoint p2 = this.endPoint;
        double a1 = p2.getX() - p1.getX();
        double c1 = p.getX() - p1.getX();
        double a2 = p2.getY() - p1.getY();
        double c2 = p.getY() - p1.getY();
        double a3 = p2.getZ() - p1.getZ();
        double c3 = p.getZ() - p1.getZ();
        double t1 = a1 * c2 - a2 * c1;
        double t2 = a1 * c3 - a3 * c1;
        double t3 = a3 * c2 - a2 * c3;
        if (Math.abs(t1) < 1.0E-7 && Math.abs(t2) < 1.0E-7 && Math.abs(t3) < 1.0E-7) {
            isColinear = true;
        }
        return isColinear;
    }

    public final boolean haveSamePoint(DEdge anEdge) {
        return this.getStartPoint().equals(anEdge.getStartPoint()) && this.getEndPoint().equals(anEdge.getEndPoint()) || this.getStartPoint().equals(anEdge.getEndPoint()) && this.getEndPoint().equals(anEdge.getStartPoint());
    }

    public final boolean isExtremity(DPoint p) {
        return this.startPoint.equals2D(p) || this.endPoint.equals2D(p);
    }

    public final boolean isLeft(DPoint p) {
        double ux = this.endPoint.getX() - this.startPoint.getX();
        double uy = this.endPoint.getY() - this.startPoint.getY();
        double vx = p.getX() - this.startPoint.getX();
        double vy = p.getY() - this.startPoint.getY();
        return ux * vy - uy * vx > 1.0E-7;
    }

    public final boolean isRight(DPoint p) {
        double ux = this.endPoint.getX() - this.startPoint.getX();
        double uy = this.endPoint.getY() - this.startPoint.getY();
        double vx = p.getX() - this.startPoint.getX();
        double vy = p.getY() - this.startPoint.getY();
        return ux * vy - uy * vx < -1.0E-7;
    }

    public final boolean isOnEdge(DPoint p) {
        boolean b1;
        DPoint p1 = this.startPoint;
        DPoint p2 = this.endPoint;
        double ux = p2.getX() - p1.getX();
        double uy = p2.getY() - p1.getY();
        double vx = p.getX() - p1.getX();
        double vy = p.getY() - p1.getY();
        double res = ux * vy - uy * vx;
        boolean bl = ux == 0.0 ? p1.getX() == p.getX() : (ux > 0.0 ? p1.getX() < p.getX() && p.getX() < p2.getX() : (b1 = p2.getX() < p.getX() && p.getX() < p1.getX()));
        boolean b2 = uy == 0.0 ? p1.getY() == p.getY() : (uy > 0.0 ? p1.getY() < p.getY() && p.getY() < p2.getY() : p2.getY() < p.getY() && p.getY() < p1.getY());
        return Math.abs(res) <= 1.0E-7 && b1 && b2;
    }

    public final boolean isVertical() {
        double dx = this.startPoint.getX() - this.endPoint.getX();
        double delta = dx < 0.0 ? -dx : dx;
        return delta < 1.0E-7;
    }

    public final DPoint getPointFromItsX(double abs) throws DelaunayError {
        if (Math.abs(this.getPointLeft().getX() - abs) < 1.0E-7) {
            return this.getPointLeft();
        }
        if (Math.abs(this.getPointRight().getX() - abs) < 1.0E-7) {
            return this.getPointRight();
        }
        double deltaX = this.startPoint.getX() - this.endPoint.getX();
        double dX = deltaX < 0.0 ? -deltaX : deltaX;
        double p = (abs - this.startPoint.getX()) / (this.endPoint.getX() - this.startPoint.getX());
        if (dX < 1.0E-7) {
            if (abs == this.startPoint.getX()) {
                return this.getPointLeft();
            }
            return null;
        }
        double y = this.startPoint.getY() + p * (this.endPoint.getY() - this.startPoint.getY());
        double z = this.startPoint.getZ() + p * (this.endPoint.getZ() - this.startPoint.getZ());
        DPoint dPoint = new DPoint(abs, y, z);
        dPoint.setProperty(this.getProperty());
        return dPoint;
    }

    public final DPoint getUpperPoint() {
        return this.startPoint.getZ() > this.endPoint.getZ() ? this.startPoint : this.endPoint;
    }

    public final DPoint getMiddle() throws DelaunayError {
        double dx = this.endPoint.getX() - this.startPoint.getX();
        double dy = this.endPoint.getY() - this.startPoint.getY();
        double dz = this.endPoint.getZ() - this.startPoint.getZ();
        DPoint dPoint = new DPoint(this.startPoint);
        dPoint.setX(this.startPoint.getX() + dx / 2.0);
        dPoint.setY(this.startPoint.getY() + dy / 2.0);
        dPoint.setZ(this.startPoint.getZ() + dz / 2.0);
        return dPoint;
    }

    public final boolean isEncroached() throws DelaunayError {
        DPoint other;
        if (!this.isLocked() && this.left != null && this.right != null) {
            return false;
        }
        DPoint middle = this.getMiddle();
        double length = this.getSquared2DLength() / 4.0;
        if (this.left != null && (other = this.left.getOppositePoint(this)).squareDistance2D(middle) < length) {
            return true;
        }
        return this.right != null && (other = this.right.getOppositePoint(this)).squareDistance2D(middle) < length;
    }

    public final boolean isEncroachedBy(DPoint pt) throws DelaunayError {
        if (!this.isLocked() && this.left != null && this.right != null) {
            return false;
        }
        DPoint middle = this.getMiddle();
        double length = this.getSquared2DLength() / 4.0;
        return pt.squareDistance2D(middle) < length;
    }

    public final void swap() {
        DPoint aPoint = this.endPoint;
        this.endPoint = this.startPoint;
        this.startPoint = aPoint;
        DTriangle aTriangle = this.left;
        this.left = this.right;
        this.right = aTriangle;
    }

    public final boolean isFlatSlope() {
        return !(Math.abs(this.startPoint.getZ() - this.endPoint.getZ()) > 1.0E-7);
    }

    public final DPoint getBarycenter() throws DelaunayError {
        double x = (this.startPoint.getX() + this.endPoint.getX()) / 2.0;
        double y = (this.startPoint.getY() + this.endPoint.getY()) / 2.0;
        double z = (this.startPoint.getZ() + this.endPoint.getZ()) / 2.0;
        return new DPoint(x, y, z);
    }

    public final boolean equals(Object other) {
        if (other instanceof DEdge) {
            DEdge otherEdge = (DEdge)other;
            return this.endPoint.equals(otherEdge.getEndPoint()) && this.startPoint.equals(otherEdge.getStartPoint()) || this.endPoint.equals(otherEdge.getStartPoint()) && this.startPoint.equals(otherEdge.getEndPoint());
        }
        return false;
    }

    public final int hashCode() {
        int v2;
        DPoint p1 = this.startPoint;
        DPoint p2 = this.endPoint;
        int hashValue = 0;
        int v1 = p1.hashCode();
        hashValue = v1 < (v2 = p2.hashCode()) ? v1 : v2;
        return hashValue;
    }

    protected final void setColor(Graphics g) {
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
        if (this.getProperty() != 0) {
            g.setColor(Color.red);
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
        } else if (this.isLocked()) {
            g.setColor(Color.CYAN);
        } else {
            g.setColor(Color.black);
        }
    }

    public final void displayObject(Graphics g, int decalageX, int decalageY, double minX, double minY, double scaleX, double scaleY) {
        this.setColor(g);
        g.drawLine((int)((this.startPoint.getX() - minX) * scaleX + (double)decalageX), decalageY + (int)((this.startPoint.getY() - minY) * scaleY), (int)((this.endPoint.getX() - minX) * scaleX + (double)decalageX), decalageY + (int)((this.endPoint.getY() - minY) * scaleY));
        if (this.isLocked()) {
            this.startPoint.displayObject(g, decalageX, decalageY, minX, minY, scaleX, scaleY);
            this.endPoint.displayObject(g, decalageX, decalageY, minX, minY, scaleX, scaleY);
        }
    }

    public final int sortLeftRight(DEdge edge) {
        DPoint p2;
        DPoint p1 = this.getPointLeft();
        int c = p1.compareTo2D(p2 = edge.getPointLeft());
        if (c == 0) {
            p1 = this.getPointRight();
            p2 = edge.getPointRight();
            c = p1.compareTo2D(p2);
        }
        return c;
    }

    public final void forceTopographicOrientation() {
        double zEnd = this.endPoint.getZ();
        double zStart = this.startPoint.getZ();
        if (zStart < zEnd) {
            this.swap();
        }
    }

    @Override
    public final int compareTo(DEdge edge) {
        return this.sortLeftRight(edge);
    }

    public final int verticalSort(DEdge edge, double abs) throws DelaunayError {
        DPoint pThis = this.getPointFromItsX(abs);
        DPoint pEdge = edge.getPointFromItsX(abs);
        if (pThis == null) {
            throw new DelaunayError("Trying to sort vertical edge, edge : " + this + ", abs : " + abs);
        }
        if (pEdge == null) {
            throw new DelaunayError("Trying to sort vertical edge, edge : " + edge + ", abs : " + abs);
        }
        int c = pThis.compareTo2D(pEdge);
        if (c == 0) {
            if (this.isVertical()) {
                c = this.getPointRight().compareTo2D(edge.getPointRight());
            } else if (edge.isVertical()) {
                c = edge.getPointRight().compareTo2D(this.getPointRight());
            } else {
                double deltaXT = this.getPointRight().getX() - this.getPointLeft().getX();
                double deltaYT = this.getPointRight().getY() - this.getPointLeft().getY();
                double deltaXO = edge.getPointRight().getX() - edge.getPointLeft().getX();
                double cT = deltaYT / deltaXT;
                double deltaYO = edge.getPointRight().getY() - edge.getPointLeft().getY();
                double cO = deltaYO / deltaXO;
                if (-1.0E-7 < cT - cO && cT - cO < 1.0E-7) {
                    c = this.getPointRight().compareTo2D(edge.getPointRight());
                    if (c == 0) {
                        c = this.getPointLeft().compareTo2D(edge.getPointLeft());
                    }
                } else {
                    c = cT < cO ? -1 : 1;
                }
            }
        }
        return c;
    }

    public final int getGradient() {
        int gradient = this.getStartPoint().getZ() > this.getEndPoint().getZ() ? 1 : (this.getStartPoint().getZ() < this.getEndPoint().getZ() ? -1 : 0);
        return gradient;
    }

    public final double getSlopeAspect() {
        Coordinate c1 = this.startPoint.getCoordinate();
        Coordinate c2 = this.endPoint.getCoordinate();
        double circleDegrees = 360.0;
        double angleAxeXrad = c1.z >= c2.z ? Angle.angle((Coordinate)c1, (Coordinate)c2) : Angle.angle((Coordinate)c2, (Coordinate)c1);
        double angleAxeNordrad = 1.5707963267948966 - angleAxeXrad;
        double angleAxeNorddeg = Angle.toDegrees((double)angleAxeNordrad);
        return angleAxeNorddeg < 0.0 ? 360.0 + angleAxeNorddeg : angleAxeNorddeg;
    }

    public final boolean isLeftTriangleGoToEdge() throws DelaunayError {
        if (this.left != null) {
            DPoint p = this.left.getOppositePoint(this);
            if (p.getZ() < this.startPoint.getZ() && p.getZ() < this.endPoint.getZ()) {
                return false;
            }
            return this.left.isTopoOrientedToEdge(this);
        }
        return false;
    }

    public final boolean isRightTriangleGoToEdge() throws DelaunayError {
        if (this.right != null) {
            DPoint p = this.right.getOppositePoint(this);
            if (p.getZ() < this.startPoint.getZ() && p.getZ() < this.endPoint.getZ()) {
                return false;
            }
            return this.right.isTopoOrientedToEdge(this);
        }
        return false;
    }

    public final String toString() {
        return "Edge " + this.getGID() + " [Start : " + this.startPoint + ", End : " + this.endPoint + "]";
    }

    public final void deepSwap() {
        if (this.left != null && this.right != null) {
            DEdge el0 = this.left.getEdge(0);
            DEdge el1 = this.left.getEdge(1);
            DEdge el2 = this.left.getEdge(2);
            LinkedList<DEdge> ll = new LinkedList<DEdge>();
            ll.add(el0);
            ll.add(el1);
            ll.add(el2);
            int gid = this.left.getGID();
            int prop = this.left.getProperty();
            this.left.setEdge(0, this.right.getEdge(0));
            this.left.setEdge(1, this.right.getEdge(1));
            this.left.setEdge(2, this.right.getEdge(2));
            this.left.setGID(this.right.getGID());
            this.left.setProperty(this.right.getProperty());
            LinkedList<DEdge> rl = new LinkedList<DEdge>();
            rl.add(this.right.getEdge(0));
            rl.add(this.right.getEdge(1));
            rl.add(this.right.getEdge(2));
            this.right.setEdge(0, el0);
            this.right.setEdge(1, el1);
            this.right.setEdge(2, el2);
            this.right.setGID(gid);
            this.right.setProperty(prop);
            for (DEdge ed : ll) {
                if (ed == this) continue;
                if (ed.getLeft() == this.left) {
                    ed.setLeft(this.right);
                    continue;
                }
                ed.setRight(this.right);
            }
            for (DEdge ed : rl) {
                if (ed == this) continue;
                if (ed.getLeft() == this.right && ed != this) {
                    ed.setLeft(this.left);
                    continue;
                }
                ed.setRight(this.left);
            }
            DTriangle mem = this.left;
            this.left = this.right;
            this.right = mem;
        }
    }

    public final void forceTriangleSide() {
        DPoint pt;
        if (this.left != null) {
            DPoint pt2 = this.left.getOppositePoint(this);
            if (this.isRight(pt2)) {
                DTriangle dt = this.left;
                this.left = this.right;
                this.right = dt;
            }
        } else if (this.right != null && this.isLeft(pt = this.right.getOppositePoint(this))) {
            DTriangle dt = this.left;
            this.left = this.right;
            this.right = dt;
        }
    }
}

