/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.geometries;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Color;
import java.awt.Graphics;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.BoundaryBox;
import org.jdelaunay.delaunay.geometries.Element;

public class DPoint
extends Element
implements Comparable<DPoint> {
    private static final long serialVersionUID = 1L;
    private Coordinate coord;
    private static final int HASHBASE = 7;
    private static final int HASHMULT = 67;

    private void init(double x, double y, double z) throws DelaunayError {
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
            throw new DelaunayError(300);
        }
        this.coord = new Coordinate(x, y, z);
    }

    public DPoint() throws DelaunayError {
        this.init(0.0, 0.0, 0.0);
    }

    public DPoint(double x, double y, double z) throws DelaunayError {
        this.init(x, y, z);
    }

    public DPoint(DPoint pt) throws DelaunayError {
        super(pt);
        this.init(pt.coord.x, pt.coord.y, pt.coord.z);
    }

    public DPoint(Coordinate coord) throws DelaunayError {
        this.init(coord.x, coord.y, coord.z);
    }

    public final double getX() {
        return this.coord.x;
    }

    public final double getY() {
        return this.coord.y;
    }

    public final double getZ() {
        return this.coord.z;
    }

    public final void setX(double x) {
        this.coord.x = x;
    }

    public final void setY(double y) {
        this.coord.y = y;
    }

    public final void setZ(double z) {
        this.coord.z = z;
    }

    public final Coordinate getCoordinate() {
        return this.coord;
    }

    @Override
    public final BoundaryBox getBoundingBox() {
        BoundaryBox aBox = new BoundaryBox();
        aBox.alterBox(this.coord);
        return aBox;
    }

    @Override
    public final boolean contains(DPoint aPoint) {
        return this.squareDistance(aPoint) < 9.999999999999998E-15;
    }

    @Override
    public final boolean contains(Coordinate c) {
        return this.squareDistance(c.x, c.y, c.z) < 9.999999999999998E-15;
    }

    protected final double squareDistance2D(DPoint aPoint) {
        return this.squareDistance(aPoint.coord.x, aPoint.coord.y);
    }

    protected final double squareDistance2D(double x, double y) {
        return this.squareDistance(x, y);
    }

    public final double squareDistance(DPoint aPoint) {
        return this.squareDistance(aPoint.coord.x, aPoint.coord.y, aPoint.coord.z);
    }

    protected final double squareDistance(double x, double y) {
        return (x - this.coord.x) * (x - this.coord.x) + (y - this.coord.y) * (y - this.coord.y);
    }

    protected final double squareDistance(double x, double y, double z) {
        return (x - this.coord.x) * (x - this.coord.x) + (y - this.coord.y) * (y - this.coord.y) + (z - this.coord.z) * (z - this.coord.z);
    }

    protected final boolean closedTo(DPoint aPoint, double tolerence) {
        return this.squareDistance(aPoint) < tolerence * tolerence;
    }

    public final String toString() {
        return "Point " + this.getGID() + " [" + this.coord.x + " " + this.coord.y + " " + this.coord.z + "]";
    }

    public final boolean equals(Object p) {
        if (p instanceof DPoint) {
            DPoint y = (DPoint)p;
            double dist = (this.getX() - y.getX()) * (this.getX() - y.getX()) + (this.getY() - y.getY()) * (this.getY() - y.getY());
            return (dist += (this.getZ() - y.getZ()) * (this.getZ() - y.getZ())) < 9.999999999999998E-15;
        }
        return false;
    }

    public final int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.coord != null ? this.coord.hashCode() : 0);
        return hash;
    }

    public final boolean equals2D(DPoint y) {
        if (y == null) {
            return false;
        }
        return (this.getX() - y.getX()) * (this.getX() - y.getX()) + (this.getY() - y.getY()) * (this.getY() - y.getY()) < 9.999999999999998E-15;
    }

    public final int compareTo2D(DPoint p) {
        double dx = this.getX() - p.getX();
        if (dx * dx * 2.0 < 9.999999999999998E-15) {
            double dy = this.getY() - p.getY();
            if (dx * dx + dy * dy < 9.999999999999998E-15) {
                return 0;
            }
            if (this.getY() < p.getY()) {
                return -1;
            }
            return 1;
        }
        if (this.getX() < p.getX()) {
            return -1;
        }
        return 1;
    }

    @Override
    public final int compareTo(DPoint p) {
        return this.compareTo2D(p);
    }

    protected final void setColor(Graphics g) {
        g.setColor(Color.black);
    }

    public final void displayObject(Graphics g, int decalageX, int decalageY, double minX, double minY, double scaleX, double scaleY) {
        this.setColor(g);
        g.drawOval((int)((this.coord.x - minX) * scaleX + (double)decalageX) - 1, (int)((this.coord.y - minY) * scaleY + (double)decalageY) - 1, 1, 1);
    }
}

