/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.geometries;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.BoundaryBox;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.geometries.Element;
import org.jdelaunay.delaunay.tools.Tools;

public class DTriangle
extends Element
implements Comparable<DTriangle> {
    private static final long serialVersionUID = 1L;
    public static final int PT_NB = 3;
    private static final int HASHBASE = 5;
    private static final int HASHMULT = 97;
    private DEdge[] edges;
    private double xCenter;
    private double yCenter;
    private double zCenter;
    private double radius;
    private boolean seenForFlatRemoval;
    private boolean processed;

    private void init() {
        this.edges = new DEdge[3];
        this.xCenter = 0.0;
        this.yCenter = 0.0;
        this.zCenter = 0.0;
        this.radius = -1.0;
        this.seenForFlatRemoval = false;
        this.processed = false;
    }

    public DTriangle(DEdge e1, DEdge e2, DEdge e3) throws DelaunayError {
        boolean integrityEptNbE2;
        this.init();
        boolean integrityE1E2 = e1.isExtremity(e2.getStartPoint()) && !e3.isExtremity(e2.getStartPoint()) || e1.isExtremity(e2.getEndPoint()) && !e3.isExtremity(e2.getEndPoint());
        boolean integrityE1EptNb = e1.isExtremity(e3.getStartPoint()) && !e2.isExtremity(e3.getStartPoint()) || e1.isExtremity(e3.getEndPoint()) && !e2.isExtremity(e3.getEndPoint());
        boolean bl = integrityEptNbE2 = e2.isExtremity(e3.getStartPoint()) && !e1.isExtremity(e3.getStartPoint()) || e2.isExtremity(e3.getEndPoint()) && !e1.isExtremity(e3.getEndPoint());
        if (!(integrityE1E2 && integrityE1EptNb && integrityEptNbE2)) {
            throw new DelaunayError("Problem while generating the Triangle : " + integrityE1E2 + " " + integrityE1EptNb + " " + integrityEptNbE2);
        }
        this.edges[0] = e1;
        this.edges[1] = e2;
        this.edges[2] = e3;
        this.connectEdges();
        this.recomputeCenter();
        this.radius = e1.getStartPoint().squareDistance2D(this.xCenter, this.yCenter);
    }

    public DTriangle(DPoint p1, DPoint p2, DPoint p3) throws DelaunayError {
        this.init();
        DEdge e1 = new DEdge(p1, p2);
        DEdge e2 = new DEdge(p2, p3);
        DEdge e3 = new DEdge(p3, p1);
        this.edges[0] = e1;
        this.edges[1] = e2;
        this.edges[2] = e3;
        this.connectEdges();
        this.recomputeCenter();
        this.radius = e1.getStartPoint().squareDistance2D(this.xCenter, this.yCenter);
    }

    public DTriangle(DTriangle aTriangle) {
        super(aTriangle);
        this.init();
        System.arraycopy(aTriangle.edges, 0, this.edges, 0, 3);
        this.xCenter = aTriangle.xCenter;
        this.yCenter = aTriangle.yCenter;
        this.radius = aTriangle.radius;
    }

    public final List<DPoint> getPoints() {
        ArrayList<DPoint> ret = new ArrayList<DPoint>();
        ret.add(this.edges[0].getStartPoint());
        ret.add(this.edges[0].getEndPoint());
        ret.add(this.getPoint(2));
        return ret;
    }

    public final DPoint getPoint(int i) {
        DPoint p = null;
        if (i == 0) {
            p = this.edges[0].getStartPoint();
        } else if (i == 1) {
            p = this.edges[0].getEndPoint();
        } else if (i == 2 && ((p = this.edges[1].getStartPoint()).equals(this.edges[0].getStartPoint()) || p.equals(this.edges[0].getEndPoint()))) {
            p = this.edges[1].getEndPoint();
        }
        return p;
    }

    public final DEdge getEdge(int i) {
        if (0 <= i && i <= 2) {
            return this.edges[i];
        }
        return null;
    }

    public final DEdge[] getEdges() {
        DEdge[] ret = new DEdge[3];
        System.arraycopy(this.edges, 0, ret, 0, 3);
        return ret;
    }

    public final int getEdgeIndex(DEdge ed) {
        for (int i = 0; i < 3; ++i) {
            if (!this.edges[i].equals(ed)) continue;
            return i;
        }
        return -1;
    }

    public final boolean setEdge(int i, DEdge anEdge) {
        if (0 <= i && i <= 2) {
            this.edges[i] = anEdge;
            return true;
        }
        return false;
    }

    public final double getRadius() {
        return Math.sqrt(this.radius);
    }

    public final Coordinate getCircumCenter() {
        return new Coordinate(this.xCenter, this.yCenter, this.zCenter);
    }

    public final boolean isSeenForFlatRemoval() {
        return this.seenForFlatRemoval;
    }

    public final void setSeenForFlatRemoval(boolean seenForFlatRemoval) {
        this.seenForFlatRemoval = seenForFlatRemoval;
    }

    public final boolean isProcessed() {
        return this.processed;
    }

    public final void setProcessed(boolean pro) {
        this.processed = pro;
    }

    @Override
    public final BoundaryBox getBoundingBox() {
        BoundaryBox aBox = new BoundaryBox();
        DPoint p1 = this.edges[0].getStartPoint();
        DPoint p2 = this.edges[0].getEndPoint();
        DPoint pptNb = this.edges[1].getStartPoint();
        if (pptNb.equals(p1) || pptNb.equals(p2)) {
            pptNb = this.edges[1].getEndPoint();
        }
        aBox.alterBox(p1);
        aBox.alterBox(p2);
        aBox.alterBox(pptNb);
        return aBox;
    }

    public final DPoint getLeftMost() {
        DPoint p2;
        DPoint p1 = this.edges[0].getPointLeft();
        return p1.compareTo(p2 = this.edges[1].getPointLeft()) < 1 ? p1 : p2;
    }

    public final DEdge getLastEdge(DEdge e1, DEdge e2) {
        if (e1.equals(this.edges[0])) {
            if (e2.equals(this.edges[1])) {
                return this.edges[2];
            }
            if (e2.equals(this.edges[2])) {
                return this.edges[1];
            }
        } else if (e1.equals(this.edges[1])) {
            if (e2.equals(this.edges[0])) {
                return this.edges[2];
            }
            if (e2.equals(this.edges[2])) {
                return this.edges[0];
            }
        } else if (e1.equals(this.edges[2])) {
            if (e2.equals(this.edges[0])) {
                return this.edges[1];
            }
            if (e2.equals(this.edges[1])) {
                return this.edges[0];
            }
        }
        return null;
    }

    @Override
    public final boolean contains(DPoint aPoint) {
        return this.isInside(aPoint);
    }

    @Override
    public final boolean contains(Coordinate c) throws DelaunayError {
        return this.isInside(new DPoint(c));
    }

    public final boolean isOnAnEdge(DPoint pt) {
        for (int i = 0; i < 3; ++i) {
            if (!this.edges[i].contains(pt)) continue;
            return true;
        }
        return false;
    }

    public final void recomputeCenter() throws DelaunayError {
        DPoint p1 = this.edges[0].getStartPoint();
        DPoint p2 = this.edges[0].getEndPoint();
        DPoint pptNb = this.edges[1].getStartPoint();
        if (pptNb.equals(p1) || pptNb.equals(p2)) {
            pptNb = this.edges[1].getEndPoint();
        }
        double p1Sq = p1.getX() * p1.getX() + p1.getY() * p1.getY();
        double p2Sq = p2.getX() * p2.getX() + p2.getY() * p2.getY();
        double pptNbSq = pptNb.getX() * pptNb.getX() + pptNb.getY() * pptNb.getY();
        double ux = p2.getX() - p1.getX();
        double uy = p2.getY() - p1.getY();
        double vx = pptNb.getX() - p1.getX();
        double vy = pptNb.getY() - p1.getY();
        double cp = ux * vy - uy * vx;
        if (cp != 0.0) {
            double cx = (p1Sq * (p2.getY() - pptNb.getY()) + p2Sq * (pptNb.getY() - p1.getY()) + pptNbSq * (p1.getY() - p2.getY())) / (2.0 * cp);
            double cy = (p1Sq * (pptNb.getX() - p2.getX()) + p2Sq * (p1.getX() - pptNb.getX()) + pptNbSq * (p2.getX() - p1.getX())) / (2.0 * cp);
            this.xCenter = cx;
            this.yCenter = cy;
            this.zCenter = this.interpolateZ(new DPoint(cx, cy, 0.0));
            this.radius = p1.squareDistance2D(this.xCenter, this.yCenter);
        } else {
            this.xCenter = 0.0;
            this.yCenter = 0.0;
            this.radius = -1.0;
        }
    }

    private void connectEdges() {
        for (int i = 0; i < 3; ++i) {
            DPoint aPoint = this.getOppositePoint(this.edges[i]);
            if (this.edges[i].isLeft(aPoint)) {
                this.edges[i].setLeft(this);
                continue;
            }
            this.edges[i].setRight(this);
        }
    }

    public final int inCircle(DPoint aPoint) {
        double uy;
        int returnedValue = 0;
        double ux = aPoint.getX() - this.xCenter;
        double distance = ux * ux + (uy = aPoint.getY() - this.yCenter) * uy;
        if (distance < this.radius - 9.999999999999998E-15) {
            returnedValue = 1;
        } else if (distance < this.radius + 9.999999999999998E-15) {
            returnedValue = 2;
        }
        return returnedValue;
    }

    public final boolean isInside(DPoint aPoint) {
        boolean isInside = true;
        for (int k = 0; k < 3 && isInside; ++k) {
            DEdge theEdge = this.edges[k];
            if (theEdge.getLeft() == this) {
                if (!theEdge.isRight(aPoint)) continue;
                isInside = false;
                continue;
            }
            if (!theEdge.isLeft(aPoint)) continue;
            isInside = false;
        }
        return isInside;
    }

    public final double interpolateZ(DPoint aPoint) {
        double zValue = 0.0;
        DPoint p1 = this.edges[0].getStartPoint();
        DPoint p2 = this.edges[0].getEndPoint();
        DPoint p3 = this.edges[1].getStartPoint();
        if (p3.equals(p1) || p3.equals(p2)) {
            p3 = this.edges[1].getEndPoint();
        }
        double ux = p2.getX() - p1.getX();
        double uy = p2.getY() - p1.getY();
        double uz = p2.getZ() - p1.getZ();
        double vx = p3.getX() - p1.getX();
        double vy = p3.getY() - p1.getY();
        double vz = p3.getZ() - p1.getZ();
        double a = uy * vz - uz * vy;
        double b = uz * vx - ux * vz;
        double c = ux * vy - uy * vx;
        double d = -a * p1.getX() - b * p1.getY() - c * p1.getZ();
        if (Math.abs(c) > 1.0E-7) {
            zValue = (-a * aPoint.getX() - b * aPoint.getY() - d) / c;
        }
        return zValue;
    }

    public final double softInterpolateZ(DPoint aPoint) {
        double weight = 3.0;
        double zValue = this.interpolateZ(aPoint) * weight;
        for (int i = 0; i < 3; ++i) {
            DEdge anEdge = this.edges[i];
            DTriangle aTriangle = null;
            if (anEdge != null) {
                aTriangle = anEdge.getLeft() == this ? anEdge.getRight() : anEdge.getLeft();
            }
            if (aTriangle == null) continue;
            weight += 1.0;
            zValue += aTriangle.interpolateZ(aPoint);
        }
        return zValue /= weight;
    }

    public final double getArea() {
        double area;
        DPoint p1 = this.edges[0].getStartPoint();
        DPoint p2 = this.edges[0].getEndPoint();
        DPoint pptNb = this.edges[1].getStartPoint();
        if (pptNb.equals(p1) || pptNb.equals(p2)) {
            pptNb = this.edges[1].getEndPoint();
        }
        return (area = ((pptNb.getX() - p1.getX()) * (p2.getY() - p1.getY()) - (p2.getX() - p1.getX()) * (pptNb.getY() - p1.getY())) / 2.0) < 0.0 ? -area : area;
    }

    public final DPoint getNormalVector() throws DelaunayError {
        double dx1 = this.edges[0].getStartPoint().getX() - this.edges[0].getEndPoint().getX();
        double dy1 = this.edges[0].getStartPoint().getY() - this.edges[0].getEndPoint().getY();
        double dz1 = this.edges[0].getStartPoint().getZ() - this.edges[0].getEndPoint().getZ();
        double dx2 = this.edges[1].getStartPoint().getX() - this.edges[1].getEndPoint().getX();
        double dy2 = this.edges[1].getStartPoint().getY() - this.edges[1].getEndPoint().getY();
        double dz2 = this.edges[1].getStartPoint().getZ() - this.edges[1].getEndPoint().getZ();
        DPoint vec = new DPoint(dy1 * dz2 - dz1 * dy2, dz1 * dx2 - dx1 * dz2, dx1 * dy2 - dy1 * dx2);
        double length = Math.sqrt(vec.squareDistance(new DPoint(0.0, 0.0, 0.0)));
        vec.setX(vec.getX() / length);
        vec.setY(vec.getY() / length);
        vec.setZ(vec.getZ() / length);
        return vec;
    }

    public final DPoint getSteepestVector() throws DelaunayError {
        double length;
        DPoint normal = this.getNormalVector();
        if (Math.abs(normal.getX()) < 1.0E-7 && Math.abs(normal.getY()) < 1.0E-7) {
            return new DPoint(0.0, 0.0, 0.0);
        }
        DPoint pente = Math.abs(normal.getX()) < 1.0E-7 ? new DPoint(0.0, 1.0, -normal.getY() / normal.getZ()) : (Math.abs(normal.getY()) < 1.0E-7 ? new DPoint(1.0, 0.0, -normal.getX() / normal.getZ()) : new DPoint(normal.getX() / normal.getY(), 1.0, -1.0 / normal.getZ() * (normal.getX() * normal.getX() / normal.getY() + normal.getY())));
        if (pente.getZ() > 1.0E-7) {
            pente.setX(-pente.getX());
            pente.setY(-pente.getY());
            pente.setZ(-pente.getZ());
        }
        if ((length = Math.sqrt(pente.squareDistance(new DPoint(0.0, 0.0, 0.0)))) > 1.0E-7) {
            pente.setX(pente.getX() / length);
            pente.setY(pente.getY() / length);
            pente.setZ(pente.getZ() / length);
        }
        return pente;
    }

    public final double getSlope() throws DelaunayError {
        DPoint steep = this.getSteepestVector();
        DEdge ed = new DEdge(new DPoint(0.0, 0.0, 0.0), steep);
        return ed.getSlope();
    }

    public final double getSlopeInDegree() throws DelaunayError {
        DPoint steep = this.getSteepestVector();
        DEdge ed = new DEdge(new DPoint(0.0, 0.0, 0.0), steep);
        return ed.getSlopeInDegree();
    }

    public final double getMinAngle() {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 3; ++i) {
            double cur = this.getAngle(i);
            min = cur < min ? cur : min;
        }
        return min;
    }

    public final double getMaxAngle() {
        double maxAngle = 0.0;
        for (int k = 0; k < 3; ++k) {
            double angle = this.getAngle(k);
            if (!(angle > maxAngle)) continue;
            maxAngle = angle;
        }
        return maxAngle;
    }

    public final boolean checkTopology() {
        boolean correct = true;
        for (int i = 0; i < 3; ++i) {
            if (this.edges[i].getLeft() == this || this.edges[i].getRight() == this) continue;
            return false;
        }
        for (int l = 0; l < 3; ++l) {
            DPoint pt = this.getPoint(l);
            if (this.sharedByTwoEdge(pt)) continue;
            return false;
        }
        return correct;
    }

    public final boolean sharedByTwoEdge(DPoint pt) {
        if (this.edges[0].isExtremity(pt)) {
            return this.edges[1].isExtremity(pt) && !this.edges[2].isExtremity(pt) || !this.edges[1].isExtremity(pt) && this.edges[2].isExtremity(pt);
        }
        return this.edges[1].isExtremity(pt) && this.edges[2].isExtremity(pt);
    }

    public final boolean isFlatSlope() {
        boolean isFlat = true;
        int i = 0;
        while (i < 3 && isFlat) {
            if (!this.edges[i].isFlatSlope()) {
                isFlat = false;
                continue;
            }
            ++i;
        }
        return isFlat;
    }

    public final DPoint getOppositePoint(DEdge ed) {
        DPoint start = ed.getStartPoint();
        DPoint end = ed.getEndPoint();
        return this.getAlterPoint(start, end);
    }

    public final DEdge getOppositeEdge(DPoint pt) {
        if (!this.belongsTo(pt)) {
            return null;
        }
        if (!this.edges[0].contains(pt)) {
            return this.edges[0];
        }
        if (!this.edges[1].contains(pt)) {
            return this.edges[1];
        }
        return this.edges[2];
    }

    public final DPoint getAlterPoint(DPoint p1, DPoint p2) {
        DPoint t1 = this.getPoint(0);
        DPoint t2 = this.getPoint(1);
        DPoint t3 = this.getPoint(2);
        if (p1.equals(t1)) {
            if (p2.equals(t2)) {
                return t3;
            }
            if (p2.equals(t3)) {
                return t2;
            }
        } else if (p1.equals(t2)) {
            if (p2.equals(t1)) {
                return t3;
            }
            if (p2.equals(t3)) {
                return t1;
            }
        } else if (p1.equals(t3)) {
            if (p2.equals(t1)) {
                return t2;
            }
            if (p2.equals(t2)) {
                return t1;
            }
        }
        return null;
    }

    protected final DEdge getEdgeFromPoints(DPoint p1, DPoint p2) {
        DEdge alterEdge = null;
        int i = 0;
        while (i < 3 && alterEdge == null) {
            DEdge testEdge = this.edges[i];
            DPoint test1 = testEdge.getStartPoint();
            DPoint test2 = testEdge.getEndPoint();
            if (test1.equals(p1) && test2.equals(p2)) {
                alterEdge = testEdge;
                continue;
            }
            if (test1.equals(p2) && test2.equals(p1)) {
                alterEdge = testEdge;
                continue;
            }
            ++i;
        }
        return alterEdge;
    }

    public final boolean belongsTo(DPoint aPoint) {
        boolean belongs = false;
        DEdge anEdge = this.getEdge(0);
        if (anEdge.getStartPoint().equals(aPoint)) {
            belongs = true;
        } else if (anEdge.getEndPoint().equals(aPoint)) {
            belongs = true;
        } else {
            anEdge = this.getEdge(1);
            if (anEdge.getStartPoint().equals(aPoint)) {
                belongs = true;
            } else if (anEdge.getEndPoint().equals(aPoint)) {
                belongs = true;
            }
        }
        return belongs;
    }

    public final DPoint getBarycenter() throws DelaunayError {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int i = 0; i < 3; ++i) {
            DPoint aPoint = this.getPoint(i);
            x += aPoint.getX();
            y += aPoint.getY();
            z += aPoint.getZ();
        }
        return new DPoint(x /= 3.0, y /= 3.0, z /= 3.0);
    }

    public final String toString() {
        return "Triangle " + this.getGID() + ": [" + this.getPoint(0).toString() + ", " + this.getPoint(1).toString() + ", " + this.getPoint(2).toString() + "]";
    }

    private void setColor(Graphics g) {
        if (this.getProperty() > 0) {
            g.setColor(new Color(this.getProperty()));
        } else if (this.isFlatSlope()) {
            g.setColor(Color.green);
        } else {
            g.setColor(Color.yellow);
        }
    }

    public final void displayObject(Graphics g, int decalageX, int decalageY, double minX, double minY, double scaleX, double scaleY) {
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        DPoint p1 = this.getPoint(0);
        DPoint p2 = this.getPoint(1);
        DPoint pptNb = this.getPoint(2);
        xPoints[0] = (int)((p1.getX() - minX) * scaleX + (double)decalageX);
        xPoints[1] = (int)((p2.getX() - minX) * scaleX + (double)decalageX);
        xPoints[2] = (int)((pptNb.getX() - minX) * scaleX + (double)decalageX);
        yPoints[0] = (int)((p1.getY() - minY) * scaleY + (double)decalageY);
        yPoints[1] = (int)((p2.getY() - minY) * scaleY + (double)decalageY);
        yPoints[2] = (int)((pptNb.getY() - minY) * scaleY + (double)decalageY);
        this.setColor(g);
        g.fillPolygon(xPoints, yPoints, 3);
        for (int i = 0; i < 3; ++i) {
            this.edges[i].displayObject(g, decalageX, decalageY, minX, minY, scaleX, scaleY);
        }
    }

    protected final void displayObjectCircles(Graphics g, int decalageX, int decalageY) {
        double r = Math.sqrt(this.radius);
        g.setColor(Color.red);
        g.drawOval((int)this.xCenter + decalageX, decalageY - (int)this.yCenter, 1, 1);
        g.drawOval((int)(this.xCenter - r) + decalageX, decalageY - (int)(this.yCenter + r), (int)r * 2, (int)r * 2);
    }

    public final boolean equals(Object other) {
        if (other instanceof DTriangle) {
            DTriangle otherTri = (DTriangle)other;
            boolean ret = this.belongsTo(otherTri.getPoint(0)) && this.belongsTo(otherTri.getPoint(1)) && this.belongsTo(otherTri.getPoint(2));
            return ret;
        }
        return false;
    }

    public final int hashCode() {
        int hash = 5;
        hash = 97 * hash + Arrays.deepHashCode(this.edges);
        return hash;
    }

    @Override
    public final int compareTo(DTriangle t) {
        Coordinate midO;
        Coordinate midT = this.getBoundingBox().getMiddle();
        int c = midT.compareTo((Object)(midO = t.getBoundingBox().getMiddle()));
        if (c == 0) {
            try {
                c = this.getBarycenter().compareTo(t.getBarycenter());
            }
            catch (DelaunayError ex) {
                Logger.getLogger(DTriangle.class.getName()).log(Level.WARNING, null, ex);
            }
        }
        return c;
    }

    public final double getAngle(int k) {
        int k1 = (k + 1) % 3;
        int k2 = (k1 + 1) % 3;
        double degreesPI = 180.0;
        DPoint p1 = this.getPoint(k);
        DPoint p2 = this.getPoint(k1);
        DPoint pptNb = this.getPoint(k2);
        double ux = p2.getX() - p1.getX();
        double uy = p2.getY() - p1.getY();
        double vx = pptNb.getX() - p1.getX();
        double vy = pptNb.getY() - p1.getY();
        double dp = ux * vx + uy * vy;
        return Math.acos(Math.sqrt(dp * dp / ((ux * ux + uy * uy) * (vx * vx + vy * vy)))) * 57.29577951308232;
    }

    public final double getSlopeInPercent() throws DelaunayError {
        return Math.abs(this.getSlope()) * 100.0;
    }

    public final double getSlopeAspect() throws DelaunayError {
        double angleAxeXrad;
        double angleAxeNordrad;
        double angleAxeNorddeg;
        Coordinate c1 = new Coordinate(0.0, 0.0, 0.0);
        Coordinate c2 = this.getSteepestVector().getCoordinate();
        if (c2.z > 0.0) {
            c2.setCoordinate(new Coordinate(-c2.x, -c2.y, -c2.z));
        }
        double orientationPente = (angleAxeNorddeg = Angle.toDegrees((double)(angleAxeNordrad = 1.5707963267948966 - (angleAxeXrad = Angle.angle((Coordinate)c1, (Coordinate)c2))))) < 0.0 ? 360.0 + angleAxeNorddeg : angleAxeNorddeg;
        return orientationPente;
    }

    public final boolean isTopoOrientedToEdge(DEdge ed) throws DelaunayError {
        DPoint p;
        DPoint ac;
        boolean res = false;
        DPoint a = ed.getStartPoint();
        DPoint b = ed.getEndPoint();
        if (!this.belongsTo(a) || !this.belongsTo(b)) {
            throw new DelaunayError(202);
        }
        DPoint c = this.getOppositePoint(ed);
        DPoint ab = Tools.vectorialDiff(b, a);
        if (Tools.vectorProduct(ab, ac = Tools.vectorialDiff(c, a)).getZ() < 0.0) {
            DPoint d = a;
            a = b;
            b = d;
            ab = Tools.vectorialDiff(b, a);
        }
        res = Tools.vectorProduct(ab, p = this.getSteepestVector()).getZ() < 0.0;
        return res;
    }

    public final DPoint getSteepestIntersectionPoint(DPoint dPoint) throws DelaunayError {
        if (this.isInside(dPoint)) {
            for (DEdge dEdge : this.edges) {
                DPoint pt;
                if (!this.isTopoOrientedToEdge(dEdge) || !dEdge.contains(pt = Tools.computeIntersection(dEdge.getStartPoint(), dEdge.getDirectionVector(), dPoint, this.getSteepestVector()))) continue;
                return pt;
            }
        }
        return null;
    }

    public final DPoint getCounterSteepestIntersection(DPoint dp) throws DelaunayError {
        if (this.isInside(dp) || this.isOnAnEdge(dp)) {
            for (DEdge ed : this.edges) {
                if (this.isTopoOrientedToEdge(ed)) continue;
                DPoint counterSteep = this.getSteepestVector();
                counterSteep.setX(-counterSteep.getX());
                counterSteep.setY(-counterSteep.getY());
                counterSteep.setZ(-counterSteep.getZ());
                DPoint pt = Tools.computeIntersection(ed.getStartPoint(), ed.getDirectionVector(), dp, counterSteep);
                if (!ed.contains(pt)) continue;
                return pt;
            }
        }
        return null;
    }

    public final Element getCircumCenterContainer() throws DelaunayError {
        DPoint cc = new DPoint(this.getCircumCenter());
        return this.searchPointContainer(cc);
    }

    public final Element getCircumCenterContainerSafe() throws DelaunayError {
        DPoint cc = new DPoint(this.getCircumCenter());
        return this.searchPointImpl(cc, true);
    }

    public final Element searchPointContainer(DPoint pt) throws DelaunayError {
        return this.searchPointImpl(pt, false);
    }

    private Element searchPointImpl(DPoint pt, boolean safe) throws DelaunayError {
        DEdge ret = null;
        if (this.contains(pt)) {
            return this;
        }
        for (DEdge ed : this.edges) {
            DPoint op = this.getOppositePoint(ed);
            if (ed.isRight(pt) && ed.isLeft(op)) {
                if (ed.isLocked() && safe) {
                    return null;
                }
                if (ed.getRight() != null) {
                    return ed.getRight().searchPointContainer(pt);
                }
                ret = ed;
                continue;
            }
            if (!ed.isLeft(pt) || !ed.isRight(op)) continue;
            if (ed.isLocked() && safe) {
                return null;
            }
            if (ed.getLeft() != null) {
                return ed.getLeft().searchPointContainer(pt);
            }
            ret = ed;
        }
        return ret;
    }

    public final DEdge getContainingEdge(DPoint pt) {
        if (this.isOnAnEdge(pt)) {
            for (DEdge edge : this.edges) {
                if (!edge.contains(pt)) continue;
                return edge;
            }
        }
        return null;
    }

    public final boolean isEdgeOf(DEdge ed) {
        for (DEdge e : this.edges) {
            if (!e.equals(ed)) continue;
            return true;
        }
        return false;
    }

    public final double getMinSquareDistance(DPoint pt) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 3; ++i) {
            double dist = pt.squareDistance(this.getPoint(i));
            min = dist < min ? dist : min;
        }
        return min;
    }

    public final boolean isCloser(DPoint pt, double threshold) {
        double min = this.getMinSquareDistance(pt);
        return min < threshold * threshold;
    }

    public final void forceCoherenceWithEdges() {
        for (DEdge edg : this.edges) {
            DTriangle tri = edg.getLeft();
            DTriangle tri2 = edg.getRight();
            if (this.equals(tri)) {
                edg.setLeft(this);
                continue;
            }
            if (this.equals(tri2)) {
                edg.setRight(this);
                continue;
            }
            DPoint op = this.getOppositePoint(edg);
            if (op == null) continue;
            if (edg.isLeft(op)) {
                edg.setLeft(this);
                continue;
            }
            edg.setRight(this);
        }
    }
}

