/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.geometries;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.BoundaryBox;
import org.jdelaunay.delaunay.geometries.DPoint;

public abstract class Element {
    private static final long serialVersionUID = 5437683478248244942L;
    public static final List<Integer> WEIGHTED_PROPERTIES = new ArrayList<Integer>();
    private int gid;
    private int property;
    private int externalGID;
    private double height;

    private void init() {
        this.gid = -1;
        this.property = 0;
        this.externalGID = -1;
        this.height = 0.0;
    }

    public Element() {
        this.init();
    }

    public Element(Element element) {
        this.init();
        this.property = element.property;
    }

    public Element(int property) {
        this.init();
        this.property = property;
    }

    public final void setGID(int gid) {
        this.gid = gid;
    }

    public final int getGID() {
        return this.gid;
    }

    public final void setProperty(int property) {
        this.property = property;
    }

    public void addProperty(int property) {
        this.property |= property;
    }

    public final boolean hasProperty(int property) {
        return (this.property & property) != 0;
    }

    public final int getProperty() {
        return this.property;
    }

    public final void removeProperties() {
        this.property = 0;
    }

    public final int getMaxWeight(Map<Integer, Integer> map) {
        int weight = -1;
        for (Integer i : WEIGHTED_PROPERTIES) {
            if (!this.hasProperty(i) || !map.containsKey(i)) continue;
            weight = weight < map.get(i) ? map.get(i) : weight;
        }
        return weight;
    }

    public final void setExternalGID(int externalGID) {
        this.externalGID = externalGID;
    }

    public final int getExternalGID() {
        return this.externalGID;
    }

    public final double getHeight() {
        return this.height;
    }

    public final void setHeight(double height) {
        this.height = height;
    }

    public abstract BoundaryBox getBoundingBox();

    public abstract boolean contains(DPoint var1);

    public abstract boolean contains(Coordinate var1) throws DelaunayError;
}

