/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay.tools;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.geometries.Element;

public final class Tools {
    public static final double EPSILON = 1.0E-7;
    public static final double EPSILON2 = 9.999999999999998E-15;
    public static final int BIT_OUTSIDE = 1;
    public static final int BIT_LOCKED = 2;
    public static final int BIT_LEVEL = 3;
    public static final int BIT_POLYGON = 4;
    public static final int BIT_ZUSED = 5;
    public static final int BIT_MARKED = 6;

    private Tools() {
    }

    public static <T extends Element> int addToSortedList(T elt, List<T> sortedList, Comparator<T> comp) {
        int index = Collections.binarySearch(sortedList, elt, comp);
        if (index < 0) {
            int insertPos = -index - 1;
            sortedList.add(insertPos, elt);
        }
        return index;
    }

    public static <T extends Element> int sortedListContains(List<T> sortedList, T elt, Comparator<T> comp) {
        int index = Collections.binarySearch(sortedList, elt, comp);
        return index;
    }

    public static DPoint vectorProduct(DPoint v1, DPoint v2) throws DelaunayError {
        DPoint v3 = new DPoint(0.0, 0.0, 0.0);
        v3.setX(v1.getY() * v2.getZ() - v1.getZ() * v2.getY());
        v3.setY(v1.getZ() * v2.getX() - v1.getX() * v2.getZ());
        v3.setZ(v1.getX() * v2.getY() - v1.getY() * v2.getX());
        return v3;
    }

    public static boolean isColinear(DPoint v1, DPoint v2) {
        double res = 0.0;
        res += Math.abs(v1.getY() * v2.getZ() - v1.getZ() * v2.getY());
        res += Math.abs(v1.getZ() * v2.getX() - v1.getX() * v2.getZ());
        return (res += Math.abs(v1.getX() * v2.getY() - v1.getY() * v2.getX())) < 1.0E-7;
    }

    public static DPoint vectorialDiff(DPoint v1, DPoint v2) throws DelaunayError {
        DPoint v3 = new DPoint(0.0, 0.0, 0.0);
        v3.setX(v1.getX() - v2.getX());
        v3.setY(v1.getY() - v2.getY());
        v3.setZ(v1.getZ() - v2.getZ());
        return v3;
    }

    public static DPoint computeIntersection(DPoint p1, DPoint v1, DPoint p2, DPoint v2) throws DelaunayError {
        DPoint i = null;
        double delta = v1.getX() * -v2.getY() - -v1.getY() * v2.getX();
        if (delta != 0.0) {
            double k = ((p2.getX() - p1.getX()) * -v2.getY() - (p2.getY() - p1.getY()) * -v2.getX()) / delta;
            i = new DPoint();
            i.setX(p1.getX() + k * v1.getX());
            i.setY(p1.getY() + k * v1.getY());
            i.setZ(p1.getZ() + k * v1.getZ());
        }
        return i;
    }

    public static boolean isVerticallySorted(List<DEdge> edgeList, double abs) throws DelaunayError {
        DEdge e2 = edgeList.get(0);
        for (int i = 1; i < edgeList.size(); ++i) {
            DEdge e1 = e2;
            if (e1.verticalSort(e2 = edgeList.get(i), abs) != 1) continue;
            return false;
        }
        return true;
    }
}

