/*
 * OrbisGIS is a GIS application dedicated to scientific spatial simulation.
 * This cross-platform GIS is developed at French IRSTV institute and is able to
 * manipulate and create vector and raster spatial information. 
 * 
 * OrbisGIS is distributed under GPL 3 license. It is produced by the "Atelier SIG"
 * team of the IRSTV Institute <http://www.irstv.fr/> CNRS FR 2488.
 * 
 * Copyright (C) 2007-2014 IRSTV (FR CNRS 2488)
 * 
 * This file is part of OrbisGIS.
 * 
 * OrbisGIS is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * OrbisGIS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * OrbisGIS. If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information, please consult: <http://www.orbisgis.org/>
 * or contact directly:
 * info_at_ orbisgis.org
 */
package org.orbisgis.legend.structure.fill.constant;

import java.awt.Color;
import org.orbisgis.coremap.renderer.se.fill.SolidFill;

/**
 * {@link SolidFill} fields that are set to null can be considered as constant
 * in some situation. Indeed, they are "simple", are not linked to an analysis
 * and always produce the same result, whatever the input feature.
 *
 * @author Alexis Guéganno
 */
public class NullSolidFillLegend implements ConstantSolidFill {

        @Override
        public SolidFill getFill() {
                return null;
        }

        @Override
        public Color getColor() {
                return null;
        }

        @Override
        public void setColor(Color col) {
        }

        @Override
        public double getOpacity() {
                return 0;
        }

        @Override
        public void setOpacity(double d) {
        }
}
