/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor;

import java.util.ArrayList;
import java.util.List;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.coremap.renderer.ResultSetProviderFactory;
import org.orbisgis.mapeditor.map.MapEditor;
import org.orbisgis.mapeditor.map.ext.MapEditorAction;
import org.orbisgis.mapeditor.map.ext.MapEditorExtension;
import org.orbisgis.view.components.actions.ActionsHolder;
import org.orbisgis.view.components.actions.MenuItemServiceTracker;
import org.orbisgis.viewapi.edition.EditorDockable;
import org.orbisgis.viewapi.edition.EditorFactory;
import org.orbisgis.viewapi.edition.EditorManager;
import org.orbisgis.viewapi.edition.SingleEditorFactory;
import org.orbisgis.viewapi.main.frames.ext.ToolBarAction;
import org.orbisgis.viewapi.workspace.ViewWorkspace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={EditorFactory.class}, immediate=true)
public class MapEditorFactory
implements SingleEditorFactory {
    public static final String FACTORY_ID = "MapFactory";
    private MapEditor mapPanel = null;
    private ServiceRegistration<ToolBarAction> drawingToolbarService;
    private MenuItemServiceTracker<MapEditorExtension, MapEditorAction> mapEditorExt;
    private BundleContext hostBundle;
    private DataManager dataManager;
    private ViewWorkspace viewWorkspace;
    private EditorManager editorManager;
    private List<ResultSetProviderFactory> rsFactories = new ArrayList<ResultSetProviderFactory>();

    @Reference
    public void setEditorManager(EditorManager editorManager) {
        this.editorManager = editorManager;
    }

    public void unsetEditorManager(EditorManager editorManager) {
        this.dispose();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void addResultSetProviderFactory(ResultSetProviderFactory resultSetProviderFactory) {
        this.rsFactories.add(resultSetProviderFactory);
        if (this.mapPanel != null) {
            this.mapPanel.addResultSetProviderFactory(resultSetProviderFactory);
        }
    }

    public void removeResultSetProviderFactory(ResultSetProviderFactory resultSetProviderFactory) {
        this.rsFactories.remove(resultSetProviderFactory);
        if (this.mapPanel != null) {
            this.mapPanel.removeResultSetProviderFactory(resultSetProviderFactory);
        }
    }

    @Reference
    public void setDataManager(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    public void unsetDataManager(DataManager dataManager) {
        this.dispose();
    }

    @Activate
    public void Activate(BundleContext bundleContext) {
        this.hostBundle = bundleContext;
    }

    @Reference
    public void setViewWorkspace(ViewWorkspace viewWorkspace) {
        this.viewWorkspace = viewWorkspace;
    }

    public void unsetViewWorkspace(ViewWorkspace viewWorkspace) {
        this.dispose();
    }

    public void dispose() {
        if (this.drawingToolbarService != null) {
            this.drawingToolbarService.unregister();
        }
        if (this.mapEditorExt != null) {
            this.mapEditorExt.close();
        }
        if (this.mapPanel != null) {
            this.mapPanel.dispose();
        }
    }

    public EditorDockable[] getSinglePanels() {
        if (this.mapPanel == null) {
            this.mapPanel = new MapEditor(this.viewWorkspace, this.dataManager, this.editorManager);
            for (ResultSetProviderFactory rsF : this.rsFactories) {
                this.mapPanel.addResultSetProviderFactory(rsF);
            }
            this.mapEditorExt = new MenuItemServiceTracker(this.hostBundle, MapEditorAction.class, (ActionsHolder)this.mapPanel.getActionCommands(), (Object)this.mapPanel);
            this.mapEditorExt.open();
        }
        return new EditorDockable[]{this.mapPanel};
    }

    public String getId() {
        return FACTORY_ID;
    }
}

