/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map;

import com.vividsolutions.jts.geom.Envelope;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SpatialResultSet;
import org.h2gis.utilities.TableLocation;
import org.orbisgis.corejdbc.MetaData;
import org.orbisgis.corejdbc.ReadRowSet;
import org.orbisgis.coremap.layerModel.ILayer;
import org.orbisgis.coremap.renderer.DefaultResultSetProviderFactory;
import org.orbisgis.coremap.renderer.ResultSetProviderFactory;
import org.orbisgis.progress.ProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CachedResultSetContainer
implements ResultSetProviderFactory {
    private final Map<String, ReadRowSet> cache = new HashMap<String, ReadRowSet>();
    private static final int LOCK_TIMEOUT = 10;
    private static final int FETCH_SIZE = 50;
    private static I18n I18N = I18nFactory.getI18n(CachedResultSetContainer.class);
    private static Logger LOGGER = LoggerFactory.getLogger(CachedResultSetContainer.class);
    private static final int ROWSET_FREE_DELAY = 60000;
    private static final long WAIT_FOR_INITIALISATION_TIMEOUT = 10000L;
    private static final double RATIONAL_USAGE_INDEX = 0.2;
    private final ReentrantLock lock = new ReentrantLock();
    private ResultSetProviderFactory defaultFactory = new DefaultResultSetProviderFactory();

    public String getName() {
        return "Local index";
    }

    public ResultSetProviderFactory.ResultSetProvider getResultSetProvider(ILayer layer, ProgressMonitor pm) throws SQLException {
        try {
            if (this.lock.tryLock(10000L, TimeUnit.MILLISECONDS)) {
                String tableRef;
                boolean isH2;
                String integerPK = "";
                try (Connection connection = layer.getDataManager().getDataSource().getConnection();){
                    isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
                    tableRef = TableLocation.parse((String)layer.getTableReference(), (Boolean)isH2).toString(isH2);
                    integerPK = MetaData.getPkName((Connection)connection, (String)tableRef, (boolean)false);
                }
                if (!isH2) {
                    connection = this.defaultFactory.getResultSetProvider(layer, pm);
                    return connection;
                }
                ReadRowSet readRowSet = this.cache.get(tableRef);
                ResultSetProviderFactory.ResultSetProvider defaultResultSetProvider = this.defaultFactory.getResultSetProvider(layer, pm);
                if (readRowSet == null) {
                    readRowSet = layer.getDataManager().createReadRowSet();
                    if (integerPK.isEmpty()) {
                        readRowSet.setCommand("SELECT " + defaultResultSetProvider.getPkName() + ", * FROM " + tableRef);
                    }
                    readRowSet.setFetchSize(50);
                    readRowSet.setCloseDelay(60000);
                    readRowSet.setFetchDirection(1000);
                    readRowSet.initialize(tableRef, integerPK, pm);
                    this.cache.put(tableRef, readRowSet);
                }
                CachedResultSet cachedResultSet = new CachedResultSet(readRowSet, tableRef, layer.getEnvelope(), defaultResultSetProvider);
                return cachedResultSet;
            }
            try {
                throw new SQLException("Cannot draw until layer data source is not initialized");
            }
            catch (InterruptedException ex) {
                throw new SQLException("Cannot draw until layer data source is not initialized");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearCache() {
        for (ReadRowSet rowSet : this.cache.values()) {
            rowSet.setCloseDelay(0);
        }
        this.cache.clear();
    }

    public void removeCache(String tableReference) {
        ReadRowSet removedCache;
        if (!this.cache.containsKey(tableReference) && TableLocation.parse((String)tableReference).getSchema().equalsIgnoreCase("public")) {
            tableReference = TableLocation.parse((String)tableReference).getTable();
        }
        if ((removedCache = this.cache.remove(tableReference)) != null) {
            removedCache.setCloseDelay(0);
        }
    }

    private static class CachedResultSet
    implements ResultSetProviderFactory.ResultSetProvider {
        private ReadRowSet readRowSet;
        private String tableReference;
        private Lock lock;
        private Envelope tableEnvelope;
        private ResultSetProviderFactory.ResultSetProvider resultSetProvider;
        private String pkName;

        private CachedResultSet(ReadRowSet readRowSet, String tableReference, Envelope tableEnvelope, ResultSetProviderFactory.ResultSetProvider resultSetProvider) {
            this.readRowSet = readRowSet;
            this.tableReference = tableReference;
            this.tableEnvelope = tableEnvelope;
            this.resultSetProvider = resultSetProvider;
            this.pkName = resultSetProvider.getPkName();
        }

        public String getPkName() {
            return this.pkName;
        }

        public SpatialResultSet execute(ProgressMonitor pm, Envelope extent) throws SQLException {
            this.lock = this.readRowSet.getReadLock();
            try {
                this.lock.tryLock(10L, TimeUnit.SECONDS);
                double intersectionPercentage = extent.intersection(this.tableEnvelope).getArea() / this.tableEnvelope.getArea();
                if (intersectionPercentage > 0.2) {
                    this.readRowSet.beforeFirst();
                    return this.readRowSet;
                }
                return this.resultSetProvider.execute(pm, extent);
            }
            catch (InterruptedException ex) {
                throw new SQLException(I18N.tr("Lock timeout while fetching {0}, another job is using this resource.", (Object)this.tableReference));
            }
        }

        public void close() throws SQLException {
            if (this.lock != null) {
                this.lock.unlock();
            }
            this.resultSetProvider.close();
        }
    }
}

