/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.h2gis.utilities.TableLocation;
import org.orbisgis.core.Services;
import org.orbisgis.corejdbc.TableEditEvent;
import org.orbisgis.corejdbc.TableEditListener;
import org.orbisgis.coremap.layerModel.ILayer;
import org.orbisgis.coremap.layerModel.Layer;
import org.orbisgis.coremap.layerModel.LayerCollectionEvent;
import org.orbisgis.coremap.layerModel.LayerListener;
import org.orbisgis.coremap.layerModel.LayerListenerEvent;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.layerModel.SelectionEvent;
import org.orbisgis.coremap.map.MapTransform;
import org.orbisgis.coremap.map.TransformListener;
import org.orbisgis.coremap.renderer.ImageRenderer;
import org.orbisgis.coremap.renderer.ResultSetProviderFactory;
import org.orbisgis.mapeditor.map.CachedResultSetContainer;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.ToolListener;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.view.background.BackgroundJob;
import org.orbisgis.view.background.BackgroundManager;
import org.orbisgis.view.background.DefaultJobId;
import org.orbisgis.view.background.JobId;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MapControl
extends JComponent
implements ContainerListener {
    private ResultSetProviderFactory resultSetProviderFactory = new CachedResultSetContainer();
    private static final Point MAX_IMAGE_SIZE = new Point(20000, 20000);
    public static final String JOB_DRAWING_PREFIX_ID = "MapControl-Drawing";
    private static final Logger LOGGER = Logger.getLogger(MapControl.class);
    private static final I18n I18N = I18nFactory.getI18n(MapControl.class);
    private static int lastMapControlId = 0;
    private static final long serialVersionUID = 1L;
    private AtomicBoolean awaitingDrawing = new AtomicBoolean(false);
    private int mapControlId;
    public static final int UPDATED = 0;
    public static final int DIRTY = 1;
    private RefreshLayerListener refreshLayerListener = new RefreshLayerListener(this);
    private int status = 1;
    private ToolManager toolManager;
    private Color backColor = Color.white;
    private MapTransform mapTransform = new MapTransform();
    private MapContext mapContext;
    private Drawer drawer;
    private boolean showCoordinates = true;
    TransformListener element;
    Automaton defaultTool;
    PropertyChangeListener boundingBoxPropertyListener = EventHandler.create(PropertyChangeListener.class, this, "onMapContextBoundingBoxChange");
    MapTransform updatedMapTranform = new MapTransform();

    private void setStatus(int newStatus) {
        this.status = newStatus;
    }

    public void onMapContextBoundingBoxChange() {
        Envelope boundingBox = this.mapContext.getBoundingBox();
        if (boundingBox != null) {
            this.mapTransform.setExtent(boundingBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initMapControl(Automaton defaultTool) throws TransitionException {
        MapControl mapControl = this;
        synchronized (mapControl) {
            this.mapControlId = lastMapControlId++;
        }
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.setStatus(1);
        if (this.toolManager != null) {
            this.removeMouseListener(this.toolManager);
            this.removeMouseMotionListener(this.toolManager);
            this.removeMouseWheelListener(this.toolManager);
        }
        this.toolManager = new ToolManager(defaultTool, this.mapContext, this.mapTransform, this);
        ILayer rootLayer = this.mapContext.getLayerModel();
        Envelope boundingBox = this.mapContext.getBoundingBox();
        if (boundingBox != null) {
            this.mapTransform.setExtent(boundingBox);
        } else {
            this.mapTransform.setExtent(rootLayer.getEnvelope());
        }
        this.setLayout(new BorderLayout());
        this.toolManager.addToolListener(new MapToolListener());
        this.addMouseListener(this.toolManager);
        this.addMouseMotionListener(this.toolManager);
        this.addMouseWheelListener(this.toolManager);
        this.mapTransform.addTransformListener((TransformListener)new MapControlTransformListener());
        this.addComponentListener(EventHandler.create(ComponentListener.class, this, "invalidateImage"));
        if (this.element != null) {
            this.mapTransform.addTransformListener(this.element);
        }
    }

    private void addLayerListenerRecursively(ILayer rootLayer, RefreshLayerListener refreshLayerListener) {
        rootLayer.addLayerListener((LayerListener)refreshLayerListener);
        if (!rootLayer.getTableReference().isEmpty() && rootLayer.getDataManager() != null) {
            rootLayer.getDataManager().removeTableEditListener(rootLayer.getTableReference(), (TableEditListener)refreshLayerListener);
            rootLayer.getDataManager().addTableEditListener(rootLayer.getTableReference(), (TableEditListener)refreshLayerListener);
        }
        for (int i = 0; i < rootLayer.getLayerCount(); ++i) {
            this.addLayerListenerRecursively(rootLayer.getLayer(i), refreshLayerListener);
        }
    }

    private void removeLayerListenerRecursively(ILayer rootLayer, RefreshLayerListener refreshLayerListener) {
        rootLayer.removeLayerListener((LayerListener)refreshLayerListener);
        if (!rootLayer.getTableReference().isEmpty() && rootLayer.getDataManager() != null) {
            rootLayer.getDataManager().removeTableEditListener(rootLayer.getTableReference(), (TableEditListener)refreshLayerListener);
        }
        for (int i = 0; i < rootLayer.getLayerCount(); ++i) {
            this.removeLayerListenerRecursively(rootLayer.getLayer(i), refreshLayerListener);
        }
    }

    public void clearCache() {
        if (this.resultSetProviderFactory instanceof CachedResultSetContainer) {
            ((CachedResultSetContainer)this.resultSetProviderFactory).clearCache();
        }
    }

    public void clearCache(String tableReference) {
        if (this.resultSetProviderFactory instanceof CachedResultSetContainer) {
            ((CachedResultSetContainer)this.resultSetProviderFactory).removeCache(tableReference);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage mapTransformImage = this.mapTransform.getImage();
        g.setColor(this.backColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (mapTransformImage != null && this.status == 0 && !this.awaitingDrawing.get()) {
            this.updatedMapTranform.setImage(mapTransformImage);
            this.updatedMapTranform.setExtent(this.mapTransform.getExtent());
        }
        if (this.updatedMapTranform.getImage() != null && !this.mapTransform.getAdjustedExtent().isNull()) {
            if (this.status == 0 && !this.awaitingDrawing.get()) {
                g.drawImage(this.updatedMapTranform.getImage(), 0, 0, null);
            } else {
                Envelope targetExtent = this.mapTransform.getAdjustedExtent();
                Point pixelPosTarget = this.mapTransform.fromMapPoint((Point2D)new Point2D.Double(targetExtent.getMinX(), targetExtent.getMinY()));
                Point pixelPosDirty = this.mapTransform.fromMapPoint((Point2D)new Point2D.Double(this.updatedMapTranform.getAdjustedExtent().getMinX(), this.updatedMapTranform.getAdjustedExtent().getMinY()));
                int width = this.updatedMapTranform.getImage().getWidth();
                int height = this.updatedMapTranform.getImage().getHeight();
                double wRatio = this.updatedMapTranform.getAdjustedExtent().getWidth() / targetExtent.getWidth();
                double hRatio = this.updatedMapTranform.getAdjustedExtent().getHeight() / targetExtent.getHeight();
                width = (int)((double)width * wRatio);
                int hdiff = (int)((double)height * hRatio) - height;
                height = (int)((double)height * hRatio);
                if (width < MapControl.MAX_IMAGE_SIZE.x && height < MapControl.MAX_IMAGE_SIZE.y) {
                    g.drawImage(this.updatedMapTranform.getImage(), pixelPosDirty.x - pixelPosTarget.x, pixelPosDirty.y - pixelPosTarget.y - hdiff, width, height, null);
                }
            }
            this.toolManager.paintEdition(g);
        }
        if (this.status == 1 && this.mapContext != null) {
            if (!this.awaitingDrawing.getAndSet(true)) {
                this.setStatus(0);
                int width = this.getWidth();
                int height = this.getHeight();
                GraphicsConfiguration configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                BufferedImage inProcessImage = configuration.createCompatibleImage(width, height, 2);
                Graphics2D gImg = inProcessImage.createGraphics();
                gImg.setColor(this.backColor);
                gImg.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.mapTransform.setImage(inProcessImage);
                this.drawer = new Drawer(this.mapContext, this.awaitingDrawing, this, this.resultSetProviderFactory);
                BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
                bm.nonBlockingBackgroundOperation((JobId)new DefaultJobId(JOB_DRAWING_PREFIX_ID + this.mapControlId), (BackgroundJob)this.drawer);
            } else {
                try {
                    this.drawer.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public BufferedImage getImage() {
        return this.mapTransform.getImage();
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color backColor) {
        this.backColor = backColor;
    }

    public void setTool(Automaton tool) throws TransitionException {
        if (this.toolManager != null) {
            this.toolManager.setTool(tool);
        }
    }

    public void invalidateImage() {
        this.setStatus(1);
        this.repaint();
    }

    public MapTransform getMapTransform() {
        return this.mapTransform;
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public Automaton getTool() {
        if (this.toolManager != null) {
            return this.toolManager.getTool();
        }
        return this.defaultTool;
    }

    public void closing() {
        this.clearCache();
        if (this.toolManager != null) {
            this.toolManager.freeResources();
            this.toolManager = null;
            this.removeMapContextListener();
        }
    }

    public void setShowCoordinates(boolean showCoordinates) {
        this.showCoordinates = showCoordinates;
        this.repaint();
    }

    public boolean getShowCoordinates() {
        return this.showCoordinates;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
    }

    public void setElement(TransformListener element) {
        this.element = element;
    }

    private void removeMapContextListener() {
        if (this.mapContext != null) {
            this.mapContext.removePropertyChangeListener(this.boundingBoxPropertyListener);
            this.mapContext.getLayerModel().removeLayerListenerRecursively((LayerListener)this.refreshLayerListener);
        }
    }

    public void setMapContext(MapContext mapContext) {
        this.removeMapContextListener();
        this.mapContext = mapContext;
        if (mapContext != null) {
            mapContext.addPropertyChangeListener(this.boundingBoxPropertyListener);
            this.addLayerListenerRecursively(mapContext.getLayerModel(), this.refreshLayerListener);
        }
    }

    public MapContext getMapContext() {
        return this.mapContext;
    }

    private class MapToolListener
    implements ToolListener {
        private MapToolListener() {
        }

        @Override
        public void transitionException(ToolManager toolManager, TransitionException e) {
            LOGGER.error((Object)I18N.tr("Tool error {0}", (Object)e.getMessage()));
            toolManager.checkToolStatus();
        }

        @Override
        public void stateChanged(ToolManager toolManager) {
        }

        @Override
        public void currentToolChanged(Automaton previous, ToolManager toolManager) {
        }
    }

    private class MapControlTransformListener
    implements TransformListener {
        private MapControlTransformListener() {
        }

        public void imageSizeChanged(int oldWidth, int oldHeight, MapTransform mapTransform) {
            MapControl.this.invalidateImage();
        }

        public void extentChanged(Envelope oldExtent, MapTransform mapTransform) {
            MapControl.this.invalidateImage();
            MapControl.this.mapContext.setBoundingBox(mapTransform.getExtent());
        }
    }

    private static class RefreshLayerListener
    implements LayerListener,
    TableEditListener {
        private MapControl mapControl;

        private RefreshLayerListener(MapControl mapControl) {
            this.mapControl = mapControl;
        }

        public void tableChange(TableEditEvent event) {
            TableLocation tableName = TableLocation.parse((String)event.getTableName());
            for (ILayer layer : this.mapControl.getMapContext().getLayers()) {
                String layerTable = layer.getTableReference();
                if (layerTable.isEmpty() || !TableLocation.parse((String)layerTable).equals((Object)tableName)) continue;
                layer.setSelection(new HashSet());
                this.mapControl.addLayerListenerRecursively(layer, this);
            }
            this.mapControl.clearCache();
            this.mapControl.invalidateImage();
        }

        private void clearLayerCacheRecursively(ILayer rootLayer) {
            if (!rootLayer.getTableReference().isEmpty() && rootLayer.getDataManager() != null) {
                this.mapControl.clearCache(rootLayer.getTableReference());
            }
            for (int i = 0; i < rootLayer.getLayerCount(); ++i) {
                this.clearLayerCacheRecursively(rootLayer.getLayer(i));
            }
        }

        public void layerAdded(LayerCollectionEvent listener) {
            for (ILayer layer : listener.getAffected()) {
                this.mapControl.addLayerListenerRecursively(layer, this);
                ILayer[] model = this.mapControl.getMapContext().getLayers();
                int count = 0;
                for (int i = 0; i < model.length && count < 2; ++i) {
                    if (!(model[i] instanceof Layer)) continue;
                    ++count;
                }
                if (count == 1) {
                    Envelope e = layer.getEnvelope();
                    if (e == null) continue;
                    this.mapControl.mapTransform.setExtent(e);
                    continue;
                }
                this.mapControl.invalidateImage();
            }
        }

        public void layerMoved(LayerCollectionEvent listener) {
            this.mapControl.invalidateImage();
        }

        public boolean layerRemoving(LayerCollectionEvent layerCollectionEvent) {
            return true;
        }

        public void layerRemoved(LayerCollectionEvent listener) {
            for (ILayer layer : listener.getAffected()) {
                this.mapControl.removeLayerListenerRecursively(layer, this);
                this.clearLayerCacheRecursively(layer);
            }
            if (!this.mapControl.mapContext.isLayerModelSpatial()) {
                this.mapControl.mapTransform.setExtent(new Envelope());
            }
            this.mapControl.invalidateImage();
        }

        public void nameChanged(LayerListenerEvent e) {
        }

        public void visibilityChanged(LayerListenerEvent e) {
            this.mapControl.invalidateImage();
        }

        public void styleChanged(LayerListenerEvent e) {
            this.mapControl.invalidateImage();
        }

        public void selectionChanged(SelectionEvent e) {
            this.mapControl.invalidateImage();
        }
    }

    private static class Drawer
    implements BackgroundJob {
        private MapContext mapContext;
        private AtomicBoolean awaitingDrawing;
        private MapControl mapControl;
        private ResultSetProviderFactory resultSetProviderFactory;
        private ProgressMonitor pm;

        private Drawer(MapContext mapContext, AtomicBoolean awaitingDrawing, MapControl mapControl, ResultSetProviderFactory resultSetProviderFactory) {
            this.mapContext = mapContext;
            this.awaitingDrawing = awaitingDrawing;
            this.mapControl = mapControl;
            this.resultSetProviderFactory = resultSetProviderFactory;
        }

        public String getTaskName() {
            return I18N.tr("Drawing");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ProgressMonitor pm) {
            this.pm = pm;
            try {
                long begin = System.currentTimeMillis();
                ImageRenderer renderer = new ImageRenderer();
                renderer.setRsProvider(this.resultSetProviderFactory);
                renderer.draw(this.mapControl.getMapTransform(), this.mapContext.getLayerModel(), pm);
                LOGGER.info((Object)I18N.tr("Rendering done in {0} seconds", (Object)((double)(System.currentTimeMillis() - begin) / 1000.0)));
            }
            finally {
                this.awaitingDrawing.set(false);
                this.mapControl.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Drawer drawer = this;
            synchronized (drawer) {
                if (this.pm != null) {
                    if (!this.pm.isCancelled()) {
                        LOGGER.debug((Object)"Cancel drawing !");
                    }
                    this.pm.setCancelled(true);
                }
            }
        }
    }
}

