/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.orbisgis.core.Services;
import org.orbisgis.core.events.Listener;
import org.orbisgis.core_export.MapImageWriter;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.coremap.layerModel.ILayer;
import org.orbisgis.coremap.layerModel.LayerException;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.map.MapTransform;
import org.orbisgis.coremap.map.TransformListener;
import org.orbisgis.coremap.renderer.ResultSetProviderFactory;
import org.orbisgis.mapeditor.map.MapControl;
import org.orbisgis.mapeditor.map.MapEditorPersistence;
import org.orbisgis.mapeditor.map.MapStatusBar;
import org.orbisgis.mapeditor.map.MapTransferHandler;
import org.orbisgis.mapeditor.map.ext.MapEditorExtension;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.jobs.ReadMapContextJob;
import org.orbisgis.mapeditor.map.mapsManager.MapsManager;
import org.orbisgis.mapeditor.map.mapsManager.TreeLeafMapContextFile;
import org.orbisgis.mapeditor.map.mapsManager.TreeLeafMapElement;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.toolbar.ActionAutomaton;
import org.orbisgis.mapeditor.map.tools.CompassTool;
import org.orbisgis.mapeditor.map.tools.FencePolygonTool;
import org.orbisgis.mapeditor.map.tools.InfoTool;
import org.orbisgis.mapeditor.map.tools.MesureLineTool;
import org.orbisgis.mapeditor.map.tools.MesurePolygonTool;
import org.orbisgis.mapeditor.map.tools.PanTool;
import org.orbisgis.mapeditor.map.tools.PickCoordinatesPointTool;
import org.orbisgis.mapeditor.map.tools.SelectionTool;
import org.orbisgis.mapeditor.map.tools.ZoomInTool;
import org.orbisgis.mapeditor.map.tools.ZoomOutTool;
import org.orbisgis.mapeditorapi.MapElement;
import org.orbisgis.progress.NullProgressMonitor;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.UIPanel;
import org.orbisgis.sif.components.ColorPicker;
import org.orbisgis.sif.components.SaveFilePanel;
import org.orbisgis.sif.multiInputPanel.CheckBoxChoice;
import org.orbisgis.sif.multiInputPanel.InputType;
import org.orbisgis.sif.multiInputPanel.MIPValidation;
import org.orbisgis.sif.multiInputPanel.MIPValidationInteger;
import org.orbisgis.sif.multiInputPanel.MultiInputPanel;
import org.orbisgis.sif.multiInputPanel.TextBoxType;
import org.orbisgis.view.background.BackgroundJob;
import org.orbisgis.view.background.BackgroundManager;
import org.orbisgis.view.background.ZoomToSelection;
import org.orbisgis.view.components.actions.ActionCommands;
import org.orbisgis.view.components.actions.ActionDockingListener;
import org.orbisgis.view.edition.EditableTransferListener;
import org.orbisgis.view.table.jobs.CreateSourceFromSelection;
import org.orbisgis.viewapi.components.actions.DefaultAction;
import org.orbisgis.viewapi.docking.DockingPanelLayout;
import org.orbisgis.viewapi.docking.DockingPanelParameters;
import org.orbisgis.viewapi.edition.EditableElement;
import org.orbisgis.viewapi.edition.EditableSource;
import org.orbisgis.viewapi.edition.EditorManager;
import org.orbisgis.viewapi.workspace.ViewWorkspace;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MapEditor
extends JPanel
implements TransformListener,
MapEditorExtension {
    private static final I18n I18N = I18nFactory.getI18n(MapEditor.class);
    private static final Logger GUILOGGER = Logger.getLogger((String)("gui." + MapEditor.class));
    private static final long serialVersionUID = 1L;
    private MapControl mapControl = new MapControl();
    private MapContext mapContext = null;
    private MapElement mapElement;
    private DockingPanelParameters dockingPanelParameters;
    private MapTransferHandler dragDropHandler;
    private MapStatusBar mapStatusBar = new MapStatusBar();
    private AtomicBoolean processingCursor = new AtomicBoolean(false);
    private Point lastCursorPosition = new Point();
    private AtomicBoolean initialised = new AtomicBoolean(false);
    private MapsManager mapsManager;
    private JLayeredPane layeredPane = new JLayeredPane();
    private ComponentListener sizeListener = EventHandler.create(ComponentListener.class, this, "updateMapControlSize", null, "componentResized");
    private PropertyChangeListener modificationListener = EventHandler.create(PropertyChangeListener.class, this, "onMapModified");
    private PropertyChangeListener activeLayerListener = EventHandler.create(PropertyChangeListener.class, this, "onActiveLayerChange", "");
    private ActionCommands actions = new ActionCommands();
    private MapEditorPersistence mapEditorPersistence = new MapEditorPersistence();
    private DataManager dataManager;
    private ViewWorkspace viewWorkspace;
    private EditorManager editorManager;
    private Map<ResultSetProviderFactory, Action> rsFactories = new HashMap<ResultSetProviderFactory, Action>();
    private boolean userChangedWidth = false;
    private boolean userChangedHeight = false;

    public MapEditor(ViewWorkspace viewWorkspace, DataManager dataManager, EditorManager editorManager) {
        super(new BorderLayout());
        this.editorManager = editorManager;
        this.mapsManager = new MapsManager(viewWorkspace.getMapContextPath(), dataManager, editorManager);
        this.viewWorkspace = viewWorkspace;
        this.dataManager = dataManager;
        this.dockingPanelParameters = new DockingPanelParameters();
        this.dockingPanelParameters.setName("map_editor");
        this.updateMapLabel();
        this.dockingPanelParameters.setTitleIcon((Icon)MapEditorIcons.getIcon("map"));
        this.dockingPanelParameters.setMinimizable(false);
        this.dockingPanelParameters.setExternalizable(false);
        this.dockingPanelParameters.setCloseable(false);
        this.dockingPanelParameters.setLayout((DockingPanelLayout)this.mapEditorPersistence);
        this.dockingPanelParameters.setVisible(true);
        this.layeredPane.add((Component)this.mapControl, 1);
        this.layeredPane.add((Component)this.mapsManager, 0);
        this.mapsManager.setVisible(false);
        this.mapsManager.setMapsManagerPersistence(this.mapEditorPersistence.getMapsManagerPersistence());
        this.mapEditorPersistence.addPropertyChangeListener("defaultMapContext", EventHandler.create(PropertyChangeListener.class, this, "onSerialisationMapChange"));
        this.add((Component)this.layeredPane, "Center");
        this.add((Component)((Object)this.mapStatusBar), "Last");
        this.createActions();
        this.dockingPanelParameters.setDockActions(this.actions.getActions());
        this.actions.addPropertyChangeListener((PropertyChangeListener)new ActionDockingListener(this.dockingPanelParameters));
        this.dragDropHandler = new MapTransferHandler();
        this.setTransferHandler((TransferHandler)((Object)this.dragDropHandler));
    }

    public void addResultSetProviderFactory(ResultSetProviderFactory resultSetProviderFactory) {
        DefaultAction rsAction = new DefaultAction("RSF_" + resultSetProviderFactory.getName(), resultSetProviderFactory.getName(), null, EventHandler.create(ActionListener.class, this, "onChangeRendererData", "")).setMenuGroup(true).setParent("A_DATA_PROVIDERS").setButtonGroup("DATA_PROVIDERS");
        this.rsFactories.put(resultSetProviderFactory, (Action)rsAction);
        this.actions.addAction((Action)rsAction);
    }

    public void removeResultSetProviderFactory(ResultSetProviderFactory resultSetProviderFactory) {
        this.actions.removeAction(this.rsFactories.remove(resultSetProviderFactory));
    }

    public void onChangeRendererData(ActionEvent ae) {
    }

    private void updateMapLabel() {
        if (this.mapElement == null) {
            this.dockingPanelParameters.setTitle(I18N.tr("Map"));
        } else if (this.mapElement.isModified()) {
            this.dockingPanelParameters.setTitle(I18N.tr("Map Editor \"{0}\" [Modified]", (Object)this.mapElement.getMapContext().getTitle()));
        } else {
            this.dockingPanelParameters.setTitle(I18N.tr("Map Editor \"{0}\"", (Object)this.mapElement.getMapContext().getTitle()));
        }
    }

    public void onUserSetScaleDenominator(PropertyChangeEvent pce) throws PropertyVetoException {
        long newScale = (Long)pce.getNewValue();
        if (newScale < 1L) {
            throw new PropertyVetoException(I18N.tr("The value of the scale denominator must be equal or greater than 1"), pce);
        }
        this.mapControl.getMapTransform().setScaleDenominator((double)newScale);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.initialised.getAndSet(true)) {
            this.addComponentListener(this.sizeListener);
            this.initMapContext();
            this.dragDropHandler.getTransferEditableEvent().addListener((Object)this, (Listener)EventHandler.create(EditableTransferListener.class, this, "onDropEditable", "editableList"));
            this.mapControl.addMouseMotionListener(EventHandler.create(MouseMotionListener.class, this, "onMouseMove", "point", "mouseMoved"));
            this.mapStatusBar.addVetoableChangeListener("userDefinedScaleDenominator", EventHandler.create(VetoableChangeListener.class, this, "onUserSetScaleDenominator", ""));
            this.mapsManager.getTree().addComponentListener(this.sizeListener);
            this.mapsManager.getTree().addTreeExpansionListener(EventHandler.create(TreeExpansionListener.class, this, "updateMapControlSize"));
        }
    }

    private void initMapContext() {
        BackgroundManager backgroundManager = (BackgroundManager)Services.getService(BackgroundManager.class);
        File serialisedMapContextPath = new File(this.viewWorkspace.getMapContextPath() + File.separator, this.mapEditorPersistence.getDefaultMapContext());
        if (!serialisedMapContextPath.exists()) {
            this.createDefaultMapContext(this.dataManager);
        } else {
            TreeLeafMapElement defaultMap = (TreeLeafMapElement)this.mapsManager.getFactoryManager().create(serialisedMapContextPath);
            try {
                MapElement mapElementToLoad = defaultMap.getMapElement((ProgressMonitor)new NullProgressMonitor(), this.dataManager);
                backgroundManager.backgroundOperation((BackgroundJob)new ReadMapContextJob(mapElementToLoad, this.editorManager));
            }
            catch (IllegalArgumentException ex) {
                GUILOGGER.warn((Object)I18N.tr("Fail to load the map context, starting with an empty map context"), (Throwable)ex);
                this.createDefaultMapContext(this.dataManager);
            }
        }
    }

    private void createDefaultMapContext(DataManager dataManager) {
        File mapContextFile;
        BackgroundManager backgroundManager = (BackgroundManager)Services.getService(BackgroundManager.class);
        File mapContextFolder = new File(this.viewWorkspace.getMapContextPath());
        if (!mapContextFolder.exists()) {
            mapContextFolder.mkdir();
        }
        if (!(mapContextFile = new File(mapContextFolder, I18N.tr("MyMap.ows"))).exists()) {
            TreeLeafMapContextFile.createEmptyMapContext(mapContextFile, dataManager);
        }
        MapElement editableMap = new MapElement(mapContextFile, dataManager);
        backgroundManager.backgroundOperation((BackgroundJob)new ReadMapContextJob(editableMap, this.editorManager));
    }

    public void updateMapControlSize() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapEditor.this.doUpdateMapControlSize();
            }
        });
    }

    private void doUpdateMapControlSize() {
        this.mapControl.setBounds(0, 0, this.layeredPane.getWidth(), this.layeredPane.getHeight());
        if (this.mapsManager.isVisible()) {
            Dimension mapsManagerPreferredSize = this.mapsManager.getMinimalComponentDimension();
            int hPos = this.layeredPane.getWidth() - Math.min(mapsManagerPreferredSize.width, this.layeredPane.getWidth());
            this.mapsManager.setBounds(hPos, 0, Math.min(mapsManagerPreferredSize.width, this.layeredPane.getWidth()), Math.min(mapsManagerPreferredSize.height, this.layeredPane.getHeight()));
            this.mapsManager.revalidate();
        }
    }

    public void onDropEditable(EditableElement[] editableList) {
        BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
        bm.nonBlockingBackgroundOperation((BackgroundJob)new DropDataSourceProcess(editableList));
    }

    private void loadMap(MapElement element) {
        MapElement oldMapElement = this.mapElement;
        ToolManager oldToolManager = this.getToolManager();
        this.removeListeners();
        this.mapElement = element;
        if (element != null) {
            try {
                this.mapContext = (MapContext)element.getObject();
                this.mapContext.addPropertyChangeListener("activeLayer", this.activeLayerListener);
                this.mapControl.setMapContext(this.mapContext);
                this.mapControl.getMapTransform().setExtent(this.mapContext.getBoundingBox());
                this.mapControl.setElement(this);
                this.mapControl.initMapControl(new PanTool());
                URI rootDir = new File(this.viewWorkspace.getMapContextPath() + File.separator).toURI();
                String relative = rootDir.relativize(element.getMapContextFile().toURI()).getPath();
                this.mapEditorPersistence.setDefaultMapContext(relative);
                this.mapsManager.setLoadedMap(element.getMapContextFile());
                this.updateMapLabel();
                this.mapElement.addPropertyChangeListener("modified", this.modificationListener);
                this.repaint();
            }
            catch (IllegalStateException ex) {
                GUILOGGER.error((Object)ex);
            }
            catch (TransitionException ex) {
                GUILOGGER.error((Object)ex);
            }
        } else {
            this.mapControl.setMapContext(null);
        }
        this.firePropertyChange("toolManager", oldToolManager, this.getToolManager());
        this.firePropertyChange("mapElement", oldMapElement, this.mapElement);
    }

    public void onSerialisationMapChange() {
        String fileName = this.mapEditorPersistence.getDefaultMapContext();
        File mapFilePath = new File(this.viewWorkspace.getMapContextPath(), fileName);
        if (!mapFilePath.exists()) {
            return;
        }
        if (this.mapElement != null && mapFilePath.equals(this.mapElement.getMapContextFile())) {
            return;
        }
        MapElement mapElement = new MapElement(mapFilePath, this.dataManager);
        BackgroundManager backgroundManager = (BackgroundManager)Services.getService(BackgroundManager.class);
        backgroundManager.backgroundOperation((BackgroundJob)new ReadMapContextJob(mapElement, this.editorManager));
    }

    public void onMouseMove(Point mousePosition) {
        this.lastCursorPosition.setLocation(mousePosition);
        if (this.mapElement != null && !this.processingCursor.getAndSet(true)) {
            CursorCoordinateProcessing run = new CursorCoordinateProcessing(this.mapStatusBar, this.processingCursor, this.mapControl.getMapTransform(), this.lastCursorPosition);
            run.execute();
        }
    }

    public void dispose() {
        this.removeListeners();
        this.getMapControl().closing();
        this.loadMap(null);
    }

    @Override
    public MapElement getMapElement() {
        return this.mapElement;
    }

    private void createActions() {
        this.actions.addAction((Action)new ActionAutomaton("A_ZOOM_IN", new ZoomInTool(), this).setLogicalGroup("navigation"));
        this.actions.addAction((Action)new ActionAutomaton("A_ZOOM_OUT", new ZoomOutTool(), this).setLogicalGroup("navigation"));
        this.actions.addAction((Action)new DefaultAction("A_FULL_EXTENT", I18N.tr("Full extent"), (Icon)MapEditorIcons.getIcon("zoom_extent"), EventHandler.create(ActionListener.class, this, "onFullExtent")).setToolTipText(I18N.tr("Zoom to show all geometries")).setLogicalGroup("navigation"));
        this.actions.addAction((Action)new ActionAutomaton("A_PAN", new PanTool(), this).setLogicalGroup("navigation"));
        this.actions.addAction((Action)new ActionAutomaton("A_INFO_TOOL", new InfoTool(), this).addTrackedMapContextProperty("selectedLayers").addTrackedMapContextProperty("selectedStyles").setLogicalGroup("selection"));
        this.actions.addAction((Action)new ActionAutomaton("A_SELECTION", new SelectionTool(), this).addTrackedMapContextProperty("selectedLayers").addTrackedMapContextProperty("selectedStyles").setLogicalGroup("selection"));
        this.actions.addAction((Action)new DefaultAction("A_CLEAR_SELECTION_GROUP", I18N.tr("Clear selection tools")).setMenuGroup(true));
        this.actions.addAction((Action)new DefaultAction("A_CLEAR_ALL_SELECTION", I18N.tr("Clear all selection"), (Icon)MapEditorIcons.getIcon("edit-clear_all"), EventHandler.create(ActionListener.class, this, "onClearAllSelection")).setToolTipText(I18N.tr("Clear all selected geometries of all layers")).setParent("A_CLEAR_SELECTION_GROUP"));
        this.actions.addAction((Action)new DefaultAction("A_CLEAR_LAYER_SELECTION", I18N.tr("Clear selected layers"), (Icon)MapEditorIcons.getIcon("edit-clear"), EventHandler.create(ActionListener.class, this, "onClearLayerSelection")).setToolTipText(I18N.tr("Clear all selected geometries of the selected layers")).setParent("A_CLEAR_SELECTION_GROUP"));
        this.actions.addAction((Action)new DefaultAction("A_ZOOM_SELECTION_GROUP", I18N.tr("Zoom to tools")).setMenuGroup(true));
        this.actions.addAction((Action)new DefaultAction("A_ZOOM_ALL_SELECTION", I18N.tr("Zoom to all selection"), (Icon)MapEditorIcons.getIcon("zoom_selected_all"), EventHandler.create(ActionListener.class, this, "onZoomToAllSelection")).setToolTipText(I18N.tr("Zoom to all selected geometries")).setParent("A_ZOOM_SELECTION_GROUP"));
        this.actions.addAction((Action)new DefaultAction("A_ZOOM_LAYER_SELECTION", I18N.tr("Zoom to layer selection"), (Icon)MapEditorIcons.getIcon("zoom_selected"), EventHandler.create(ActionListener.class, this, "onZoomToLayerSelection")).setToolTipText(I18N.tr("Zoom to selected geometries of the selected layers")).setParent("A_ZOOM_SELECTION_GROUP"));
        this.actions.addAction((Action)new DefaultAction("A_DATA_SOURCE_FROM_SELECTION", I18N.tr("Create datasource from selection"), (Icon)MapEditorIcons.getIcon("table_go"), EventHandler.create(ActionListener.class, this, "onCreateDataSourceFromSelection")).setToolTipText(I18N.tr("Create a datasource from the current selection")).setLogicalGroup("selection"));
        this.actions.addAction((Action)new DefaultAction("A_MEASURE_GROUP", I18N.tr("Mesure tools")).setMenuGroup(true));
        this.actions.addAction((Action)new ActionAutomaton("A_MEASURE_LINE", new MesureLineTool(), this).setParent("A_MEASURE_GROUP"));
        this.actions.addAction((Action)new ActionAutomaton("A_MEASURE_POLYGON", new MesurePolygonTool(), this).setParent("A_MEASURE_GROUP"));
        this.actions.addAction((Action)new ActionAutomaton("A_COMPASS", new CompassTool(), this).setParent("A_MEASURE_GROUP"));
        this.actions.addAction((Action)new DefaultAction("A_DRAWING_GROUP", I18N.tr("Graphic tools")).setMenuGroup(true));
        this.actions.addAction((Action)new ActionAutomaton("A_FENCE", new FencePolygonTool(), this).setParent("A_DRAWING_GROUP"));
        this.actions.addAction((Action)new ActionAutomaton("A_PICK_COORDINATES", new PickCoordinatesPointTool(), this).setParent("A_DRAWING_GROUP"));
        this.actions.addAction((Action)new DefaultAction("A_MAP_TREE", I18N.tr("Maps manager"), (Icon)MapEditorIcons.getIcon("map_manager"), EventHandler.create(ActionListener.class, this, "onShowHideMapsTree")).setToolTipText(I18N.tr("Show/Hide Maps Manager")));
        this.actions.addAction((Action)new DefaultAction("A_MAP_EXPORT_IMAGE", I18N.tr("Export map as image"), (Icon)MapEditorIcons.getIcon("export_image"), EventHandler.create(ActionListener.class, this, "onExportMapRendering")).setToolTipText(I18N.tr("Export image as file")));
        this.actions.addAction((Action)new DefaultAction("A_MAP_CLEAR_CACHE", I18N.tr("Refresh"), (Icon)MapEditorIcons.getIcon("refresh"), EventHandler.create(ActionListener.class, this, "onClearCache")));
    }

    public ActionCommands getActionCommands() {
        return this.actions;
    }

    public void onClearCache() {
        this.mapControl.clearCache();
        this.mapControl.invalidateImage();
    }

    public void onShowHideMapsTree() {
        if (!this.mapsManager.isVisible()) {
            this.mapsManager.setVisible(true);
            this.updateMapControlSize();
        } else {
            this.mapsManager.setVisible(false);
        }
    }

    public void onFullExtent() {
        this.mapControl.getMapTransform().setExtent(this.mapContext.getLayerModel().getEnvelope());
    }

    public void onExportMapRendering() {
        String WIDTH_T = "width";
        String HEIGHT_T = "height";
        String RATIO_CHECKBOX_T = "ratio checkbox";
        String TRANSPARENT_BACKGROUND_T = "background";
        String DPI_T = "dpi";
        int textWidth = 8;
        final MultiInputPanel inputPanel = new MultiInputPanel(I18N.tr("Export parameters"));
        inputPanel.addInput("background", "", "True", (InputType)new CheckBoxChoice(true, "<html>" + I18N.tr("Transparent\nbackground") + "</html>"));
        inputPanel.addInput("dpi", I18N.tr("DPI"), String.valueOf(72), (InputType)new TextBoxType(8));
        TextBoxType tbWidth = new TextBoxType(8);
        inputPanel.addInput("width", I18N.tr("Width (pixels)"), String.valueOf(this.mapControl.getImage().getWidth()), (InputType)tbWidth);
        TextBoxType tbHeight = new TextBoxType(8);
        inputPanel.addInput("height", I18N.tr("Height (pixels)"), String.valueOf(this.mapControl.getImage().getHeight()), (InputType)tbHeight);
        tbHeight.getComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MapEditor.this.userChangedHeight = true;
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.updateWidth();
            }

            private void updateWidth() {
                String heightString;
                if (MapEditor.this.userChangedHeight && inputPanel.getInput("ratio checkbox").equals("true") && !(heightString = inputPanel.getInput("height")).isEmpty()) {
                    try {
                        Envelope adjExtent = MapEditor.this.mapControl.getMapTransform().getAdjustedExtent();
                        double ratio = adjExtent.getWidth() / adjExtent.getHeight();
                        int height = Integer.parseInt(heightString);
                        long newWidth = Math.round((double)height * ratio);
                        inputPanel.setValue("width", String.valueOf(newWidth));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                MapEditor.this.userChangedWidth = false;
            }
        });
        tbWidth.getComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MapEditor.this.userChangedWidth = true;
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.updateHeight();
            }

            private void updateHeight() {
                String widthString;
                if (MapEditor.this.userChangedWidth && inputPanel.getInput("ratio checkbox").equals("true") && !(widthString = inputPanel.getInput("width")).isEmpty()) {
                    try {
                        Envelope adjExtent = MapEditor.this.mapControl.getMapTransform().getAdjustedExtent();
                        double ratio = adjExtent.getHeight() / adjExtent.getWidth();
                        int width = Integer.parseInt(widthString);
                        long newHeight = Math.round((double)width * ratio);
                        inputPanel.setValue("height", String.valueOf(newHeight));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                MapEditor.this.userChangedHeight = false;
            }
        });
        inputPanel.addInput("ratio checkbox", "", (InputType)new CheckBoxChoice(true, I18N.tr("Keep ratio")));
        inputPanel.addValidation((MIPValidation)new MIPValidationInteger("width", I18N.tr("Width (pixels)")));
        inputPanel.addValidation((MIPValidation)new MIPValidationInteger("height", I18N.tr("Height (pixels)")));
        inputPanel.addValidation((MIPValidation)new MIPValidationInteger("dpi", I18N.tr("DPI")));
        JButton refreshButton = new JButton(I18N.tr("Reset extent"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                inputPanel.setValue("width", String.valueOf(MapEditor.this.mapControl.getImage().getWidth()));
                inputPanel.setValue("height", String.valueOf(MapEditor.this.mapControl.getImage().getHeight()));
            }
        });
        int userChoice = JOptionPane.showOptionDialog(this, inputPanel.getComponent(), I18N.tr("Export map as image"), 2, 3, MapEditorIcons.getIcon("map_catalog"), new Object[]{I18N.tr("OK"), I18N.tr("Cancel"), refreshButton}, null);
        if (userChoice == 0) {
            MapImageWriter mapImageWriter = new MapImageWriter(this.mapContext.getLayerModel());
            mapImageWriter.setPixelSize(25.4 / Double.valueOf(inputPanel.getInput("dpi")));
            if (!Boolean.valueOf(inputPanel.getInput("background")).booleanValue()) {
                ColorPicker colorPicker = new ColorPicker(Color.white);
                if (!UIFactory.showDialog((UIPanel)colorPicker, (boolean)true, (boolean)true)) {
                    return;
                }
                mapImageWriter.setBackgroundColor(colorPicker.getColor());
            }
            SaveFilePanel outfilePanel = new SaveFilePanel("MapEditor.ExportInFile", I18N.tr("Save the map as image : " + this.mapContext.getTitle()));
            outfilePanel.addFilter("png", I18N.tr("Portable Network Graphics"));
            outfilePanel.addFilter("tiff", I18N.tr("Tagged Image File Format"));
            outfilePanel.addFilter("jpg", I18N.tr("Joint Photographic Experts Group"));
            outfilePanel.addFilter("pdf", I18N.tr("Portable Document Format"));
            outfilePanel.loadState();
            if (UIFactory.showDialog((UIPanel)outfilePanel, (boolean)true, (boolean)true)) {
                File outFile = outfilePanel.getSelectedFile();
                String fileName = FilenameUtils.getExtension((String)outFile.getName());
                if (fileName.equalsIgnoreCase("png")) {
                    mapImageWriter.setFormat(MapImageWriter.Format.PNG);
                } else if (fileName.equalsIgnoreCase("jpg")) {
                    mapImageWriter.setFormat(MapImageWriter.Format.JPEG);
                } else if (fileName.equalsIgnoreCase("pdf")) {
                    mapImageWriter.setFormat(MapImageWriter.Format.PDF);
                } else {
                    mapImageWriter.setFormat(MapImageWriter.Format.TIFF);
                }
                mapImageWriter.setBoundingBox(this.mapContext.getBoundingBox());
                int width = Integer.valueOf(inputPanel.getInput("width"));
                int height = Integer.valueOf(inputPanel.getInput("height"));
                mapImageWriter.setWidth(width);
                mapImageWriter.setHeight(height);
                ExportRenderingIntoFile renderingIntoFile = new ExportRenderingIntoFile(mapImageWriter, outFile);
                BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
                bm.nonBlockingBackgroundOperation((BackgroundJob)renderingIntoFile);
            }
        }
    }

    public void onActiveLayerChange(PropertyChangeEvent evt) {
        if (this.getToolManager() != null) {
            this.getToolManager().activeLayerChanged(evt);
            this.getToolManager().checkToolStatus();
        }
    }

    public void onClearLayerSelection() {
        ILayer[] selectedLayers = this.getMapControl().getToolManager().getSelectedLayerAndStyle();
        if (selectedLayers == null || selectedLayers.length == 0) {
            GUILOGGER.warn((Object)I18N.tr("Please select a layer or a style in the TOC."));
        } else {
            for (ILayer layer : selectedLayers) {
                if (layer.acceptsChilds() || layer.getSelection().isEmpty()) continue;
                layer.setSelection(new HashSet());
            }
        }
    }

    public void onClearAllSelection() {
        for (ILayer layer : this.mapContext.getLayers()) {
            if (layer.acceptsChilds() || layer.getSelection().isEmpty()) continue;
            layer.setSelection(new HashSet());
        }
    }

    public void onZoomToAllSelection() {
        ArrayList<ILayer> selectedLayers = new ArrayList<ILayer>();
        for (ILayer iLayer : this.mapContext.getLayers()) {
            if (iLayer.getSelection().isEmpty()) continue;
            selectedLayers.add(iLayer);
        }
        if (!selectedLayers.isEmpty()) {
            BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
            bm.backgroundOperation((BackgroundJob)new ZoomToSelection(this.mapContext, selectedLayers.toArray(new ILayer[selectedLayers.size()])));
        } else {
            GUILOGGER.warn((Object)I18N.tr("There is any selection available."));
        }
    }

    public void onZoomToLayerSelection() {
        ILayer[] selectedLayers = this.getMapControl().getToolManager().getSelectedLayerAndStyle();
        if (selectedLayers == null || selectedLayers.length == 0) {
            GUILOGGER.warn((Object)I18N.tr("Please select a layer or a style in the TOC"));
        } else {
            BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
            bm.backgroundOperation((BackgroundJob)new ZoomToSelection(this.mapContext, selectedLayers));
        }
    }

    public void onCreateDataSourceFromSelection() {
        ILayer[] selectedLayers = this.getMapControl().getToolManager().getSelectedLayerAndStyle();
        if (selectedLayers == null || selectedLayers.length == 0) {
            GUILOGGER.warn((Object)I18N.tr("No layers are selected."));
        } else {
            for (ILayer layer : selectedLayers) {
                Set selection = layer.getSelection();
                if (!selection.isEmpty()) {
                    try {
                        String newName = CreateSourceFromSelection.showNewNameDialog((Component)this, (DataSource)this.dataManager.getDataSource(), (String)layer.getTableReference());
                        if (newName == null) continue;
                        BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
                        bm.backgroundOperation((BackgroundJob)new CreateSourceFromSelection(this.dataManager.getDataSource(), selection, layer.getTableReference(), newName));
                    }
                    catch (SQLException ex) {
                        GUILOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                    }
                    continue;
                }
                GUILOGGER.warn((Object)I18N.tr("Layer {0} has no selected geometries.", (Object)layer.getName()));
            }
        }
    }

    public DockingPanelParameters getDockingParameters() {
        return this.dockingPanelParameters;
    }

    public JComponent getComponent() {
        return this;
    }

    public MapControl getMapControl() {
        return this.mapControl;
    }

    public void extentChanged(Envelope oldExtent, MapTransform mapTransform) {
        this.mapStatusBar.setScaleDenominator(mapTransform.getScaleDenominator());
    }

    public void imageSizeChanged(int oldWidth, int oldHeight, MapTransform mapTransform) {
    }

    public boolean match(EditableElement editableElement) {
        return editableElement instanceof MapElement;
    }

    public EditableElement getEditableElement() {
        return this.mapElement;
    }

    public void setEditableElement(EditableElement editableElement) {
        if (editableElement instanceof MapElement) {
            this.loadMap((MapElement)editableElement);
        }
    }

    private void removeListeners() {
        if (this.mapElement != null) {
            this.mapElement.removePropertyChangeListener(this.modificationListener);
            this.mapElement.getMapContext().removePropertyChangeListener(this.activeLayerListener);
        }
        if (this.mapControl != null && this.mapControl.getToolManager() != null) {
            this.mapControl.getToolManager().removeToolListener(null);
        }
    }

    public void onMapModified() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapEditor.this.updateMapLabel();
                MapEditor.this.mapsManager.updateDiskTree();
                if (MapEditor.this.getToolManager() != null) {
                    MapEditor.this.getToolManager().updateToolsStatus();
                }
            }
        });
    }

    @Override
    public ToolManager getToolManager() {
        return this.mapControl.getToolManager();
    }

    private static class CursorCoordinateProcessing
    extends SwingWorker<Point2D, Point2D> {
        MapStatusBar mapStatusBar;
        AtomicBoolean processingCursorPosition;
        MapTransform mapTransform;
        Point mousePosition;

        private CursorCoordinateProcessing(MapStatusBar mapStatusBar, AtomicBoolean processingCursorPosition, MapTransform mapTransform, Point mousePosition) {
            this.mapStatusBar = mapStatusBar;
            this.processingCursorPosition = processingCursorPosition;
            this.mapTransform = mapTransform;
            this.mousePosition = mousePosition;
        }

        public String toString() {
            return "MapEditor#CursorCoordinateProcessing";
        }

        @Override
        protected Point2D doInBackground() throws Exception {
            return this.mapTransform.toMapPoint(this.mousePosition.x, this.mousePosition.y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                this.mapStatusBar.setCursorCoordinates((Point2D)this.get());
            }
            catch (Exception ex) {
                GUILOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
            finally {
                this.processingCursorPosition.set(false);
            }
        }
    }

    private class DropDataSourceProcess
    implements BackgroundJob {
        private EditableElement[] editableList;

        public DropDataSourceProcess(EditableElement[] editableList) {
            this.editableList = (EditableElement[])editableList.clone();
        }

        public void run(ProgressMonitor progress) {
            ProgressMonitor pm = progress.startTask((long)this.editableList.length);
            ILayer dropLayer = MapEditor.this.mapContext.getLayerModel();
            boolean i = false;
            for (EditableElement eElement : this.editableList) {
                if (eElement instanceof EditableSource) {
                    try {
                        EditableSource edit = (EditableSource)eElement;
                        dropLayer.addLayer(MapEditor.this.mapContext.createLayer(edit.getTableReference()));
                    }
                    catch (LayerException e) {
                        GUILOGGER.warn((Object)I18N.tr("Unable to create and drop the layer"), (Throwable)e);
                    }
                    continue;
                }
                if (!(eElement instanceof MapElement)) continue;
                final MapElement mapElement = (MapElement)eElement;
                mapElement.open(pm);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MapEditor.this.editorManager.openEditable((EditableElement)mapElement);
                    }
                });
                return;
            }
        }

        public String getTaskName() {
            return I18N.tr("Load the data source droped into the map editor.");
        }
    }

    private static class ExportRenderingIntoFile
    implements BackgroundJob {
        private MapImageWriter mapImageWriter;
        private File outFile;

        private ExportRenderingIntoFile(MapImageWriter mapImageWriter, File outFile) {
            this.mapImageWriter = mapImageWriter;
            this.outFile = outFile;
        }

        public String getTaskName() {
            return I18N.tr("Drawing into file");
        }

        public void run(ProgressMonitor pm) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.outFile);
                this.mapImageWriter.write((OutputStream)fileOutputStream, pm);
            }
            catch (IOException ex) {
                GUILOGGER.error((Object)"Error while saving map editor image", (Throwable)ex);
            }
        }
    }
}

