/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.orbisgis.mapeditor.map.mapsManager.MapsManagerPersistence;
import org.orbisgis.viewapi.docking.DockingPanelLayout;
import org.orbisgis.viewapi.util.PropertyHost;
import org.orbisgis.viewapi.util.XElement;

public class MapEditorPersistence
implements DockingPanelLayout,
Serializable,
PropertyHost {
    private static final long serialVersionUID = 3L;
    private MapsManagerPersistence mapsManagerPersistence = new MapsManagerPersistence();
    private static final String MAP_EDITOR_NODE = "mapEditor";
    public static final String PROP_DEFAULTMAPCONTEXT = "defaultMapContext";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String defaultMapContext = "map.ows";

    public final void setDefaultMapContext(String defaultMapContext) {
        String oldDefaultMapContext = this.defaultMapContext;
        this.defaultMapContext = defaultMapContext;
        this.propertyChangeSupport.firePropertyChange(PROP_DEFAULTMAPCONTEXT, oldDefaultMapContext, defaultMapContext);
    }

    public MapsManagerPersistence getMapsManagerPersistence() {
        return this.mapsManagerPersistence;
    }

    public String getDefaultMapContext() {
        return this.defaultMapContext;
    }

    public void writeStream(DataOutputStream out) throws IOException {
        out.writeLong(3L);
        out.writeUTF(this.defaultMapContext);
        this.mapsManagerPersistence.writeStream(out);
    }

    public void readStream(DataInputStream in) throws IOException {
        long version = in.readLong();
        if (version == 3L) {
            this.setDefaultMapContext(in.readUTF());
            this.mapsManagerPersistence.readStream(in);
        }
    }

    public void writeXML(XElement element) {
        element.addLong("serialVersionUID", 3L);
        XElement mapElement = element.addElement(MAP_EDITOR_NODE);
        mapElement.addString(PROP_DEFAULTMAPCONTEXT, this.defaultMapContext);
        this.mapsManagerPersistence.writeXML(mapElement);
    }

    public void readXML(XElement element) {
        long version = element.getLong("serialVersionUID");
        if (version == 3L) {
            XElement mapElement = element.getElement(MAP_EDITOR_NODE);
            this.setDefaultMapContext(mapElement.getString(PROP_DEFAULTMAPCONTEXT));
            this.mapsManagerPersistence.readXML(mapElement);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(prop, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(prop, listener);
    }
}

