/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.EventHandler;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.cts.crs.CoordinateReferenceSystem;
import org.orbisgis.core.events.OGVetoableChangeSupport;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.sif.components.CustomButton;
import org.orbisgis.view.components.statusbar.StatusBar;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MapStatusBar
extends StatusBar {
    private static final I18n I18N = I18nFactory.getI18n(MapStatusBar.class);
    private static final Logger LOGGER = Logger.getLogger(MapStatusBar.class);
    public static final String PROP_USER_DEFINED_SCALE_DENOMINATOR = "userDefinedScaleDenominator";
    private static final int STATUS_BAR_HEIGHT = 30;
    private ActionListener scaleInputActionListener = EventHandler.create(ActionListener.class, (Object)this, "validateInputScale");
    protected VetoableChangeSupport vetoableChangeSupport = new OGVetoableChangeSupport((Object)this);
    private JLabel scaleLabel;
    private JTextField scaleField;
    private double scaleValue = 1.0;
    private long userDefinedScaleDenominator = 1L;
    private JLabel projectionLabel;
    private JLabel mouseCoordinatesLabel;
    private Point2D mouseCoordinates = new Point2D.Double();
    private static final int OUTER_BAR_BORDER = 1;
    private static final int HORIZONTAL_EMPTY_BORDER = 4;

    public MapStatusBar() {
        super(1, 4);
        this.setPreferredSize(new Dimension(-1, 30));
        this.setMinimumSize(new Dimension(1, 30));
        this.mouseCoordinatesLabel = new JLabel();
        this.addComponent(this.mouseCoordinatesLabel, 4);
        this.projectionLabel = new JLabel();
        this.addComponent(this.projectionLabel, 4);
        CustomButton changeProjection = new CustomButton((Icon)MapEditorIcons.getIcon("world_projection"));
        changeProjection.setToolTipText(I18N.tr("Change coordinate reference system"));
        this.addComponent((JComponent)changeProjection, 4, false);
        this.scaleLabel = new JLabel(I18N.tr("Scale :"));
        this.scaleField = new JTextField();
        this.scaleField.addActionListener(this.scaleInputActionListener);
        this.scaleField.setInputVerifier(new FormattedTextFieldVerifier());
        this.addComponent(this.scaleLabel, 4);
        this.addComponent(this.scaleField, 4, false);
        this.setScaleDenominator(1.0);
        this.setProjection(null);
        this.setCursorCoordinates(new Point2D.Double());
    }

    public void validateInputScale() {
        this.scaleField.getInputVerifier().verify(this.scaleField);
    }

    public void setUserDefinedScaleDenominator(long userDefinedScaleDenominator) throws PropertyVetoException {
        long oldUserDefinedScaleDenominator = this.userDefinedScaleDenominator;
        this.vetoableChangeSupport.fireVetoableChange(PROP_USER_DEFINED_SCALE_DENOMINATOR, oldUserDefinedScaleDenominator, userDefinedScaleDenominator);
        this.fireVetoableChange(PROP_USER_DEFINED_SCALE_DENOMINATOR, oldUserDefinedScaleDenominator, userDefinedScaleDenominator);
        this.userDefinedScaleDenominator = userDefinedScaleDenominator;
        this.firePropertyChange(PROP_USER_DEFINED_SCALE_DENOMINATOR, oldUserDefinedScaleDenominator, userDefinedScaleDenominator);
    }

    public final void setProjection(CoordinateReferenceSystem projection) {
        String projectLabel = "Unknown CRS";
        this.projectionLabel.setText(I18N.tr("Projection : {0}", (Object)projectLabel));
    }

    public void addVetoableChangeListener(String property, VetoableChangeListener listener) {
        this.vetoableChangeSupport.addVetoableChangeListener(property, listener);
    }

    public final void setCursorCoordinates(Point2D cursorCoordinate) {
        if (!this.mouseCoordinates.equals(cursorCoordinate)) {
            this.mouseCoordinates = cursorCoordinate;
            NumberFormat f = DecimalFormat.getInstance(new Locale("en"));
            f.setGroupingUsed(false);
            this.mouseCoordinatesLabel.setText(I18N.tr("X:{0} Y:{1}", (Object)f.format(cursorCoordinate.getX()), (Object)f.format(cursorCoordinate.getY())));
        }
    }

    public final void setScaleDenominator(double scaleDenominator) {
        this.scaleValue = scaleDenominator;
        this.scaleField.setText(I18N.tr("1:{0}", (Object)Math.round(scaleDenominator)));
        this.validate();
    }

    private class FormattedTextFieldVerifier
    extends InputVerifier {
        private FormattedTextFieldVerifier() {
        }

        private void invalidateUserInput() {
            MapStatusBar.this.setScaleDenominator(MapStatusBar.this.scaleValue);
        }

        @Override
        public boolean verify(JComponent input) {
            if (input instanceof JTextField) {
                LOGGER.debug((Object)"Verify scale user input..");
                JTextField ftf = (JTextField)input;
                String text = ftf.getText();
                NumberFormat ft = NumberFormat.getIntegerInstance();
                String[] scaleParts = text.split(":");
                if (scaleParts.length != 2) {
                    LOGGER.error((Object)I18N.tr("The format of a scale is 1:number"));
                    this.invalidateUserInput();
                } else {
                    try {
                        if (ft.parse(scaleParts[0]).intValue() != 1) {
                            throw new ParseException(I18N.tr("The only accepted value on nominator is 1"), 0);
                        }
                        MapStatusBar.this.setUserDefinedScaleDenominator(ft.parse(scaleParts[1]).longValue());
                        LOGGER.debug((Object)"User scale input accepted..");
                    }
                    catch (ParseException ex) {
                        LOGGER.error((Object)ex.getLocalizedMessage());
                        this.invalidateUserInput();
                    }
                    catch (PropertyVetoException ex) {
                        LOGGER.error((Object)ex.getLocalizedMessage());
                        this.invalidateUserInput();
                    }
                }
            }
            return true;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            return this.verify(input);
        }
    }
}

