/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.orbisgis.core.Services;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.mapeditor.map.mapsManager.MapsManagerPersistence;
import org.orbisgis.mapeditor.map.mapsManager.TreeLeafMapElement;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeDiskFolder;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeLocalRoot;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeOwsMapContextFactory;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeRemoteRoot;
import org.orbisgis.mapeditor.map.mapsManager.jobs.ReadStoredMap;
import org.orbisgis.view.background.BackgroundJob;
import org.orbisgis.view.background.BackgroundManager;
import org.orbisgis.view.components.fstree.FileTree;
import org.orbisgis.view.components.fstree.FileTreeModel;
import org.orbisgis.view.components.fstree.TreeNodeFileFactory;
import org.orbisgis.view.components.fstree.TreeNodeFileFactoryManager;
import org.orbisgis.viewapi.edition.EditorManager;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MapsManager
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final I18n I18N = I18nFactory.getI18n(MapsManager.class);
    private FileTree tree;
    private DefaultTreeModel treeModel;
    private MutableTreeNode rootNode = new DefaultMutableTreeNode();
    private TreeNodeRemoteRoot rootRemote;
    private JScrollPane scrollPane;
    private File loadedMap;
    private TreeNodeLocalRoot rootFolder;
    private DataManager dataManager;
    private EditorManager editorManager;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public MapsManager(String mapContextPath, DataManager dataManager, EditorManager editorManager) {
        super(new BorderLayout());
        this.editorManager = editorManager;
        this.dataManager = dataManager;
        this.treeModel = new FileTreeModel((TreeNode)this.rootNode, true);
        this.treeModel.setAsksAllowsChildren(true);
        this.tree = new FileTree((TreeModel)this.treeModel);
        this.tree.setEditable(true);
        this.tree.setShowsRootHandles(true);
        File rootFolderPath = new File(mapContextPath);
        if (!rootFolderPath.exists()) {
            rootFolderPath.mkdirs();
        }
        TreeNodeDiskFolder workspaceFolder = new TreeNodeDiskFolder(rootFolderPath, (TreeNodeFileFactoryManager)this.tree);
        workspaceFolder.setLabel(I18N.tr("default"));
        this.rootFolder = new TreeNodeLocalRoot((TreeNodeFileFactoryManager)this.tree);
        this.rootRemote = new TreeNodeRemoteRoot(dataManager, new File(mapContextPath));
        this.initInternalFactories();
        this.treeModel.insertNodeInto((MutableTreeNode)((Object)this.rootFolder), this.rootNode, this.rootNode.getChildCount());
        this.treeModel.insertNodeInto((MutableTreeNode)((Object)workspaceFolder), (MutableTreeNode)((Object)this.rootFolder), this.rootFolder.getChildCount());
        this.treeModel.insertNodeInto((MutableTreeNode)((Object)this.rootRemote), this.rootNode, this.rootNode.getChildCount());
        this.tree.setRootVisible(false);
        this.scrollPane = new JScrollPane((Component)this.tree);
        JLabel title = new JLabel(I18N.tr("Maps manager"));
        title.addMouseListener(new MouseAdapter(){});
        this.add((Component)title, "North");
        this.add((Component)this.scrollPane, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void setMapsManagerPersistence(MapsManagerPersistence mapsManagerPersistence) {
        this.rootRemote.setMapsManagerPersistence(mapsManagerPersistence);
        this.rootFolder.setMapsManagerPersistence(mapsManagerPersistence);
    }

    public TreeNodeFileFactoryManager getFactoryManager() {
        return this.tree;
    }

    public void updateDiskTree() {
        this.rootFolder.updateTree();
        this.applyLoadedMapHint();
    }

    private List<TreeLeafMapElement> getAllMapElements(TreeNode parentNode) {
        ArrayList<TreeLeafMapElement> mapElements = new ArrayList<TreeLeafMapElement>();
        if (!parentNode.isLeaf()) {
            for (int childIndex = 0; childIndex < parentNode.getChildCount(); ++childIndex) {
                TreeNode nodeElement = parentNode.getChildAt(childIndex);
                if (nodeElement instanceof TreeLeafMapElement) {
                    mapElements.add((TreeLeafMapElement)((Object)nodeElement));
                    continue;
                }
                mapElements.addAll(this.getAllMapElements(nodeElement));
            }
        }
        return mapElements;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.initialized.getAndSet(true)) {
            this.rootFolder.updateTree();
            this.tree.expandPath(new TreePath(new Object[]{this.rootNode, this.rootFolder}));
            this.tree.expandPath(new TreePath(new Object[]{this.rootNode, this.rootRemote}));
            this.updateMapsTitle();
            this.applyLoadedMapHint();
        }
    }

    private void updateMapsTitle() {
        BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
        bm.nonBlockingBackgroundOperation((BackgroundJob)new ReadStoredMap(this.getAllMapElements((TreeNode)((Object)this.rootFolder))));
    }

    private void initInternalFactories() {
        this.tree.addFactory("ows", (TreeNodeFileFactory)new TreeNodeOwsMapContextFactory(this.dataManager, this.editorManager));
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setServerList(List<String> mapCatalogServers) {
        this.rootRemote.setServerList(mapCatalogServers);
    }

    public List<String> getServerList() {
        return this.rootRemote.getServerList();
    }

    public void setLoadedMap(File loadedMap) {
        this.loadedMap = loadedMap;
        this.applyLoadedMapHint();
    }

    private void applyLoadedMapHint() {
        if (this.loadedMap != null) {
            List<TreeLeafMapElement> mapElements = this.getAllMapElements((TreeNode)((Object)this.rootFolder));
            for (TreeLeafMapElement mapEl : mapElements) {
                if (mapEl.getFilePath().equals(this.loadedMap)) {
                    mapEl.setLoaded(true);
                    continue;
                }
                mapEl.setLoaded(false);
            }
        }
    }

    public Dimension getMinimalComponentDimension() {
        Dimension panel = this.getPreferredSize();
        Dimension treeDim = this.tree.getPreferredSize();
        JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
        if (scrollBar != null && scrollBar.isVisible()) {
            return new Dimension(panel.width + scrollBar.getWidth(), treeDim.height + this.getMinimumSize().height);
        }
        return new Dimension(panel.width, treeDim.height + this.getMinimumSize().height);
    }
}

