/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.orbisgis.viewapi.docking.DockingPanelLayout;
import org.orbisgis.viewapi.util.PropertyHost;
import org.orbisgis.viewapi.util.XElement;

public class MapsManagerPersistence
implements DockingPanelLayout,
Serializable,
PropertyHost {
    private static final long serialVersionUID = 2L;
    private static final String ORBISGIS_MAPCATALOG_SERVER = "http://services.orbisgis.org/map";
    public static final String PROP_SERVER_URI_LIST = "mapCatalogUrlList";
    public static final String PROP_FOLDER_LIST = "mapCatalogUrlList";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private List<String> mapCatalogUrlList = new ArrayList<String>();
    private List<String> mapCatalogFolderList = new ArrayList<String>();
    private static final String URL_LIST_NODE = "mapCatalogUrlList";
    private static final String URL_NODE = "mapcatalog";
    private static final String URL_NODE_PROPERTY = "url";
    private static final String FOLDER_LIST_NODE = "mapCatalogFolderList";
    private static final String FOLDER_NODE = "mapcatalog";
    private static final String FOLDER_NODE_PROPERTY = "path";

    public void setMapCatalogUrlList(List<String> urlList) {
        List<String> oldList = this.mapCatalogUrlList;
        this.mapCatalogUrlList = new ArrayList<String>(urlList);
        if (this.mapCatalogUrlList.isEmpty()) {
            this.mapCatalogUrlList.add(ORBISGIS_MAPCATALOG_SERVER);
        }
        this.propertyChangeSupport.firePropertyChange("mapCatalogUrlList", oldList, this.getMapCatalogUrlList());
    }

    public List<String> getMapCatalogUrlList() {
        return Collections.unmodifiableList(this.mapCatalogUrlList);
    }

    public List<String> getMapCatalogFolderList() {
        return this.mapCatalogFolderList;
    }

    public void setMapCatalogFolderList(List<String> mapCatalogFolderList) {
        List<String> oldList = this.mapCatalogFolderList;
        this.mapCatalogFolderList = mapCatalogFolderList;
        this.propertyChangeSupport.firePropertyChange("mapCatalogUrlList", oldList, mapCatalogFolderList);
    }

    public void writeStream(DataOutputStream out) throws IOException {
        out.writeLong(2L);
        out.writeInt(this.mapCatalogUrlList.size());
        for (String mcUrl : this.mapCatalogUrlList) {
            out.writeUTF(mcUrl);
        }
        out.writeInt(this.mapCatalogFolderList.size());
        for (String mcFolder : this.mapCatalogFolderList) {
            out.writeUTF(mcFolder);
        }
    }

    public void readStream(DataInputStream in) throws IOException {
        long version = in.readLong();
        if (version >= 1L) {
            int size;
            ArrayList<String> urlList = new ArrayList<String>();
            if (version == 2L) {
                size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    urlList.add(in.readUTF());
                }
            }
            this.setMapCatalogUrlList(urlList);
            if (version >= 2L) {
                size = in.readInt();
                ArrayList<String> folderList = new ArrayList<String>();
                for (int i = 0; i < size; ++i) {
                    folderList.add(in.readUTF());
                }
                this.setMapCatalogFolderList(folderList);
            }
        }
    }

    public void writeXML(XElement element) {
        XElement urlList = element.addElement("mapCatalogUrlList");
        urlList.addLong("serialVersionUID", 2L);
        for (String mcUrl : this.mapCatalogUrlList) {
            urlList.addElement("mapcatalog").addString(URL_NODE_PROPERTY, mcUrl);
        }
        XElement pathList = element.addElement(FOLDER_LIST_NODE);
        for (String mcUrl : this.mapCatalogFolderList) {
            pathList.addElement("mapcatalog").addString(FOLDER_NODE_PROPERTY, mcUrl);
        }
    }

    public void readXML(XElement element) {
        XElement managerNode = element.getElement("mapCatalogUrlList");
        long version = managerNode.getLong("serialVersionUID");
        ArrayList<String> urlList = new ArrayList<String>();
        if (version >= 1L) {
            for (XElement map : managerNode.children()) {
                if (!map.getName().equals("mapcatalog")) continue;
                urlList.add(map.getString(URL_NODE_PROPERTY));
            }
            if (version >= 2L) {
                ArrayList<String> folderList = new ArrayList<String>();
                XElement folderNode = element.getElement(FOLDER_LIST_NODE);
                for (XElement map : folderNode.children()) {
                    if (!map.getName().equals("mapcatalog")) continue;
                    folderList.add(map.getString(FOLDER_NODE_PROPERTY));
                }
                this.setMapCatalogFolderList(folderList);
            }
        }
        this.setMapCatalogUrlList(urlList);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(prop, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(prop, listener);
    }
}

