/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.orbisgis.coremap.layerModel.mapcatalog.RemoteCommons;
import org.orbisgis.coremap.layerModel.mapcatalog.RemoteMapContext;
import org.orbisgis.mapeditor.map.TransferableMap;
import org.orbisgis.mapeditorapi.MapElement;
import org.orbisgis.view.components.fstree.TransferableFileContent;
import org.orbisgis.view.edition.TransferableEditableElement;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TransferableRemoteMap
extends TransferableMap {
    private static final Logger LOGGER = Logger.getLogger(TransferableRemoteMap.class);
    private static final I18n I18N = I18nFactory.getI18n(TransferableRemoteMap.class);
    private final RemoteMapContext remoteMap;
    private final File mapContextFolder;

    public TransferableRemoteMap(RemoteMapContext remoteMap, File mapContextFolder) {
        this.remoteMap = remoteMap;
        this.mapContextFolder = mapContextFolder;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor df) {
        return super.isDataFlavorSupported(df) || df.equals(TransferableFileContent.FILE_CONTENT_FLAVOR);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = super.getTransferDataFlavors();
        DataFlavor[] extendedFlavors = Arrays.copyOf(flavors, flavors.length + 1);
        extendedFlavors[extendedFlavors.length - 1] = TransferableFileContent.FILE_CONTENT_FLAVOR;
        return extendedFlavors;
    }

    @Override
    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException {
        if (df.equals(TransferableMap.mapFlavor) || df.equals(TransferableEditableElement.editableElementFlavor)) {
            if (!this.mapContextFolder.exists()) {
                this.mapContextFolder.mkdir();
            }
            File mapContextFile = new File(this.mapContextFolder, this.remoteMap.getDescription().getDefaultTitle() + "." + this.remoteMap.getFileExtension());
            try {
                MapElement mapElement = new MapElement(this.remoteMap.getMapContext(), mapContextFile);
                mapElement.setModified(true);
                return new MapElement[]{mapElement};
            }
            catch (IOException ex) {
                LOGGER.error((Object)I18N.tr("Error while downloading the map content"), (Throwable)ex);
                return ex;
            }
        }
        if (df.equals(TransferableFileContent.FILE_CONTENT_FLAVOR)) {
            try {
                HttpURLConnection connection = this.remoteMap.getMapContent();
                return new ReaderWithName(connection.getInputStream(), RemoteCommons.getConnectionCharset((HttpURLConnection)connection), this.remoteMap);
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    private static class ReaderWithName
    extends InputStreamReader
    implements TransferableFileContent {
        private RemoteMapContext remoteMapContext;

        public ReaderWithName(InputStream inputStream, String encoding, RemoteMapContext remoteMapContext) throws UnsupportedEncodingException, IOException {
            super(inputStream, encoding);
            this.remoteMapContext = remoteMapContext;
        }

        public String getFileNameHint() {
            return this.remoteMapContext.getDescription().getDefaultTitle() + "." + this.remoteMapContext.getFileExtension();
        }
    }
}

