/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.coremap.layerModel.LayerException;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.layerModel.OwsMapContext;
import org.orbisgis.coremap.renderer.se.common.Description;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.mapsManager.TreeLeafMapElement;
import org.orbisgis.mapeditorapi.MapElement;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.view.components.fstree.TreeNodeCustomIcon;
import org.orbisgis.viewapi.edition.EditorManager;
import org.orbisgis.viewapi.util.MenuCommonFunctions;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class TreeLeafMapContextFile
extends TreeLeafMapElement
implements TreeNodeCustomIcon {
    private static final Logger LOGGER = Logger.getLogger(TreeLeafMapContextFile.class);
    private static final I18n I18N = I18nFactory.getI18n(TreeLeafMapContextFile.class);

    public TreeLeafMapContextFile(File mapContextFilePath, DataManager dataManager, EditorManager editorManager) {
        super(mapContextFilePath, dataManager, editorManager);
        this.setLabel(FilenameUtils.getBaseName((String)mapContextFilePath.getName()));
        this.setEditable(false);
    }

    public static boolean createEmptyMapContext(File fileName, DataManager dataManager) {
        OwsMapContext emptyMapContext = new OwsMapContext(dataManager);
        try {
            emptyMapContext.open(null);
            Description mapDescription = new Description();
            mapDescription.addTitle(Locale.getDefault(), FilenameUtils.getBaseName((String)fileName.getName()));
            emptyMapContext.setDescription(mapDescription);
            emptyMapContext.close(null);
            emptyMapContext.write((OutputStream)new FileOutputStream(fileName));
        }
        catch (FileNotFoundException ex) {
            LOGGER.error((Object)I18N.tr("Map creation failed"), (Throwable)ex);
            return false;
        }
        catch (LayerException ex) {
            LOGGER.error((Object)I18N.tr("Map creation failed"), (Throwable)ex);
            return false;
        }
        return true;
    }

    public void onDeleteFile() {
        if (this.getFilePath().exists()) {
            int result = JOptionPane.showConfirmDialog(UIFactory.getMainFrame(), I18N.tr("Are you sure you want to delete permanently the selected files ?"), I18N.tr("Remove the files"), 0, 2);
            if (result == 0) {
                try {
                    if (!this.getFilePath().delete()) {
                        LOGGER.error((Object)I18N.tr("Cannot remove the file"));
                    }
                }
                catch (SecurityException ex) {
                    LOGGER.error((Object)I18N.tr("Cannot remove the file {0}", (Object)this.getFilePath().getName()), (Throwable)ex);
                }
            } else {
                return;
            }
        }
        this.model.removeNodeFromParent((MutableTreeNode)((Object)this));
    }

    @Override
    public void feedPopupMenu(JPopupMenu menu) {
        super.feedPopupMenu(menu);
        if (!this.isLoaded()) {
            JMenuItem folderRemove = new JMenuItem(I18N.tr("Delete"), MapEditorIcons.getIcon("remove"));
            folderRemove.setToolTipText(I18N.tr("Remove permanently the map"));
            folderRemove.setActionCommand("delete");
            folderRemove.addActionListener(EventHandler.create(ActionListener.class, (Object)this, "onDeleteFile"));
            MenuCommonFunctions.updateOrInsertMenuItem((JPopupMenu)menu, (JMenuItem)folderRemove);
        }
    }

    public void setUserObject(Object o) {
    }

    public ImageIcon getLeafIcon() {
        return MapEditorIcons.getIcon("map");
    }

    public ImageIcon getClosedIcon() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public ImageIcon getOpenIcon() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private OwsMapContext getMapContext(DataManager dataManager) throws FileNotFoundException {
        OwsMapContext mapContext = new OwsMapContext(dataManager);
        mapContext.read((InputStream)new FileInputStream(this.getFilePath()));
        mapContext.setLocation(this.getFilePath().toURI());
        return mapContext;
    }

    @Override
    public MapElement getMapElement(ProgressMonitor pm, DataManager dataManager) {
        try {
            MapElement mapElement = new MapElement((MapContext)this.getMapContext(dataManager), this.getFilePath());
            return mapElement;
        }
        catch (FileNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

