/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import org.orbisgis.core.Services;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.mapeditor.map.TransferableMap;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.jobs.ReadMapContextJob;
import org.orbisgis.mapeditorapi.MapElement;
import org.orbisgis.progress.NullProgressMonitor;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.view.background.BackgroundJob;
import org.orbisgis.view.background.BackgroundManager;
import org.orbisgis.view.components.fstree.AbstractTreeNodeLeaf;
import org.orbisgis.view.components.fstree.DragTreeNode;
import org.orbisgis.view.components.fstree.PopupTreeNode;
import org.orbisgis.view.components.fstree.TransferableList;
import org.orbisgis.view.components.fstree.TransferableNodePaths;
import org.orbisgis.view.components.fstree.TreeNodeCustomLabel;
import org.orbisgis.view.components.fstree.TreeNodePath;
import org.orbisgis.viewapi.edition.EditorManager;
import org.orbisgis.viewapi.util.MenuCommonFunctions;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class TreeLeafMapElement
extends AbstractTreeNodeLeaf
implements PopupTreeNode,
TreeNodeCustomLabel,
DragTreeNode,
TreeNodePath {
    private static final I18n I18N = I18nFactory.getI18n(TreeLeafMapElement.class);
    private boolean loaded = false;
    private File filePath;
    private DataManager dataManager;
    private EditorManager editorManager;

    public TreeLeafMapElement(File filePath, DataManager dataManager, EditorManager editorManager) {
        this.filePath = filePath;
        this.dataManager = dataManager;
        this.editorManager = editorManager;
    }

    public File getFilePath() {
        if (this.parent instanceof TreeNodePath) {
            TreeNodePath parentFolder = (TreeNodePath)this.parent;
            return new File(parentFolder.getFilePath(), this.filePath.getName());
        }
        return this.filePath;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        if (this.loaded != loaded) {
            this.loaded = loaded;
            this.model.nodeChanged((TreeNode)((Object)this));
        }
    }

    public abstract MapElement getMapElement(ProgressMonitor var1, DataManager var2);

    public void onOpenMap() {
        BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
        bm.backgroundOperation((BackgroundJob)new ReadMapContextJob(this.getMapElement((ProgressMonitor)new NullProgressMonitor(), this.dataManager), this.editorManager));
    }

    public void feedPopupMenu(JPopupMenu menu) {
        if (!this.loaded) {
            JMenuItem openMapItem = new JMenuItem(I18N.tr("Open the map"), MapEditorIcons.getIcon("open_map"));
            openMapItem.addActionListener(EventHandler.create(ActionListener.class, (Object)this, "onOpenMap"));
            openMapItem.setActionCommand("TreeNodeMapElement:OpenMap");
            MenuCommonFunctions.updateOrInsertMenuItem((JPopupMenu)menu, (JMenuItem)openMapItem);
        }
    }

    public boolean applyCustomLabel(JLabel label) {
        if (this.loaded) {
            Font textFont = label.getFont();
            label.setFont(textFont.deriveFont(1));
            return true;
        }
        return false;
    }

    public boolean completeTransferable(TransferableList transferable) {
        transferable.addTransferable((Transferable)new TransferableNodePaths((TreeNodePath)this));
        if (!transferable.isDataFlavorSupported(TransferableMap.mapFlavor)) {
            transferable.addTransferable((Transferable)new TransferableMap(this.getMapElement((ProgressMonitor)new NullProgressMonitor(), this.dataManager)));
        }
        return true;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }
}

