/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.mapsManager.MapsManagerPersistence;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeUserFolder;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.UIPanel;
import org.orbisgis.sif.components.OpenFolderPanel;
import org.orbisgis.view.components.fstree.AbstractTreeNodeContainer;
import org.orbisgis.view.components.fstree.PopupTreeNode;
import org.orbisgis.view.components.fstree.TreeNodeCustomIcon;
import org.orbisgis.view.components.fstree.TreeNodeFileFactoryManager;
import org.orbisgis.view.components.fstree.TreeNodeFolder;
import org.orbisgis.viewapi.util.MenuCommonFunctions;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TreeNodeLocalRoot
extends AbstractTreeNodeContainer
implements PopupTreeNode,
TreeNodeCustomIcon {
    private static final I18n I18N = I18nFactory.getI18n(TreeNodeLocalRoot.class);
    private static final Logger LOGGER = Logger.getLogger(TreeNodeLocalRoot.class);
    private MapsManagerPersistence mapsManagerPersistence;
    private TreeNodeFileFactoryManager factoryManager;

    public TreeNodeLocalRoot(TreeNodeFileFactoryManager factoryManager) {
        this.setLabel(I18N.tr("Local"));
        this.setEditable(false);
        this.factoryManager = factoryManager;
    }

    public void setMapsManagerPersistence(MapsManagerPersistence mapsManagerPersistence) {
        this.mapsManagerPersistence = mapsManagerPersistence;
        mapsManagerPersistence.addPropertyChangeListener("mapCatalogUrlList", EventHandler.create(PropertyChangeListener.class, (Object)this, "onFolderListPropertyChange", "newValue"));
        this.onFolderListPropertyChange(mapsManagerPersistence.getMapCatalogFolderList());
    }

    public void onFolderListPropertyChange(List<String> userMapFolders) {
        ArrayList<TreeNodeFolder> userRootFolders = new ArrayList<TreeNodeFolder>(this.getChildCount());
        for (TreeNode node : this.children) {
            if (!(node instanceof TreeNodeUserFolder)) continue;
            userRootFolders.add((TreeNodeFolder)node);
        }
        HashMap<File, TreeNodeFolder> currentShownUserFolder = new HashMap<File, TreeNodeFolder>(userRootFolders.size());
        for (TreeNodeFolder treeNodeFolder : userRootFolders) {
            currentShownUserFolder.put(treeNodeFolder.getFilePath(), treeNodeFolder);
        }
        for (String userMapFolder : userMapFolders) {
            File userMapPath = new File(userMapFolder);
            if (currentShownUserFolder.containsKey(userMapPath)) {
                currentShownUserFolder.remove(userMapPath);
                continue;
            }
            if (!userMapPath.exists()) continue;
            TreeNodeUserFolder subDir = new TreeNodeUserFolder(userMapPath, this.factoryManager, this.mapsManagerPersistence);
            subDir.setEditable(false);
            this.model.insertNodeInto((MutableTreeNode)((Object)subDir), (MutableTreeNode)((Object)this), 0);
            subDir.updateTree();
        }
        for (TreeNodeFolder removeFolder : currentShownUserFolder.values()) {
            this.model.removeNodeFromParent((MutableTreeNode)removeFolder);
        }
    }

    public void remove(MutableTreeNode mtn) {
        this.remove(this.getIndex(mtn));
    }

    public void setUserObject(Object o) {
    }

    public void onAddFolder() {
        OpenFolderPanel openDialog = new OpenFolderPanel("MapsManagerLinkLocalFolder", I18N.tr("Select a folder to link with map manager"));
        openDialog.setSingleSelection(true);
        openDialog.loadState();
        if (UIFactory.showDialog((UIPanel)openDialog, (boolean)true, (boolean)true)) {
            File folder = openDialog.getSelectedFile();
            ArrayList<String> userFolders = new ArrayList<String>(this.mapsManagerPersistence.getMapCatalogFolderList());
            if (!userFolders.contains(folder.getAbsolutePath())) {
                userFolders.add(folder.getAbsolutePath());
                this.mapsManagerPersistence.setMapCatalogFolderList(userFolders);
            }
        }
    }

    public void updateTree() {
        for (TreeNode node : this.children) {
            if (!(node instanceof TreeNodeFolder)) continue;
            ((TreeNodeFolder)node).updateTree();
        }
    }

    public void feedPopupMenu(JPopupMenu menu) {
        JMenuItem addServer = new JMenuItem(I18N.tr("Add Map Catalog folder"), MapEditorIcons.getIcon("folder_add"));
        addServer.setToolTipText(I18N.tr("Add link to a local folder"));
        addServer.setActionCommand("TreeNodeLocalRoot:addFolder");
        addServer.addActionListener(EventHandler.create(ActionListener.class, (Object)this, "onAddFolder"));
        MenuCommonFunctions.updateOrInsertMenuItem((JPopupMenu)menu, (JMenuItem)addServer);
    }

    public ImageIcon getLeafIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ImageIcon getClosedIcon() {
        return MapEditorIcons.getIcon("folder");
    }

    public ImageIcon getOpenIcon() {
        return MapEditorIcons.getIcon("folder_open");
    }
}

