/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.orbisgis.core.Services;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.coremap.layerModel.mapcatalog.Workspace;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeBusy;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeWorkspace;
import org.orbisgis.mapeditor.map.mapsManager.jobs.DownloadWorkspaces;
import org.orbisgis.view.background.BackgroundJob;
import org.orbisgis.view.background.BackgroundManager;
import org.orbisgis.view.components.fstree.AbstractTreeNodeContainer;
import org.orbisgis.view.components.fstree.PopupTreeNode;
import org.orbisgis.view.components.fstree.TreeNodeCustomIcon;
import org.orbisgis.viewapi.util.MenuCommonFunctions;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TreeNodeMapCatalogServer
extends AbstractTreeNodeContainer
implements TreeNodeCustomIcon,
PopupTreeNode {
    URL serverUrl;
    private static final Logger LOGGER = Logger.getLogger(TreeNodeMapCatalogServer.class);
    AtomicBoolean downloaded = new AtomicBoolean(false);
    private SERVER_STATUS serverStatus = SERVER_STATUS.DISCONNECTED;
    private static final I18n I18N = I18nFactory.getI18n(TreeNodeMapCatalogServer.class);
    private DataManager dataManager;
    private File mapsFolder;

    public TreeNodeMapCatalogServer(URL serverUrl, DataManager dataManager, File mapsFolder) {
        this.setServerUrl(serverUrl);
        this.dataManager = dataManager;
        this.mapsFolder = mapsFolder;
    }

    private void setServerUrl(URL serverUrl) {
        this.serverUrl = serverUrl;
        this.setLabel(serverUrl.toExternalForm());
    }

    public SERVER_STATUS getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(SERVER_STATUS serverStatus) {
        this.serverStatus = serverStatus;
        this.model.nodeChanged((TreeNode)((Object)this));
    }

    public void addWorkspace(Workspace newWorkspace) {
        this.model.insertNodeInto((MutableTreeNode)((Object)new TreeNodeWorkspace(newWorkspace)), (MutableTreeNode)((Object)this), this.getChildCount());
    }

    public void setUserObject(Object o) {
        String userUri = o.toString();
        try {
            this.setServerUrl(new URL(userUri));
            this.update();
        }
        catch (MalformedURLException ex) {
            LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public void update() {
        ArrayList childrenToRemove = new ArrayList(this.children);
        for (MutableTreeNode child : childrenToRemove) {
            this.model.removeNodeFromParent(child);
        }
        TreeNodeBusy busyNode = new TreeNodeBusy();
        this.model.insertNodeInto((MutableTreeNode)((Object)busyNode), (MutableTreeNode)((Object)this), 0);
        BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
        bm.nonBlockingBackgroundOperation((BackgroundJob)new DownloadWorkspaces(this, busyNode, this.dataManager, this.mapsFolder));
    }

    public int getChildCount() {
        if (!this.downloaded.getAndSet(true)) {
            this.update();
        }
        return super.getChildCount();
    }

    private ImageIcon getServerIcon() {
        switch (this.serverStatus) {
            case DISCONNECTED: {
                return MapEditorIcons.getIcon("world_disconnected");
            }
            case CONNECTED: {
                return MapEditorIcons.getIcon("world_connected");
            }
        }
        return MapEditorIcons.getIcon("connection_error");
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    public ImageIcon getLeafIcon() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public ImageIcon getClosedIcon() {
        return this.getServerIcon();
    }

    public ImageIcon getOpenIcon() {
        return this.getServerIcon();
    }

    public void onDeleteServer() {
        this.model.removeNodeFromParent((MutableTreeNode)((Object)this));
    }

    public void feedPopupMenu(JPopupMenu menu) {
        for (Component component : menu.getComponents()) {
            JMenuItem item;
            if (!(component instanceof JMenuItem) || !(item = (JMenuItem)component).getActionCommand().equals("rename")) continue;
            item.setText(I18N.tr("Edit the URL"));
        }
        JMenuItem folderRemove = new JMenuItem(I18N.tr("Delete"), MapEditorIcons.getIcon("world_delete"));
        folderRemove.setToolTipText(I18N.tr("Remove this server"));
        folderRemove.setActionCommand("delete");
        folderRemove.addActionListener(EventHandler.create(ActionListener.class, (Object)this, "onDeleteServer"));
        MenuCommonFunctions.updateOrInsertMenuItem((JPopupMenu)menu, (JMenuItem)folderRemove);
        if (this.downloaded.get()) {
            JMenuItem updateMenu = new JMenuItem(I18N.tr("Update"), MapEditorIcons.getIcon("refresh"));
            updateMenu.setToolTipText(I18N.tr("Download the server content"));
            updateMenu.setActionCommand("Update");
            updateMenu.addActionListener(EventHandler.create(ActionListener.class, (Object)this, "update"));
            MenuCommonFunctions.updateOrInsertMenuItem((JPopupMenu)menu, (JMenuItem)updateMenu);
        }
    }

    public static enum SERVER_STATUS {
        DISCONNECTED,
        CONNECTED,
        UNREACHABLE;

    }
}

