/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.mapeditor.map.mapsManager.TreeLeafMapContextFile;
import org.orbisgis.mapeditor.map.mapsManager.TreeLeafMapElement;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.view.components.fstree.TreeNodeFileFactory;
import org.orbisgis.view.components.fstree.TreeNodeFolder;
import org.orbisgis.viewapi.edition.EditorManager;
import org.orbisgis.viewapi.util.MenuCommonFunctions;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TreeNodeOwsMapContextFactory
implements TreeNodeFileFactory {
    private static final I18n I18N = I18nFactory.getI18n(TreeNodeOwsMapContextFactory.class);
    private static final String ACTION_ADD_OWS_MAP = "TreeNodeOwsMapContextFactory:NewEmptyMap";
    private static final Logger LOGGER = Logger.getLogger(TreeNodeOwsMapContextFactory.class);
    private DataManager dataManager;
    private EditorManager editorManager;

    public TreeNodeOwsMapContextFactory(DataManager dataManager, EditorManager editorManager) {
        this.dataManager = dataManager;
        this.editorManager = editorManager;
    }

    public TreeLeafMapElement create(File filePath) {
        return new TreeLeafMapContextFile(filePath, this.dataManager, this.editorManager);
    }

    private static void onCreateEmptyMap(TreeNodeFolder folderNode, DataManager dataManager) {
        File folderPath = folderNode.getFilePath();
        String folderName = JOptionPane.showInputDialog(UIFactory.getMainFrame(), I18N.tr("Enter the Map file name"), I18N.tr("MyMap"));
        if (folderName != null) {
            if (!folderName.endsWith(".ows")) {
                folderName = folderName + ".ows";
            }
            File mapContextFile = new File(folderPath, folderName);
            try {
                if (mapContextFile.exists()) {
                    LOGGER.error((Object)I18N.tr("The specified file name already exist"));
                    return;
                }
                if (TreeLeafMapContextFile.createEmptyMapContext(mapContextFile, dataManager)) {
                    folderNode.updateTree();
                }
            }
            catch (Throwable ex) {
                LOGGER.error((Object)I18N.tr("The map creation has failed"), ex);
            }
        }
    }

    public void feedTreeNodePopupMenu(MutableTreeNode node, JPopupMenu menu) {
        if (node instanceof TreeNodeFolder) {
            TreeNodeFolder folderNode = (TreeNodeFolder)node;
            JMenuItem createEmptyMap = new JMenuItem(I18N.tr("New empty map"));
            createEmptyMap.setActionCommand(ACTION_ADD_OWS_MAP);
            createEmptyMap.setToolTipText(I18N.tr("Create a new OWS Map in this folder"));
            createEmptyMap.addActionListener(new CreateEmptyMap(folderNode, this.dataManager));
            MenuCommonFunctions.updateOrInsertMenuItem((JPopupMenu)menu, (JMenuItem)createEmptyMap);
        }
    }

    private static class CreateEmptyMap
    implements ActionListener {
        TreeNodeFolder folderNode;
        DataManager dataManager;

        public CreateEmptyMap(TreeNodeFolder folderNode, DataManager dataManager) {
            this.folderNode = folderNode;
            this.dataManager = dataManager;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TreeNodeOwsMapContextFactory.onCreateEmptyMap(this.folderNode, this.dataManager);
        }
    }
}

