/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;
import org.orbisgis.core.Services;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.layerModel.mapcatalog.RemoteMapContext;
import org.orbisgis.coremap.renderer.se.common.Description;
import org.orbisgis.mapeditor.map.TransferableMap;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.mapsManager.TransferableRemoteMap;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeWorkspace;
import org.orbisgis.mapeditor.map.mapsManager.jobs.DeleteRemoteMapContext;
import org.orbisgis.mapeditor.map.mapsManager.jobs.UploadMapContext;
import org.orbisgis.mapeditorapi.MapElement;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.view.background.BackgroundJob;
import org.orbisgis.view.background.BackgroundManager;
import org.orbisgis.view.components.fstree.AbstractTreeNodeLeaf;
import org.orbisgis.view.components.fstree.DragTreeNode;
import org.orbisgis.view.components.fstree.DropDestinationTreeNode;
import org.orbisgis.view.components.fstree.PopupTreeNode;
import org.orbisgis.view.components.fstree.TransferableList;
import org.orbisgis.view.components.fstree.TreeNodeCustomIcon;
import org.orbisgis.viewapi.util.MenuCommonFunctions;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TreeNodeRemoteMap
extends AbstractTreeNodeLeaf
implements TreeNodeCustomIcon,
DragTreeNode,
DropDestinationTreeNode,
PopupTreeNode {
    private RemoteMapContext remoteMapConnection;
    private static final Logger LOGGER = Logger.getLogger(TreeNodeRemoteMap.class);
    private static final I18n I18N = I18nFactory.getI18n(TreeNodeRemoteMap.class);

    public TreeNodeRemoteMap(RemoteMapContext remoteMapConnection) {
        this.remoteMapConnection = remoteMapConnection;
        Description description = remoteMapConnection.getDescription();
        if (description != null && description.getDefaultTitle() != null && !description.getDefaultTitle().isEmpty()) {
            this.setLabel(description.getDefaultTitle());
            this.setToolTipText(description.getDefaultAbstract());
        } else {
            this.setLabel("Unnamed");
        }
        this.setEditable(false);
    }

    public RemoteMapContext getRemoteMapContext() {
        return this.remoteMapConnection;
    }

    public void setUserObject(Object o) {
    }

    public ImageIcon getLeafIcon() {
        return MapEditorIcons.getIcon("map");
    }

    public ImageIcon getClosedIcon() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public ImageIcon getOpenIcon() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean completeTransferable(TransferableList transferable) {
        transferable.addTransferable((Transferable)new TransferableRemoteMap(this.remoteMapConnection, this.remoteMapConnection.getcParams().getMapFolderCache()));
        return true;
    }

    public boolean canImport(TransferHandler.TransferSupport ts) {
        return ts.isDataFlavorSupported(TransferableMap.mapFlavor);
    }

    public boolean importData(TransferHandler.TransferSupport ts) {
        try {
            Object mapObj = ts.getTransferable().getTransferData(TransferableMap.mapFlavor);
            if (mapObj instanceof MapElement[]) {
                int response = JOptionPane.showConfirmDialog(UIFactory.getMainFrame(), I18N.tr("Are you sure you want to replace the remote map context ?"), I18N.tr("Overwrite map context confirmation"), 0);
                if (response == 0) {
                    MapElement[] mapArray = (MapElement[])mapObj;
                    if (mapArray.length != 0) {
                        MapContext mapToUpload = mapArray[0].getMapContext();
                        BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
                        bm.nonBlockingBackgroundOperation((BackgroundJob)new UploadMapContext(mapToUpload, (TreeNodeWorkspace)((Object)this.getParent()), this.remoteMapConnection.getId()));
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (UnsupportedFlavorException ex) {
            LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            return false;
        }
    }

    public void onDeleteMap() {
        BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
        bm.nonBlockingBackgroundOperation((BackgroundJob)new DeleteRemoteMapContext(this));
    }

    public void feedPopupMenu(JPopupMenu menu) {
        JMenuItem remove = new JMenuItem(I18N.tr("Delete"), MapEditorIcons.getIcon("remove"));
        remove.setToolTipText(I18N.tr("Remove this map on the server"));
        remove.setActionCommand("delete");
        remove.addActionListener(EventHandler.create(ActionListener.class, (Object)this, "onDeleteMap"));
        MenuCommonFunctions.updateOrInsertMenuItem((JPopupMenu)menu, (JMenuItem)remove);
    }
}

