/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.mapsManager.MapsManagerPersistence;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeMapCatalogServer;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.view.components.fstree.AbstractTreeNodeContainer;
import org.orbisgis.view.components.fstree.PopupTreeNode;
import org.orbisgis.view.components.fstree.TreeNodeCustomIcon;
import org.orbisgis.viewapi.util.MenuCommonFunctions;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TreeNodeRemoteRoot
extends AbstractTreeNodeContainer
implements PopupTreeNode,
TreeNodeCustomIcon {
    private static final I18n I18N = I18nFactory.getI18n(TreeNodeRemoteRoot.class);
    private static final Logger LOGGER = Logger.getLogger(TreeNodeRemoteRoot.class);
    private List<String> serverList;
    private MapsManagerPersistence mapsManagerPersistence;
    private AtomicBoolean onUpdateSerialisation = new AtomicBoolean(false);
    private DataManager dataManager;
    private File mapsFolder;

    public TreeNodeRemoteRoot(DataManager dataManager, File mapsFolder) {
        this.setLabel(I18N.tr("Remote"));
        this.setEditable(false);
        this.dataManager = dataManager;
        this.mapsFolder = mapsFolder;
    }

    public void setMapsManagerPersistence(MapsManagerPersistence mapsManagerPersistence) {
        this.mapsManagerPersistence = mapsManagerPersistence;
        mapsManagerPersistence.addPropertyChangeListener("mapCatalogUrlList", EventHandler.create(PropertyChangeListener.class, (Object)this, "onMapServerListUpdate"));
        this.onMapServerListUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerList() {
        if (this.mapsManagerPersistence != null && this.serverList != null) {
            this.onUpdateSerialisation.set(true);
            try {
                this.mapsManagerPersistence.setMapCatalogUrlList(this.serverList);
            }
            finally {
                this.onUpdateSerialisation.set(false);
            }
        }
    }

    public void onMapServerListUpdate() {
        if (!this.onUpdateSerialisation.get()) {
            this.setServerList(this.mapsManagerPersistence.getMapCatalogUrlList());
        }
    }

    public void insert(MutableTreeNode mtn, int i) {
        super.insert(mtn, i);
        if (mtn instanceof TreeNodeMapCatalogServer) {
            TreeNodeMapCatalogServer newChild = (TreeNodeMapCatalogServer)((Object)mtn);
            if (this.serverList != null) {
                this.serverList.add(i, newChild.getServerUrl().toExternalForm());
                this.updateServerList();
            }
        }
    }

    public void setServerList(List<String> serverList) {
        for (String serverAddress : serverList) {
            try {
                URL serverUrl = new URL(serverAddress);
                this.model.insertNodeInto((MutableTreeNode)((Object)new TreeNodeMapCatalogServer(serverUrl, this.dataManager, this.mapsFolder)), (MutableTreeNode)((Object)this), this.getChildCount());
            }
            catch (MalformedURLException ex) {
                LOGGER.error((Object)I18N.tr("Cannot load map catalog server {0}", (Object)serverAddress), (Throwable)ex);
            }
        }
        this.serverList = new ArrayList<String>(serverList);
    }

    public List<String> getServerList() {
        return Collections.unmodifiableList(this.serverList);
    }

    public void remove(int i) {
        super.remove(i);
        if (this.serverList != null) {
            this.serverList.remove(i);
            this.updateServerList();
        }
    }

    public void remove(MutableTreeNode mtn) {
        this.remove(this.getIndex(mtn));
    }

    public void setUserObject(Object o) {
    }

    public void onAddServer() {
        String serverURLString = JOptionPane.showInputDialog(UIFactory.getMainFrame(), I18N.tr("Enter the server URL"), "");
        if (serverURLString != null && !serverURLString.isEmpty()) {
            try {
                URL serverURL = new URL(serverURLString);
                this.model.insertNodeInto((MutableTreeNode)((Object)new TreeNodeMapCatalogServer(serverURL, this.dataManager, this.mapsFolder)), (MutableTreeNode)((Object)this), this.getChildCount());
            }
            catch (MalformedURLException ex) {
                LOGGER.error((Object)I18N.tr("You type an incorrect URL {0}", (Object)serverURLString), (Throwable)ex);
            }
        }
    }

    public void feedPopupMenu(JPopupMenu menu) {
        JMenuItem addServer = new JMenuItem(I18N.tr("Add Map Catalog server"), MapEditorIcons.getIcon("world_add"));
        addServer.setToolTipText(I18N.tr("Add a new remote map catalog"));
        addServer.setActionCommand("TreeNodeRemoteRoot:addServer");
        addServer.addActionListener(EventHandler.create(ActionListener.class, (Object)this, "onAddServer"));
        MenuCommonFunctions.updateOrInsertMenuItem((JPopupMenu)menu, (JMenuItem)addServer);
    }

    public ImageIcon getLeafIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ImageIcon getClosedIcon() {
        return MapEditorIcons.getIcon("folder");
    }

    public ImageIcon getOpenIcon() {
        return MapEditorIcons.getIcon("folder_open");
    }
}

