/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;
import org.orbisgis.core.Services;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.layerModel.mapcatalog.RemoteMapContext;
import org.orbisgis.coremap.layerModel.mapcatalog.Workspace;
import org.orbisgis.mapeditor.map.TransferableMap;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeBusy;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeRemoteMap;
import org.orbisgis.mapeditor.map.mapsManager.jobs.DownloadRemoteMapContext;
import org.orbisgis.mapeditor.map.mapsManager.jobs.UploadMapContext;
import org.orbisgis.mapeditorapi.MapElement;
import org.orbisgis.view.background.BackgroundJob;
import org.orbisgis.view.background.BackgroundManager;
import org.orbisgis.view.components.fstree.AbstractTreeNodeContainer;
import org.orbisgis.view.components.fstree.DropDestinationTreeNode;
import org.orbisgis.view.components.fstree.PopupTreeNode;
import org.orbisgis.view.components.fstree.TreeNodeCustomIcon;
import org.orbisgis.viewapi.util.MenuCommonFunctions;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class TreeNodeWorkspace
extends AbstractTreeNodeContainer
implements DropDestinationTreeNode,
PopupTreeNode,
TreeNodeCustomIcon {
    private static final I18n I18N = I18nFactory.getI18n(TreeNodeWorkspace.class);
    private static final Logger LOGGER = Logger.getLogger(TreeNodeWorkspace.class);
    AtomicBoolean downloaded = new AtomicBoolean(false);
    Workspace workspace;

    public TreeNodeWorkspace(Workspace workspace) {
        this.workspace = workspace;
        this.setLabel(workspace.getWorkspaceName());
        this.setEditable(false);
    }

    public void addContext(RemoteMapContext context) {
        this.model.insertNodeInto((MutableTreeNode)((Object)new TreeNodeRemoteMap(context)), (MutableTreeNode)((Object)this), this.getChildCount());
    }

    public void update() {
        ArrayList childrenToRemove = new ArrayList(this.children);
        for (MutableTreeNode child : childrenToRemove) {
            this.model.removeNodeFromParent(child);
        }
        TreeNodeBusy busyNode = new TreeNodeBusy();
        this.model.insertNodeInto((MutableTreeNode)((Object)busyNode), (MutableTreeNode)((Object)this), 0);
        BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
        bm.nonBlockingBackgroundOperation((BackgroundJob)new DownloadRemoteMapContext(this, busyNode));
    }

    public int getChildCount() {
        if (!this.downloaded.getAndSet(true)) {
            this.update();
        }
        return super.getChildCount();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setUserObject(Object o) {
    }

    public boolean canImport(TransferHandler.TransferSupport ts) {
        return ts.isDataFlavorSupported(TransferableMap.mapFlavor);
    }

    public boolean importData(TransferHandler.TransferSupport ts) {
        try {
            Object mapObj = ts.getTransferable().getTransferData(TransferableMap.mapFlavor);
            MapElement[] mapArray = (MapElement[])mapObj;
            if (mapArray.length != 0) {
                MapContext mapToUpload = mapArray[0].getMapContext();
                BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
                bm.nonBlockingBackgroundOperation((BackgroundJob)new UploadMapContext(mapToUpload, this));
            }
            return true;
        }
        catch (UnsupportedFlavorException ex) {
            return false;
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            return false;
        }
    }

    public void feedPopupMenu(JPopupMenu menu) {
        if (this.downloaded.get()) {
            JMenuItem updateMenu = new JMenuItem(I18N.tr("Update"), MapEditorIcons.getIcon("refresh"));
            updateMenu.setToolTipText(I18N.tr("Download the workspace content"));
            updateMenu.setActionCommand("Update");
            updateMenu.addActionListener(EventHandler.create(ActionListener.class, (Object)this, "update"));
            MenuCommonFunctions.updateOrInsertMenuItem((JPopupMenu)menu, (JMenuItem)updateMenu);
        }
    }

    public ImageIcon getLeafIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ImageIcon getClosedIcon() {
        return MapEditorIcons.getIcon("folder");
    }

    public ImageIcon getOpenIcon() {
        return MapEditorIcons.getIcon("folder_open");
    }
}

