/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager.jobs;

import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeRemoteMap;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeWorkspace;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.view.background.BackgroundJob;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DeleteRemoteMapContext
implements BackgroundJob {
    private static final I18n I18N = I18nFactory.getI18n(DeleteRemoteMapContext.class);
    private static final Logger LOGGER = Logger.getLogger(DeleteRemoteMapContext.class);
    private TreeNodeRemoteMap map;

    public DeleteRemoteMapContext(TreeNodeRemoteMap map) {
        this.map = map;
    }

    public void run(ProgressMonitor pm) {
        try {
            this.map.getRemoteMapContext().delete();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeNode parent = DeleteRemoteMapContext.this.map.getParent();
                    if (parent instanceof TreeNodeWorkspace) {
                        TreeNodeWorkspace workspace = (TreeNodeWorkspace)((Object)parent);
                        workspace.update();
                    }
                }
            });
        }
        catch (IOException ex) {
            LOGGER.error((Object)I18N.tr("The map cannot be removed"), (Throwable)ex);
        }
    }

    public String getTaskName() {
        return I18N.tr("Delete the remote map context");
    }
}

