/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager.jobs;

import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.orbisgis.coremap.layerModel.mapcatalog.RemoteMapContext;
import org.orbisgis.coremap.layerModel.mapcatalog.Workspace;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeBusy;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeMapCatalogServer;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeWorkspace;
import org.orbisgis.mapeditor.map.mapsManager.jobs.DownloadWorkspaces;
import org.orbisgis.mapeditor.map.mapsManager.jobs.ReadStoredMap;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.view.background.BackgroundJob;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DownloadRemoteMapContext
implements BackgroundJob {
    private static final I18n I18N = I18nFactory.getI18n(ReadStoredMap.class);
    private TreeNodeWorkspace workspaceNode;
    private TreeNodeBusy treeNodeBusyHint;
    private static final Logger LOGGER = Logger.getLogger(DownloadWorkspaces.class);

    public DownloadRemoteMapContext(TreeNodeWorkspace workspace, TreeNodeBusy treeNodeBusyHint) {
        this.workspaceNode = workspace;
        this.treeNodeBusyHint = treeNodeBusyHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ProgressMonitor pm) {
        Workspace workspace = this.workspaceNode.getWorkspace();
        try {
            this.treeNodeBusyHint.setDoAnimation(true);
            List contexts = workspace.getMapContextList();
            SwingUtilities.invokeLater(new FeedWorkspaceNode(this.workspaceNode, contexts));
        }
        catch (IOException ex) {
            LOGGER.error((Object)I18N.tr("Cannot download the server's contexts of {0}", (Object)workspace.getWorkspaceName()), (Throwable)ex);
            SwingUtilities.invokeLater(new FeedWorkspaceNode(this.workspaceNode, null));
        }
        finally {
            this.treeNodeBusyHint.setDoAnimation(false);
        }
    }

    public String getTaskName() {
        return I18N.tr("Download the context of {0}", (Object)this.workspaceNode);
    }

    private static class FeedWorkspaceNode
    implements Runnable {
        TreeNodeWorkspace workspaceNode;
        List<RemoteMapContext> contexts;

        public FeedWorkspaceNode(TreeNodeWorkspace workspaceNode, List<RemoteMapContext> contexts) {
            this.workspaceNode = workspaceNode;
            this.contexts = contexts;
        }

        @Override
        public void run() {
            if (this.contexts != null) {
                for (RemoteMapContext context : this.contexts) {
                    this.workspaceNode.addContext(context);
                }
            } else {
                TreeNode parent = this.workspaceNode.getParent();
                if (!(parent instanceof TreeNodeMapCatalogServer)) {
                    return;
                }
                TreeNodeMapCatalogServer server = (TreeNodeMapCatalogServer)((Object)parent);
                server.setServerStatus(TreeNodeMapCatalogServer.SERVER_STATUS.UNREACHABLE);
            }
        }
    }
}

