/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager.jobs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.coremap.layerModel.mapcatalog.ConnectionProperties;
import org.orbisgis.coremap.layerModel.mapcatalog.RemoteMapCatalog;
import org.orbisgis.coremap.layerModel.mapcatalog.Workspace;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeBusy;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeMapCatalogServer;
import org.orbisgis.mapeditor.map.mapsManager.jobs.ReadStoredMap;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.view.background.BackgroundJob;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DownloadWorkspaces
implements BackgroundJob {
    private static final I18n I18N = I18nFactory.getI18n(ReadStoredMap.class);
    private TreeNodeMapCatalogServer server;
    private TreeNodeBusy treeNodeBusyHint;
    private static final Logger LOGGER = Logger.getLogger(DownloadWorkspaces.class);
    private DataManager dataManager;
    private File mapsFolder;

    public DownloadWorkspaces(TreeNodeMapCatalogServer server, TreeNodeBusy treeNodeBusyHint, DataManager dataManager, File mapsFolder) {
        this.server = server;
        this.treeNodeBusyHint = treeNodeBusyHint;
        this.dataManager = dataManager;
        this.mapsFolder = mapsFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ProgressMonitor pm) {
        try {
            this.treeNodeBusyHint.setDoAnimation(true);
            ConnectionProperties parameters = new ConnectionProperties(this.server.getServerUrl(), this.dataManager, this.mapsFolder);
            RemoteMapCatalog mapServer = new RemoteMapCatalog(parameters);
            List workspaces = mapServer.getWorkspaces();
            SwingUtilities.invokeLater(new FeedServerNode(this.server, workspaces));
        }
        catch (IOException ex) {
            LOGGER.error((Object)I18N.tr("Cannot download the server's workspaces of {0}", (Object)this.server.getServerUrl().getHost()), (Throwable)ex);
            SwingUtilities.invokeLater(new FeedServerNode(this.server, null));
        }
        finally {
            this.treeNodeBusyHint.setDoAnimation(false);
        }
    }

    public String getTaskName() {
        return I18N.tr("Download the workspaces of {0}", (Object)this.server.getServerUrl().getHost());
    }

    private static class FeedServerNode
    implements Runnable {
        TreeNodeMapCatalogServer server;
        List<Workspace> workspaces;

        public FeedServerNode(TreeNodeMapCatalogServer server, List<Workspace> workspaces) {
            this.server = server;
            this.workspaces = workspaces;
        }

        @Override
        public void run() {
            if (this.workspaces != null) {
                for (Workspace workspace : this.workspaces) {
                    this.server.addWorkspace(workspace);
                }
                this.server.setServerStatus(TreeNodeMapCatalogServer.SERVER_STATUS.CONNECTED);
            } else {
                this.server.setServerStatus(TreeNodeMapCatalogServer.SERVER_STATUS.UNREACHABLE);
            }
        }
    }
}

