/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager.jobs;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.opengis.ows._2.LanguageStringType;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.layerModel.OwsMapContext;
import org.orbisgis.mapeditor.map.mapsManager.TreeLeafMapElement;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.view.background.BackgroundJob;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ReadStoredMap
implements BackgroundJob {
    private static final I18n I18N = I18nFactory.getI18n(ReadStoredMap.class);
    List<TreeLeafMapElement> mapContextFiles;

    public ReadStoredMap(TreeLeafMapElement mapContextFile) {
        this.mapContextFiles = new ArrayList<TreeLeafMapElement>();
        this.mapContextFiles.add(mapContextFile);
    }

    public ReadStoredMap(List<TreeLeafMapElement> mapContextFiles) {
        this.mapContextFiles = mapContextFiles;
    }

    public void run(ProgressMonitor pm) {
        for (int elIndex = 0; elIndex < this.mapContextFiles.size(); ++elIndex) {
            LanguageStringType title;
            OwsMapContext mapContext;
            TreeLeafMapElement mapEl = this.mapContextFiles.get(elIndex);
            MapContext el = mapEl.getMapElement(pm, mapEl.getDataManager()).getMapContext();
            if (el instanceof OwsMapContext && (mapContext = (OwsMapContext)el).getJAXBObject().getGeneral() != null && (title = mapContext.getJAXBObject().getGeneral().getTitle()) != null && !title.getValue().isEmpty()) {
                SwingUtilities.invokeLater(new DoRename(mapEl, title.getValue()));
            }
            pm.progressTo((long)(elIndex / this.mapContextFiles.size() * 100));
            if (!pm.isCancelled()) continue;
            return;
        }
    }

    public String getTaskName() {
        return I18N.tr("Parse maps title and description");
    }

    private static class DoRename
    implements Runnable {
        TreeLeafMapElement treeNode;
        String newLabel;

        public DoRename(TreeLeafMapElement treeNode, String newLabel) {
            this.treeNode = treeNode;
            this.newLabel = newLabel;
        }

        @Override
        public void run() {
            this.treeNode.setLabel(this.newLabel);
        }
    }
}

