/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.mapsManager.jobs;

import java.io.IOException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.layerModel.mapcatalog.Workspace;
import org.orbisgis.mapeditor.map.mapsManager.TreeNodeWorkspace;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.view.background.BackgroundJob;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class UploadMapContext
implements BackgroundJob {
    private static final I18n I18N = I18nFactory.getI18n(UploadMapContext.class);
    private static final Logger LOGGER = Logger.getLogger(UploadMapContext.class);
    private MapContext mapContext;
    private TreeNodeWorkspace workspaceNode;
    private Integer mapContextid;

    public UploadMapContext(MapContext mapContext, TreeNodeWorkspace workspaceNode, int mapContextid) {
        this.mapContext = mapContext;
        this.workspaceNode = workspaceNode;
        this.mapContextid = mapContextid;
    }

    public UploadMapContext(MapContext mapContext, TreeNodeWorkspace workspaceNode) {
        this.mapContext = mapContext;
        this.workspaceNode = workspaceNode;
        this.mapContextid = null;
    }

    public void run(ProgressMonitor pm) {
        Workspace workspace = this.workspaceNode.getWorkspace();
        try {
            workspace.publishMapContext(this.mapContext, this.mapContextid);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UploadMapContext.this.workspaceNode.update();
                }
            });
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public String getTaskName() {
        return I18N.tr("Uploading the map context..");
    }
}

