/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import org.orbisgis.coremap.map.MapTransform;
import org.orbisgis.mapeditor.map.tool.CannotChangeGeometryException;
import org.orbisgis.mapeditor.map.tool.Handler;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractHandler
implements Handler {
    protected static final I18n I18N = I18nFactory.getI18n(AbstractHandler.class);
    protected static GeometryFactory gf = new GeometryFactory();
    protected int vertexIndex;
    protected Coordinate point;
    protected Geometry geometry;
    protected long geomIndex;

    public AbstractHandler(Geometry g, int vertexIndex, Coordinate p, long geomIndex) {
        this.vertexIndex = vertexIndex;
        this.point = p;
        this.geometry = g;
        this.geomIndex = geomIndex;
    }

    @Override
    public void draw(Graphics2D g2, Color color, ToolManager tm, MapTransform transform) {
        g2.setColor(color);
        Point p = transform.fromMapPoint(this.getPoint());
        int tol = tm.getUITolerance();
        g2.drawRect(p.x - tol / 2, p.y - tol / 2, tol, tol);
    }

    @Override
    public Point2D getPoint() {
        return new Point2D.Double(this.point.x, this.point.y);
    }

    protected Coordinate[] removeVertex(int vertexIndex, Geometry g, int minNumVertex) throws CannotChangeGeometryException {
        int i;
        Coordinate[] coords = g.getCoordinates();
        if (coords.length <= minNumVertex) {
            throw new CannotChangeGeometryException(I18N.tr("Invalid geometry. Too few vertex"));
        }
        Coordinate[] newCoords = new Coordinate[coords.length - 1];
        for (i = 0; i < vertexIndex; ++i) {
            newCoords[i] = new Coordinate(coords[i].x, coords[i].y);
        }
        if (vertexIndex != coords.length - 1) {
            for (i = vertexIndex + 1; i < coords.length; ++i) {
                newCoords[i - 1] = new Coordinate(coords[i].x, coords[i].y);
            }
        }
        return newCoords;
    }

    @Override
    public long getGeometryPK() {
        return this.geomIndex;
    }
}

