/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import org.orbisgis.mapeditor.map.tool.AbstractHandler;
import org.orbisgis.mapeditor.map.tool.CannotChangeGeometryException;
import org.orbisgis.mapeditor.map.tool.Handler;
import org.orbisgis.mapeditor.map.tool.PolygonHandler;

public class MultiPolygonHandler
extends AbstractHandler
implements Handler {
    private int polygonIndex;
    private int holeIndex;

    public MultiPolygonHandler(Geometry g, int polygonIndex, int holeIndex, int vertexIndex, Coordinate p, long geomPk) {
        super(g, vertexIndex, p, geomPk);
        this.polygonIndex = polygonIndex;
        this.holeIndex = holeIndex;
    }

    @Override
    public Geometry moveTo(double x, double y) throws CannotChangeGeometryException {
        MultiPolygon mp = (MultiPolygon)this.geometry.clone();
        Polygon[] polygons = new Polygon[mp.getNumGeometries()];
        for (int i = 0; i < polygons.length; ++i) {
            if (i == this.polygonIndex) {
                PolygonHandler handler = new PolygonHandler((Geometry)((Polygon)mp.getGeometryN(i)), this.holeIndex, this.vertexIndex, null, this.geomIndex);
                polygons[i] = handler.moveJTSTo(x, y);
                continue;
            }
            polygons[i] = (Polygon)mp.getGeometryN(i);
        }
        mp = gf.createMultiPolygon(polygons);
        if (!mp.isValid()) {
            throw new CannotChangeGeometryException(I18N.tr("Invalid multipolygon"));
        }
        return mp;
    }

    @Override
    public Geometry remove() throws TopologyException {
        MultiPolygon mp = (MultiPolygon)this.geometry;
        Polygon[] polygons = new Polygon[mp.getNumGeometries()];
        int vIndex = this.vertexIndex;
        for (int i = 0; i < polygons.length; ++i) {
            if (i == this.polygonIndex) {
                PolygonHandler handler = new PolygonHandler((Geometry)((Polygon)mp.getGeometryN(i)), this.holeIndex, vIndex, null, this.geomIndex);
                polygons[i] = (Polygon)handler.removeVertex();
                continue;
            }
            polygons[i] = (Polygon)mp.getGeometryN(i);
        }
        mp = gf.createMultiPolygon(polygons);
        if (!mp.isValid()) {
            throw new TopologyException(I18N.tr("Invalid multipolygon"));
        }
        return mp;
    }
}

