/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.TopologyException;
import org.orbisgis.mapeditor.map.tool.AbstractHandler;
import org.orbisgis.mapeditor.map.tool.CannotChangeGeometryException;
import org.orbisgis.mapeditor.map.tool.Handler;
import org.orbisgis.mapeditor.map.tool.PointHandler;

public class MultilineHandler
extends AbstractHandler
implements Handler {
    private int linestringIndex;

    public MultilineHandler(Geometry g, int linestringIndex, int vertexIndex, Coordinate p, long geomPk) {
        super(g, vertexIndex, p, geomPk);
        this.linestringIndex = linestringIndex;
    }

    @Override
    public Geometry moveTo(double x, double y) throws CannotChangeGeometryException {
        Coordinate p = new Coordinate(x, y);
        MultiLineString mls = (MultiLineString)this.geometry.clone();
        LineString[] lineString = new LineString[mls.getNumGeometries()];
        for (int i = 0; i < lineString.length; ++i) {
            if (i == this.linestringIndex) {
                PointHandler handler = new PointHandler(mls.getGeometryN(i), this.vertexIndex, p, this.geomIndex);
                lineString[i] = (LineString)handler.moveJTSTo(x, y);
                continue;
            }
            lineString[i] = (LineString)mls.getGeometryN(i);
        }
        mls = gf.createMultiLineString(lineString);
        if (!mls.isValid()) {
            throw new CannotChangeGeometryException(I18N.tr("Invalid MultiLineString"));
        }
        return mls;
    }

    @Override
    public Geometry remove() throws TopologyException {
        MultiLineString mls = (MultiLineString)this.geometry;
        LineString[] linestrings = new LineString[mls.getNumGeometries()];
        int vIndex = this.vertexIndex;
        for (int i = 0; i < linestrings.length; ++i) {
            if (i == this.linestringIndex) {
                PointHandler handler = new PointHandler(mls.getGeometryN(i), vIndex, null, this.geomIndex);
                linestrings[i] = (LineString)handler.removeVertex();
                continue;
            }
            linestrings[i] = (LineString)mls.getGeometryN(i);
        }
        mls = gf.createMultiLineString(linestrings);
        if (!mls.isValid()) {
            throw new TopologyException(I18N.tr("Invalid MultiLineString"));
        }
        return mls;
    }
}

