/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.TopologyException;
import org.orbisgis.core.geometryUtils.GeometryEdit;
import org.orbisgis.mapeditor.map.tool.AbstractHandler;
import org.orbisgis.mapeditor.map.tool.CannotChangeGeometryException;
import org.orbisgis.mapeditor.map.tool.Handler;
import org.orbisgis.mapeditor.map.tool.PointHandler;

public class MultipointHandler
extends AbstractHandler
implements Handler {
    private int pointIndex;

    public MultipointHandler(Geometry g, int pointIndex, int vertexIndex, Coordinate p, long geomPk) {
        super(g, vertexIndex, p, geomPk);
        this.pointIndex = pointIndex;
    }

    @Override
    public Geometry moveTo(double x, double y) throws CannotChangeGeometryException {
        Coordinate p = new Coordinate(x, y);
        MultiPoint mp = (MultiPoint)this.geometry.clone();
        Point[] points = new Point[mp.getNumGeometries()];
        for (int i = 0; i < points.length; ++i) {
            if (i == this.pointIndex) {
                PointHandler handler = new PointHandler(mp.getGeometryN(i), 0, p, this.geomIndex);
                points[i] = (Point)handler.moveJTSTo(x, y);
                continue;
            }
            points[i] = (Point)mp.getGeometryN(i);
        }
        mp = gf.createMultiPoint(points);
        if (!mp.isValid()) {
            throw new CannotChangeGeometryException(I18N.tr("Invalid MultiPoint"));
        }
        return mp;
    }

    @Override
    public Geometry remove() throws TopologyException {
        MultiPoint mp = (MultiPoint)this.geometry;
        if (!(mp = GeometryEdit.removeVertex((MultiPoint)mp, (int)this.pointIndex)).isValid()) {
            throw new TopologyException(I18N.tr("Invalid MultiPoint"));
        }
        return mp;
    }
}

