/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.TopologyException;
import org.orbisgis.core.geometryUtils.GeometryEdit;
import org.orbisgis.mapeditor.map.tool.AbstractHandler;
import org.orbisgis.mapeditor.map.tool.CannotChangeGeometryException;
import org.orbisgis.mapeditor.map.tool.Handler;

public class PointHandler
extends AbstractHandler
implements Handler {
    public PointHandler(Geometry g, int vertexIndex, Coordinate p, long geomPk) {
        super(g, vertexIndex, p, geomPk);
    }

    public Geometry moveJTSTo(final double x, final double y) throws CannotChangeGeometryException {
        Geometry ret = (Geometry)this.geometry.clone();
        ret.apply(new CoordinateSequenceFilter(){
            private boolean done = false;

            public boolean isGeometryChanged() {
                return true;
            }

            public boolean isDone() {
                return this.done;
            }

            public void filter(CoordinateSequence seq, int i) {
                if (i == PointHandler.this.vertexIndex) {
                    seq.setOrdinate(i, 0, x);
                    seq.setOrdinate(i, 1, y);
                    this.done = true;
                }
            }
        });
        return ret;
    }

    @Override
    public Geometry moveTo(double x, double y) throws CannotChangeGeometryException {
        Geometry ret = this.moveJTSTo(x, y);
        if (!ret.isValid()) {
            throw new CannotChangeGeometryException(I18N.tr("The geometry is not valid"));
        }
        return ret;
    }

    public Geometry removeVertex() throws TopologyException {
        if (this.geometry instanceof MultiPoint) {
            return GeometryEdit.removeVertex((MultiPoint)((MultiPoint)this.geometry), (int)this.vertexIndex);
        }
        if (this.geometry instanceof LineString) {
            return GeometryEdit.removeVertex((LineString)((LineString)this.geometry), (int)this.vertexIndex);
        }
        throw new RuntimeException();
    }

    @Override
    public Geometry remove() throws TopologyException {
        if (this.geometry instanceof Point) {
            throw new TopologyException(I18N.tr("Cannot remove a vertex from a point geometry"));
        }
        if (this.geometry instanceof LineString || this.geometry instanceof MultiPoint) {
            Geometry g = this.removeVertex();
            if (!g.isValid()) {
                throw new TopologyException(I18N.tr("The geometry is not valid"));
            }
            return g;
        }
        throw new RuntimeException();
    }
}

