/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import org.orbisgis.core.geometryUtils.GeometryEdit;
import org.orbisgis.mapeditor.map.tool.AbstractHandler;
import org.orbisgis.mapeditor.map.tool.CannotChangeGeometryException;
import org.orbisgis.mapeditor.map.tool.Handler;

public class PolygonHandler
extends AbstractHandler
implements Handler {
    private int holeIndex;

    public PolygonHandler(Geometry geom, int holeIndex, int vertexIndex, Coordinate p, long geomPk) {
        super(geom, vertexIndex, p, geomPk);
        this.holeIndex = holeIndex;
    }

    public Geometry removeVertex() throws TopologyException {
        Polygon ret = null;
        Polygon p = (Polygon)this.geometry;
        if (this.holeIndex == -1) {
            LinearRing ring = this.removePolygonVertex(this.vertexIndex, (Geometry)p);
            LinearRing[] interiorRings = new LinearRing[p.getNumInteriorRing()];
            for (int i = 0; i < interiorRings.length; ++i) {
                interiorRings[i] = gf.createLinearRing(p.getInteriorRingN(i).getCoordinates());
            }
            ret = gf.createPolygon(gf.createLinearRing(ring.getCoordinates()), interiorRings);
        } else {
            LineString ls = p.getInteriorRingN(this.holeIndex);
            LinearRing ring = this.removePolygonVertex(this.vertexIndex, (Geometry)ls);
            LinearRing[] interiorRings = new LinearRing[p.getNumInteriorRing()];
            for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                interiorRings[i] = i == this.holeIndex ? gf.createLinearRing(ring.getCoordinates()) : gf.createLinearRing(p.getInteriorRingN(i).getCoordinates());
            }
            ret = gf.createPolygon(gf.createLinearRing(p.getExteriorRing().getCoordinates()), interiorRings);
        }
        if (!ret.isValid()) {
            throw new TopologyException(I18N.tr("The geometry is not valid"));
        }
        return ret;
    }

    @Override
    public Geometry remove() throws TopologyException {
        Geometry ret = this.removeVertex();
        if (!ret.isValid()) {
            throw new TopologyException(I18N.tr("The geometry is not valid"));
        }
        return ret;
    }

    public Polygon moveJTSTo(double x, double y) throws CannotChangeGeometryException {
        Polygon p = (Polygon)this.geometry.clone();
        Coordinate[] coords = this.holeIndex == -1 ? p.getCoordinates() : p.getInteriorRingN(this.holeIndex).getCoordinates();
        coords[this.vertexIndex].x = x;
        coords[this.vertexIndex].y = y;
        if (this.vertexIndex == 0) {
            coords[coords.length - 1].x = coords[0].x;
            coords[coords.length - 1].y = coords[0].y;
        }
        p.geometryChanged();
        return p;
    }

    @Override
    public Geometry moveTo(double x, double y) throws CannotChangeGeometryException {
        Polygon g = this.moveJTSTo(x, y);
        if (!g.isValid()) {
            throw new CannotChangeGeometryException(I18N.tr("The geometry is not valid"));
        }
        return g;
    }

    private LinearRing removePolygonVertex(int vertexIndex, Geometry p) throws TopologyException {
        LinearRing ret;
        Coordinate[] coords = GeometryEdit.removeVertex((int)vertexIndex, (Geometry)p, (int)4);
        if (vertexIndex == 0) {
            coords[coords.length - 1].x = coords[0].x;
            coords[coords.length - 1].y = coords[0].y;
        }
        if (!(ret = gf.createLinearRing(coords)).isValid()) {
            throw new TopologyException(I18N.tr("The geometry is not valid"));
        }
        return ret;
    }
}

