/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import org.orbisgis.mapeditor.map.tool.Handler;
import org.orbisgis.mapeditor.map.tool.MultiPolygonHandler;
import org.orbisgis.mapeditor.map.tool.MultilineHandler;
import org.orbisgis.mapeditor.map.tool.MultipointHandler;
import org.orbisgis.mapeditor.map.tool.PointHandler;
import org.orbisgis.mapeditor.map.tool.PolygonHandler;

public class Primitive {
    private Geometry geometry;
    private long geomPK;

    public Primitive(Geometry g, long geomPK) {
        this.geometry = g;
        this.geomPK = geomPK;
    }

    public Handler[] getHandlers() {
        if (this.geometry instanceof Point || this.geometry instanceof LineString) {
            Coordinate[] hndPoints = this.geometry.getCoordinates();
            Handler[] ret = new Handler[hndPoints.length];
            for (int i = 0; i < hndPoints.length; ++i) {
                ret[i] = new PointHandler(this.geometry, i, hndPoints[i], this.geomPK);
            }
            return ret;
        }
        if (this.geometry instanceof MultiPoint) {
            ArrayList<MultipointHandler> retArray = new ArrayList<MultipointHandler>();
            for (int g = 0; g < this.geometry.getNumGeometries(); ++g) {
                Coordinate[] hndPoints = this.geometry.getGeometryN(g).getCoordinates();
                for (int i = 0; i < hndPoints.length; ++i) {
                    retArray.add(new MultipointHandler(this.geometry, g, i, hndPoints[i], this.geomPK));
                }
            }
            return retArray.toArray(new Handler[retArray.size()]);
        }
        if (this.geometry instanceof MultiLineString) {
            ArrayList<MultilineHandler> retArray = new ArrayList<MultilineHandler>();
            for (int g = 0; g < this.geometry.getNumGeometries(); ++g) {
                Coordinate[] hndPoints = this.geometry.getGeometryN(g).getCoordinates();
                for (int i = 0; i < hndPoints.length; ++i) {
                    retArray.add(new MultilineHandler(this.geometry, g, i, hndPoints[i], this.geomPK));
                }
            }
            return retArray.toArray(new Handler[retArray.size()]);
        }
        if (this.geometry instanceof Polygon) {
            ArrayList<PolygonHandler> retArray = new ArrayList<PolygonHandler>();
            for (int g = 0; g < this.geometry.getNumGeometries(); ++g) {
                Coordinate[] hndPoints = this.geometry.getGeometryN(g).getCoordinates();
                for (int i = 0; i < hndPoints.length; ++i) {
                    retArray.add(new PolygonHandler(this.geometry, g - 1, i, hndPoints[i], this.geomPK));
                }
            }
            return retArray.toArray(new Handler[retArray.size()]);
        }
        if (this.geometry instanceof MultiPolygon) {
            ArrayList<MultiPolygonHandler> retArray = new ArrayList<MultiPolygonHandler>();
            for (int g = 0; g < this.geometry.getNumGeometries(); ++g) {
                Geometry pol = this.geometry.getGeometryN(g);
                for (int r = 0; r < pol.getNumGeometries(); ++r) {
                    Coordinate[] hndPoints = pol.getGeometryN(r).getCoordinates();
                    for (int i = 0; i < hndPoints.length; ++i) {
                        retArray.add(new MultiPolygonHandler(this.geometry, g, r - 1, i, hndPoints[i], this.geomPK));
                    }
                }
            }
            return retArray.toArray(new Handler[retArray.size()]);
        }
        throw new UnsupportedOperationException("for geometry type : " + this.geometry.getGeometryType());
    }
}

