/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tool;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.sql.rowset.JdbcRowSet;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.orbisgis.corejdbc.ReversibleRowSet;
import org.orbisgis.corejdbc.common.IntegerUnion;
import org.orbisgis.coremap.layerModel.ILayer;
import org.orbisgis.coremap.layerModel.LayerListener;
import org.orbisgis.coremap.layerModel.LayerListenerAdapter;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.layerModel.SelectionEvent;
import org.orbisgis.coremap.map.MapTransform;
import org.orbisgis.coremap.map.TransformListener;
import org.orbisgis.coremap.renderer.se.AreaSymbolizer;
import org.orbisgis.coremap.renderer.se.LineSymbolizer;
import org.orbisgis.coremap.renderer.se.PointSymbolizer;
import org.orbisgis.coremap.renderer.se.Style;
import org.orbisgis.coremap.renderer.se.fill.SolidFill;
import org.orbisgis.coremap.renderer.se.graphic.MarkGraphic;
import org.orbisgis.coremap.renderer.se.parameter.ParameterException;
import org.orbisgis.coremap.renderer.se.parameter.color.ColorLiteral;
import org.orbisgis.coremap.renderer.se.parameter.color.ColorParameter;
import org.orbisgis.coremap.renderer.se.parameter.real.RealLiteral;
import org.orbisgis.coremap.renderer.se.parameter.real.RealParameter;
import org.orbisgis.coremap.renderer.se.stroke.PenStroke;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.Handler;
import org.orbisgis.mapeditor.map.tool.NoSuchTransitionException;
import org.orbisgis.mapeditor.map.tool.Primitive;
import org.orbisgis.mapeditor.map.tool.ToolListener;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.PanTool;
import org.orbisgis.mapeditor.map.tools.ToolUtilities;
import org.orbisgis.mapeditor.map.tools.ZoomInTool;
import org.orbisgis.mapeditor.map.tools.ZoomOutTool;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ToolManager
implements MouseListener,
MouseWheelListener,
MouseMotionListener {
    public static GeometryFactory toolsGeometryFactory = new GeometryFactory();
    private static final I18n I18N = I18nFactory.getI18n(ToolManager.class);
    private static Logger UILOGGER = Logger.getLogger((String)("gui." + ToolManager.class));
    private static final int TRY_LOCK_TIME = 5000;
    private Automaton currentTool;
    private ILayer activeLayer = null;
    private PropertyChangeListener mapContextListener;
    private double[] values = new double[0];
    private int uiTolerance = 6;
    private boolean selectionImageDirty = true;
    private Image selectionImage;
    private java.awt.Point adjustedPoint = null;
    private Point2D worldAdjustedPoint = null;
    private int lastMouseX;
    private int lastMouseY;
    private ArrayList<Handler> currentHandlers = new ArrayList();
    private JPopupMenu toolPopUp;
    private int mouseModifiers;
    private Automaton defaultTool;
    private static final Color HANDLER_COLOR = Color.BLUE;
    private ArrayList<Geometry> geomToDraw = new ArrayList();
    private ArrayList<String> textToDraw = new ArrayList();
    private Component component;
    private MapTransform mapTransform;
    private ToolLayerListener layerListener = new ToolLayerListener();
    private MapContext mapContext;
    private ArrayList<ToolListener> listeners = new ArrayList();
    private boolean showPopup;
    private AreaSymbolizer areaSymbolizer;
    private LineSymbolizer lineSymbolizer;
    private PointSymbolizer pointSymbolizer;
    private ReversibleRowSet activeLayerRowSet;

    public ToolManager(Automaton defaultTool, MapContext mapContext, MapTransform mapTransform, Component component) throws TransitionException {
        this.mapTransform = mapTransform;
        this.component = component;
        this.mapContext = mapContext;
        this.setTool(defaultTool);
        this.defaultTool = defaultTool;
        this.updateCursor();
        this.mapContextListener = EventHandler.create(PropertyChangeListener.class, this, "activeLayerChanged", "");
        this.mapContext.addPropertyChangeListener("activeLayer", this.mapContextListener);
        mapTransform.addTransformListener(new TransformListener(){

            public void extentChanged(Envelope oldExtent, MapTransform mapTransform) {
                ToolManager.this.recalculateHandlers();
            }

            public void imageSizeChanged(int oldWidth, int oldHeight, MapTransform mapTransform) {
                ToolManager.this.recalculateHandlers();
            }
        });
        this.buildSymbolizers();
    }

    public void activeLayerChanged(PropertyChangeEvent evt) {
        block8: {
            this.removeSourceListener();
            this.activeLayer = (ILayer)evt.getNewValue();
            if (this.activeLayerRowSet != null) {
                try {
                    this.activeLayerRowSet.close();
                }
                catch (SQLException ex) {
                    UILOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            if (this.activeLayer != null) {
                this.activeLayer.addLayerListener((LayerListener)this.layerListener);
                try {
                    JdbcRowSet rowSet = this.activeLayer.getDataManager().createJdbcRowSet();
                    if (rowSet instanceof ReversibleRowSet) {
                        this.activeLayerRowSet = (ReversibleRowSet)rowSet;
                        this.activeLayerRowSet.setCommand("SELECT * FROM " + this.activeLayer.getTableReference());
                        this.activeLayerRowSet.execute();
                        break block8;
                    }
                    UILOGGER.warn((Object)I18N.tr("Unable to generate edition tool on the table %s for the map editor, edition is deactivated", (Object)this.activeLayer.getTableReference()));
                }
                catch (SQLException ex) {
                    UILOGGER.warn((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
            } else {
                this.activeLayerRowSet = null;
            }
        }
        this.setTool(this.defaultTool);
        this.recalculateHandlers();
    }

    public ReversibleRowSet getActiveLayerRowSet() {
        return this.activeLayerRowSet;
    }

    private void removeSourceListener() {
        if (this.activeLayer != null) {
            this.activeLayer.removeLayerListener((LayerListener)this.layerListener);
            this.setTool(this.defaultTool);
        }
    }

    public void freeResources() {
        this.removeSourceListener();
        this.mapContext.removePropertyChangeListener(this.mapContextListener);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastMouseX = e.getPoint().x;
        this.lastMouseY = e.getPoint().y;
        if (this.mapContext.getLayerModel().getLayerCount() != 0) {
            this.component.repaint();
        }
        this.setAdjustedHandler();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            if (e.getClickCount() == 2) {
                this.leftClickTransition(e, Automaton.Code.TERMINATE);
            } else {
                this.leftClickTransition(e, Automaton.Code.POINT);
            }
        } else if (e.getButton() == 3 && this.showPopup) {
            this.toolPopUp.show(this.component, e.getPoint().x, e.getPoint().y);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        Automaton oldTool = this.getTool();
        if (notches < 0) {
            this.setTool(new ZoomInTool());
        } else {
            this.setTool(new ZoomOutTool());
        }
        this.leftClickTransition(e, Automaton.Code.PRESS);
        this.leftClickTransition(e, Automaton.Code.RELEASE);
        this.leftClickTransition(e, Automaton.Code.POINT);
        this.setTool(oldTool);
    }

    private void leftClickTransition(MouseEvent e, Automaton.Code transitionCode) {
        try {
            java.awt.Point p = e.getPoint();
            if (this.worldAdjustedPoint != null) {
                this.setValues(new double[]{this.worldAdjustedPoint.getX(), this.worldAdjustedPoint.getY()});
            } else {
                Point2D mapPoint = this.mapTransform.toMapPoint((int)((Point2D)p).getX(), (int)((Point2D)p).getY());
                this.setValues(new double[]{mapPoint.getX(), mapPoint.getY()});
            }
            this.mouseModifiers = e.getModifiersEx();
            this.transition(transitionCode);
            this.fireStateChanged();
        }
        catch (NoSuchTransitionException e1) {
        }
        catch (TransitionException e1) {
            this.fireToolError(e1);
        }
    }

    public void updateToolsStatus() {
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        for (ToolListener listener : this.listeners) {
            try {
                listener.stateChanged(this);
            }
            catch (Exception ex) {
                UILOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }

    private void fireCurrentToolChanged(Automaton last) {
        if (last == null || !last.equals(this.currentTool)) {
            for (ToolListener listener : this.listeners) {
                listener.currentToolChanged(last, this);
            }
        }
    }

    private void fireToolError(TransitionException e) {
        for (ToolListener listener : this.listeners) {
            listener.transitionException(this, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.leftClickTransition(e, Automaton.Code.PRESS);
        } else if (e.getButton() == 2) {
            this.setTool(new PanTool());
            this.leftClickTransition(e, Automaton.Code.PRESS);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 || e.getButton() == 2) {
            this.leftClickTransition(e, Automaton.Code.RELEASE);
        }
    }

    private void setAdjustedHandler() {
        this.adjustedPoint = null;
        this.worldAdjustedPoint = null;
        for (int i = 0; i < this.currentHandlers.size(); ++i) {
            java.awt.Point p = this.mapTransform.fromMapPoint(this.currentHandlers.get(i).getPoint());
            if (!(p.distance(this.lastMouseX, this.lastMouseY) < (double)this.uiTolerance)) continue;
            this.adjustedPoint = new java.awt.Point((int)((Point2D)p).getX(), (int)((Point2D)p).getY());
            this.worldAdjustedPoint = this.currentHandlers.get(i).getPoint();
            UILOGGER.info((Object)this.worldAdjustedPoint);
            break;
        }
    }

    public void paintEdition(Graphics g) {
        try {
            if (this.selectionImageDirty) {
                this.selectionImage = new BufferedImage(this.mapTransform.getWidth(), this.mapTransform.getHeight(), 2);
                Graphics2D g2 = (Graphics2D)this.selectionImage.getGraphics();
                for (Handler handler : this.currentHandlers) {
                    handler.draw(g2, HANDLER_COLOR, this, this.mapTransform);
                }
                this.selectionImageDirty = false;
            }
            g.drawImage(this.selectionImage, 0, 0, null);
            String error = null;
            this.geomToDraw.clear();
            this.textToDraw.clear();
            try {
                this.currentTool.draw(g);
            }
            catch (Exception e) {
                error = e.getMessage();
            }
            Graphics2D g2 = (Graphics2D)g;
            for (Geometry geometry : this.geomToDraw) {
                try {
                    BufferedImage bi = new BufferedImage(this.mapTransform.getWidth(), this.mapTransform.getHeight(), 2);
                    Graphics2D graphics = bi.createGraphics();
                    this.drawFeature(graphics, geometry, this.mapTransform);
                    g2.drawImage((Image)bi, 0, 0, null);
                }
                catch (SQLException ex) {
                    UILOGGER.debug((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            if (this.adjustedPoint != null) {
                g2.setStroke(new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{5.0f, 3.0f, 3.0f, 3.0f}, 0.0f));
                g2.setColor(Color.red);
                g2.drawArc(this.adjustedPoint.x - this.uiTolerance, this.adjustedPoint.y - this.uiTolerance, 2 * this.uiTolerance, 2 * this.uiTolerance, 0, 360);
            }
            if (error != null) {
                this.drawTextWithWhiteBackGround(g2, error, new Point2D.Double(this.lastMouseX, this.lastMouseY));
            } else {
                Font f = g2.getFont();
                g2.setFont(f.deriveFont(1, 16.0f));
                g2.setColor(Color.black);
                int height = this.lastMouseY + 3 * this.uiTolerance;
                for (String text : this.textToDraw) {
                    g2.drawString(text, this.lastMouseX + this.uiTolerance, height);
                    height = (int)((double)height + g2.getFontMetrics().getStringBounds(text, g2).getHeight());
                }
                g2.setFont(f);
            }
        }
        catch (ParameterException pe) {
            UILOGGER.error((Object)(I18N.tr("Error while drawing the feature, ") + pe.getMessage()));
        }
        catch (IOException ie) {
            UILOGGER.error((Object)(I18N.tr("Error while accessing data, ") + ie.getMessage()));
        }
    }

    private void drawTextWithWhiteBackGround(Graphics2D g2, String text, Point2D p) {
        TextLayout tl = new TextLayout(text, g2.getFont(), g2.getFontRenderContext());
        g2.setColor(Color.WHITE);
        Rectangle2D textBounds = tl.getBounds();
        g2.fill(new Rectangle2D.Double(textBounds.getX() + p.getX(), textBounds.getY() + p.getY(), textBounds.getWidth(), textBounds.getHeight()));
        g2.setColor(Color.BLACK);
        tl.draw(g2, (float)p.getX(), (float)p.getY());
    }

    private void drawCursor(Graphics g) {
        int x = 0;
        int y = 0;
        g.setColor(Color.BLACK);
        g.drawRect(x - this.uiTolerance / 2, y - this.uiTolerance / 2, this.uiTolerance, this.uiTolerance);
        g.drawLine(x, y - 2 * this.uiTolerance, x, y + 2 * this.uiTolerance);
        g.drawLine(x - 2 * this.uiTolerance, y, x + 2 * this.uiTolerance, y);
    }

    private void updateCursor() {
        Cursor c;
        ImageIcon cursor = this.getTool().getCursor();
        if (cursor == null) {
            Cursor crossCursor;
            BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(32, 32, 2);
            Graphics2D g = image.createGraphics();
            g.setTransform(AffineTransform.getTranslateInstance(16.0, 16.0));
            this.drawCursor(g);
            c = crossCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new java.awt.Point(16, 16), "crossCursor");
        } else {
            java.awt.Point hotSpot = this.getTool().getHotSpotOffset();
            c = Toolkit.getDefaultToolkit().createCustomCursor(cursor.getImage(), hotSpot, "");
        }
        this.component.setCursor(c);
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public double getTolerance() {
        return (double)this.uiTolerance / this.mapTransform.getAffineTransform().getScaleX();
    }

    public void setUITolerance(int tolerance) {
        UILOGGER.info((Object)("setting uiTolerance: " + tolerance));
        this.uiTolerance = tolerance;
    }

    public void transition(Automaton.Code code) throws NoSuchTransitionException, TransitionException {
        if (!this.currentTool.isEnabled(this.mapContext, this) && !this.currentTool.equals(this.defaultTool)) {
            UILOGGER.error((Object)I18N.tr("The current tool is not enabled"));
        } else {
            try {
                this.currentTool.transition(code);
                this.configureMenu();
                this.component.repaint();
            }
            catch (FinishedAutomatonException e) {
                this.setTool(this.currentTool);
            }
            catch (NoSuchTransitionException e) {
                throw e;
            }
            catch (TransitionException e) {
                throw e;
            }
            catch (Throwable e) {
                this.setTool(this.defaultTool);
                throw new RuntimeException(e);
            }
        }
    }

    private void configureMenu() {
        if (ToolUtilities.isRestrictedPopup(this.currentTool)) {
            this.showPopup = false;
        } else {
            this.showPopup = true;
            String[] labels = this.currentTool.getTransitionLabels();
            Automaton.Code[] codes = this.currentTool.getTransitionCodes();
            this.toolPopUp = new JPopupMenu();
            for (int i = 0; i < codes.length; ++i) {
                JMenuItem item = new JMenuItem(labels[i]);
                item.setActionCommand(codes[i].toString().toUpperCase());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            ToolManager.this.transition(Automaton.Code.valueOf(e.getActionCommand().toUpperCase()));
                            ToolManager.this.component.repaint();
                        }
                        catch (NoSuchTransitionException e1) {
                            UILOGGER.error((Object)I18N.tr("Error in the tool."), (Throwable)e1);
                        }
                        catch (TransitionException e1) {
                            ToolManager.this.fireToolError(e1);
                        }
                    }
                });
                this.toolPopUp.add(item);
            }
        }
    }

    public final void setTool(Automaton tool) {
        block8: {
            Automaton lastTool = this.currentTool;
            try {
                if (this.currentTool != null && this.activeLayer != null) {
                    try {
                        this.currentTool.toolFinished(this.mapContext, this);
                    }
                    catch (NoSuchTransitionException e) {
                    }
                    catch (TransitionException e) {
                        // empty catch block
                    }
                }
                this.currentTool = tool;
                this.currentTool.init(this.mapContext, this);
                this.configureMenu();
                this.fireCurrentToolChanged(lastTool);
                this.fireStateChanged();
            }
            catch (FinishedAutomatonException e1) {
                if (!tool.equals(this.defaultTool)) {
                    this.setTool(this.defaultTool);
                }
            }
            catch (TransitionException e1) {
                if (tool.equals(this.defaultTool)) break block8;
                this.setTool(this.defaultTool);
            }
        }
        this.updateCursor();
    }

    public Point2D getLastRealMousePosition() {
        if (this.worldAdjustedPoint != null) {
            return this.worldAdjustedPoint;
        }
        return this.mapTransform.toMapPoint(this.lastMouseX, this.lastMouseY);
    }

    public int getLastMouseX() {
        if (this.adjustedPoint != null) {
            return this.adjustedPoint.x;
        }
        return this.lastMouseX;
    }

    public int getLastMouseY() {
        if (this.adjustedPoint != null) {
            return this.adjustedPoint.y;
        }
        return this.lastMouseY;
    }

    public int getUITolerance() {
        return this.uiTolerance;
    }

    public ArrayList<Handler> getCurrentHandlers() {
        return this.currentHandlers;
    }

    private void recalculateHandlers() {
        this.clearHandlers();
        if (this.activeLayer == null || !this.activeLayer.isVisible() || this.activeLayer.getSelection().isEmpty() || this.activeLayerRowSet == null) {
            return;
        }
        Set selection = this.activeLayer.getSelection();
        Lock readLock = this.activeLayerRowSet.getReadLock();
        try {
            if (readLock.tryLock(5000L, TimeUnit.MILLISECONDS)) {
                IntegerUnion modelRows = new IntegerUnion();
                Iterator i$ = selection.iterator();
                while (i$.hasNext()) {
                    long value = (Long)i$.next();
                    modelRows.add(this.activeLayerRowSet.getRowId((Object)value));
                }
                this.activeLayerRowSet.setFilter((Collection)modelRows);
                this.activeLayerRowSet.beforeFirst();
                while (this.activeLayerRowSet.next()) {
                    Geometry geometry = this.activeLayerRowSet.getGeometry();
                    if (geometry == null) continue;
                    Primitive p = new Primitive(geometry, this.activeLayerRowSet.getLong(this.activeLayerRowSet.getPkName()));
                    Handler[] handlers = p.getHandlers();
                    this.currentHandlers.addAll(Arrays.asList(handlers));
                }
            }
        }
        catch (InterruptedException | SQLException e) {
            readLock.unlock();
            UILOGGER.warn((Object)I18N.tr("Cannot recalculate the handlers"), (Throwable)e);
        }
    }

    private void clearHandlers() {
        this.currentHandlers.clear();
        this.selectionImageDirty = true;
    }

    public int getMouseModifiers() {
        return this.mouseModifiers;
    }

    public void setMouseModifiers(int modifiers) {
        this.mouseModifiers = modifiers;
    }

    public Automaton getTool() {
        return this.currentTool;
    }

    public Automaton getDefaultTool() {
        return this.defaultTool;
    }

    public void addGeomToDraw(Geometry geom) {
        this.geomToDraw.add(geom);
    }

    public void addTextToDraw(String text) {
        this.textToDraw.add(text);
    }

    public void checkToolStatus() {
        if (!this.currentTool.isEnabled(this.mapContext, this) && !this.currentTool.getClass().equals(this.defaultTool.getClass())) {
            this.setTool(this.defaultTool);
        }
    }

    public void addToolListener(ToolListener listener) {
        this.listeners.add(listener);
    }

    public void removeToolListener(ToolListener listener) {
        this.listeners.remove(listener);
    }

    public GeometryFactory getToolsFactory() {
        return toolsGeometryFactory;
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    public MapTransform getMapTransform() {
        return this.mapTransform;
    }

    private void buildSymbolizers() {
        int alpha = 255;
        int r = Color.YELLOW.getRed();
        int g = Color.YELLOW.getGreen();
        int b = Color.YELLOW.getBlue();
        Color col = new Color(r, g, b, alpha);
        this.pointSymbolizer = new PointSymbolizer();
        MarkGraphic mg = (MarkGraphic)this.pointSymbolizer.getGraphicCollection().getGraphic(0);
        ((SolidFill)mg.getFill()).setColor((ColorParameter)new ColorLiteral(col));
        ((SolidFill)mg.getFill()).setOpacity((RealParameter)new RealLiteral(0.5));
        ((SolidFill)((PenStroke)mg.getStroke()).getFill()).setColor((ColorParameter)new ColorLiteral(col));
        ((SolidFill)((PenStroke)mg.getStroke()).getFill()).setOpacity((RealParameter)new RealLiteral(0.8));
        this.lineSymbolizer = new LineSymbolizer();
        PenStroke ps = (PenStroke)this.lineSymbolizer.getStroke();
        ((SolidFill)ps.getFill()).setColor((ColorParameter)new ColorLiteral(col));
        ((SolidFill)ps.getFill()).setOpacity((RealParameter)new RealLiteral(0.8));
        ps.setWidth((RealParameter)new RealLiteral(0.5));
        this.areaSymbolizer = new AreaSymbolizer();
        PenStroke psa = (PenStroke)this.areaSymbolizer.getStroke();
        ((SolidFill)psa.getFill()).setColor((ColorParameter)new ColorLiteral(col));
        psa.setWidth((RealParameter)new RealLiteral(0.5));
        ((SolidFill)psa.getFill()).setOpacity((RealParameter)new RealLiteral(0.8));
        ((SolidFill)this.areaSymbolizer.getFill()).setColor((ColorParameter)new ColorLiteral(Color.YELLOW));
        ((SolidFill)this.areaSymbolizer.getFill()).setOpacity((RealParameter)new RealLiteral(0.5));
    }

    private void drawFeature(Graphics2D graphics, Geometry geometry, MapTransform mapTransform) throws IOException, SQLException, ParameterException {
        if (geometry instanceof Point || geometry instanceof MultiPoint) {
            this.pointSymbolizer.draw(graphics, null, -1L, false, mapTransform, geometry);
        } else if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            this.lineSymbolizer.draw(graphics, null, -1L, false, mapTransform, geometry);
        } else if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            this.areaSymbolizer.draw(graphics, null, -1L, false, mapTransform, geometry);
        } else {
            GeometryCollection gc = (GeometryCollection)geometry;
            int num = gc.getNumGeometries();
            for (int i = 0; i < num; ++i) {
                Geometry geom = gc.getGeometryN(i);
                this.drawFeature(graphics, geom, mapTransform);
            }
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public ILayer[] getSelectedLayerAndStyle() {
        HashSet<ILayer> selectedLayers = new HashSet<ILayer>(Arrays.asList(this.mapContext.getSelectedLayers()));
        for (Style style : this.mapContext.getSelectedStyles()) {
            selectedLayers.add(style.getLayer());
        }
        return selectedLayers.toArray(new ILayer[selectedLayers.size()]);
    }

    private class ToolLayerListener
    extends LayerListenerAdapter
    implements LayerListener {
        private ToolLayerListener() {
        }

        public void selectionChanged(SelectionEvent e) {
            ToolManager.this.recalculateHandlers();
        }
    }
}

