/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.toolbar;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import org.orbisgis.mapeditor.map.ext.AutomatonHolder;
import org.orbisgis.mapeditor.map.ext.MapEditorExtension;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.ToolListener;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.toolbar.ActionMapContext;

public class ActionAutomaton
extends ActionMapContext
implements AutomatonHolder {
    private Automaton automaton;
    private SynchroniseTool toolListener = new SynchroniseTool();

    public ActionAutomaton(String actionId, Automaton automaton, MapEditorExtension extension) {
        super(actionId, automaton.getName(), extension, automaton.getImageIcon());
        this.automaton = automaton;
        this.putValue("ShortDescription", automaton.getTooltip());
        this.putValue("toggleGroupName", "automatons");
        this.putValue("logicalGroup", "DRAWING_GROUP");
        if (extension.getToolManager() != null) {
            this.putValue("SwingSelectedKey", this.isEqual(extension.getToolManager().getTool()));
        }
    }

    private boolean isEqual(Automaton otherAutomaton) {
        return otherAutomaton != null && this.automaton.getClass().getName().equals(otherAutomaton.getClass().getName());
    }

    @Override
    protected void doInit() {
        super.doInit();
        if (this.getExtension().getToolManager() != null) {
            this.getExtension().getToolManager().addToolListener(this.toolListener);
        }
    }

    @Override
    public void onMapEditorUpdate(PropertyChangeEvent evt) {
        super.onMapEditorUpdate(evt);
        if ("toolManager".equals(evt.getPropertyName())) {
            ToolManager oldTool = (ToolManager)evt.getOldValue();
            ToolManager newTool = (ToolManager)evt.getNewValue();
            if (oldTool != null) {
                oldTool.removeToolListener(this.toolListener);
            }
            if (newTool != null) {
                newTool.addToolListener(this.toolListener);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.getExtension() != null && this.getExtension().getToolManager() != null) {
            this.getExtension().getToolManager().removeToolListener(this.toolListener);
        }
    }

    @Override
    protected void checkActionState() {
        boolean automatonState;
        super.checkActionState();
        if (this.getExtension().getMapElement() != null && this.getExtension().getToolManager() != null && (automatonState = this.automaton.isEnabled(this.getExtension().getMapElement().getMapContext(), this.getExtension().getToolManager())) != this.enabled) {
            this.setEnabled(automatonState);
        }
    }

    @Override
    public Automaton getAutomaton() {
        return this.automaton;
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.getValue("SwingSelectedKey").equals(Boolean.TRUE) && this.getExtension().getToolManager() != null) {
            this.getExtension().getToolManager().setTool(this.automaton);
        }
    }

    private class SynchroniseTool
    implements ToolListener {
        private SynchroniseTool() {
        }

        @Override
        public void stateChanged(ToolManager toolManager) {
            ActionAutomaton.this.checkActionState();
        }

        @Override
        public void transitionException(ToolManager toolManager, TransitionException e) {
            ActionAutomaton.this.checkActionState();
        }

        @Override
        public void currentToolChanged(Automaton previous, ToolManager toolManager) {
            if (toolManager.getTool() != null) {
                ActionAutomaton.this.putValue("SwingSelectedKey", ActionAutomaton.this.isEqual(toolManager.getTool()));
            }
        }
    }
}

