/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.toolbar;

import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.ext.MapEditorExtension;
import org.orbisgis.mapeditor.map.toolbar.ActionDisposable;
import org.orbisgis.mapeditorapi.MapElement;
import org.orbisgis.viewapi.components.actions.DefaultAction;

public abstract class ActionMapContext
extends DefaultAction
implements ActionDisposable {
    private MapEditorExtension extension;
    private PropertyChangeListener mapEditorListener = EventHandler.create(PropertyChangeListener.class, this, "onMapEditorUpdate", "");
    private PropertyChangeListener mapContextListener = EventHandler.create(PropertyChangeListener.class, this, "onMapContextUpdate", "");
    private AtomicBoolean isInitialised = new AtomicBoolean(false);
    private Set<String> trackedMapContextProperties = new HashSet<String>();

    public ActionMapContext(String actionId, String name, MapEditorExtension extension, Icon icon) {
        super(actionId, name);
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
        this.extension = extension;
    }

    public boolean isEnabled() {
        this.checkActionState();
        return super.isEnabled();
    }

    public MapEditorExtension getExtension() {
        return this.extension;
    }

    public ActionMapContext setTrackedMapContextProperties(Collection<String> trackedMapContextProperties) {
        this.trackedMapContextProperties = new HashSet<String>(trackedMapContextProperties);
        return this;
    }

    public ActionMapContext addTrackedMapContextProperty(String propertyName) {
        this.trackedMapContextProperties.add(propertyName);
        return this;
    }

    private final void init() {
        if (!this.isInitialised.getAndSet(true)) {
            this.doInit();
        }
    }

    protected void doInit() {
        this.extension.addPropertyChangeListener(this.mapEditorListener);
        if (!this.trackedMapContextProperties.isEmpty() && this.extension.getMapElement() != null) {
            this.installMapContextListener(this.extension.getMapElement().getMapContext());
        }
    }

    protected void removeMapContextListener(MapContext mapContext) {
        mapContext.removePropertyChangeListener(this.mapContextListener);
    }

    protected void installMapContextListener(MapContext mapContext) {
        if (this.trackedMapContextProperties.size() == 1) {
            mapContext.addPropertyChangeListener(this.trackedMapContextProperties.iterator().next(), this.mapContextListener);
        } else if (!this.trackedMapContextProperties.isEmpty()) {
            mapContext.addPropertyChangeListener(this.mapContextListener);
        }
        this.checkActionState();
    }

    public void onMapEditorUpdate(PropertyChangeEvent evt) {
        if ("mapElement".equals(evt.getPropertyName())) {
            MapElement oldMap = (MapElement)evt.getOldValue();
            MapElement newMap = (MapElement)evt.getNewValue();
            if (oldMap != null) {
                this.removeMapContextListener(oldMap.getMapContext());
            }
            if (newMap != null) {
                this.installMapContextListener(newMap.getMapContext());
            }
        }
    }

    public void onMapContextUpdate(PropertyChangeEvent evt) {
        if (this.trackedMapContextProperties.contains(evt.getPropertyName())) {
            this.checkActionState();
        }
    }

    protected void checkActionState() {
        this.init();
    }

    @Override
    public void dispose() {
        if (this.extension != null) {
            this.extension.removePropertyChangeListener(this.mapEditorListener);
            if (this.extension.getMapElement() != null) {
                this.removeMapContextListener(this.extension.getMapElement().getMapContext());
            }
        }
        this.extension = null;
    }
}

