/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.DrawingException;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.InsertionTool;
import org.orbisgis.mapeditor.map.tools.ToolUtilities;
import org.orbisgis.mapeditor.map.tools.generated.Line;

public abstract class AbstractLineTool
extends Line
implements InsertionTool {
    protected List<Coordinate> points = new ArrayList<Coordinate>();

    @Override
    public void transitionTo_Standby(MapContext vc, ToolManager tm) throws FinishedAutomatonException, TransitionException {
        this.points.clear();
    }

    @Override
    public void transitionTo_Point(MapContext vc, ToolManager tm) throws FinishedAutomatonException, TransitionException {
        this.points.add(this.newCoordinate(tm.getValues()[0], tm.getValues()[1], vc));
    }

    @Override
    public void transitionTo_Cancel(MapContext vc, ToolManager tm) throws FinishedAutomatonException, TransitionException {
    }

    @Override
    public void drawIn_Standby(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
    }

    @Override
    public void transitionTo_Done(MapContext vc, ToolManager tm) throws FinishedAutomatonException, TransitionException {
        this.points = ToolUtilities.removeDuplicated(this.points);
        if (this.points.size() < 2) {
            throw new TransitionException(this.i18n.tr("Lines must have at least two points"));
        }
        LineString ls = new GeometryFactory().createLineString(this.points.toArray(new Coordinate[this.points.size()]));
        if (!ls.isValid()) {
            throw new TransitionException(this.i18n.tr("Invalid line"));
        }
        this.lineDone(ls, vc, tm);
        this.transition(Automaton.Code.INIT);
    }

    protected abstract void lineDone(LineString var1, MapContext var2, ToolManager var3) throws TransitionException;

    @Override
    public void drawIn_Point(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
        LineString ls = this.getCurrentLineString(vc, tm);
        tm.addGeomToDraw((Geometry)ls);
        if (!ls.isValid()) {
            throw new DrawingException(this.i18n.tr("Invalid line"));
        }
    }

    protected LineString getCurrentLineString(MapContext mc, ToolManager tm) {
        Point2D current = tm.getLastRealMousePosition();
        ArrayList<Coordinate> tempPoints = new ArrayList<Coordinate>(this.points);
        tempPoints.add(this.newCoordinate(current.getX(), current.getY(), mc));
        return new GeometryFactory().createLineString(tempPoints.toArray(new Coordinate[tempPoints.size()]));
    }

    private Coordinate newCoordinate(double x, double y, MapContext mapContext) {
        return new Coordinate(x, y, this.getInitialZ(mapContext));
    }

    @Override
    public double getInitialZ(MapContext mapContext) {
        return Double.NaN;
    }

    @Override
    public void drawIn_Done(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
    }

    @Override
    public void drawIn_Cancel(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
    }
}

